/*
	4bot FDS Interface, Light Edition
	Copyright 2006 Mark "Saberhawk" Sararu
*/

#include "scripts.h"
#include "engine.h"
#include "jfwhook.h"
#include <fstream>
#include <sys/stat.h>
#include "4bot_Lite.h"
#include "PROFILE.h"
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <vector>

bool WriteOut = true;

std::vector<std::string> VvBKillMsg;
std::vector<std::string> SvBKillMsg;
std::vector<std::string> BvBKillMsg;
std::vector<std::string> VvVKillMsg;
std::vector<std::string> SvVKillMsg;
std::vector<std::string> BvVKillMsg;
std::vector<std::string> BvSKillMsg;
int VvBTotal = 0; 
int SvBTotal = 0; 
int BvBTotal = 0; 
int VvVTotal = 0; 
int SvVTotal = 0; 
int BvVTotal = 0; 
int BvSTotal = 0; 
int AvATotal = 0;

void SHStartup() {
	SetupKillMessages();
	
	Vector3 ControllerLoc;
	ControllerLoc.X = 0.0f;
	ControllerLoc.Y = 0.0f;
	ControllerLoc.Z = 0.0f;

	GameObject *ScriptsController = Commands->Create_Object("Invisible_Object",ControllerLoc);
	Commands->Attach_Script(ScriptsController,"SH_AdvancedConsoleCommand","");
	Commands->Attach_Script(ScriptsController,"SH_ObjectCreated","");
	// Strip this JFW nonsense out
	//Commands->Attach_Script(ScriptsController,"JFW_Attach_Script_Vehicle_Created","SH_VehicleLog,,,2");
	//Commands->Attach_Script(ScriptsController,"JFW_Attach_Script_Player_Created","SH_PlayerLog,,,2");
	Attach_Script_Building("SH_BuildingLog","",2);
	Attach_Script_Preset("SH_BuildingLog","","CnC_Allied_Pillbox",2);
	Attach_Script_Preset("SH_BuildingLog","","Allied_Turret",2);
	Attach_Script_Preset("SH_BuildingLog","","Soviet_Flame_Tower",2);
	Attach_Script_Preset("SH_BuildingLog","","CnC_Allied_AA_Gun",2);
	Attach_Script_Preset("SH_BuildingLog","","CnC_Soviet_SAM_Site",2);
	//SendData("level loaded");
}

void SetupKillMessages() {
//	char msg[512];
	VvBKillMsg.erase(VvBKillMsg.begin(),VvBKillMsg.end());
	SvBKillMsg.erase(SvBKillMsg.begin(),SvBKillMsg.end());
	BvBKillMsg.erase(BvBKillMsg.begin(),BvBKillMsg.end());
	VvVKillMsg.erase(VvVKillMsg.begin(),VvVKillMsg.end());
	SvVKillMsg.erase(SvVKillMsg.begin(),SvVKillMsg.end());
	BvVKillMsg.erase(BvVKillMsg.begin(),BvVKillMsg.end());
	BvSKillMsg.erase(BvSKillMsg.begin(),BvSKillMsg.end());
	VvBTotal = 0; 
	SvBTotal = 0; 
	BvBTotal = 0; 
	VvVTotal = 0; 
	SvVTotal = 0; 
	BvVTotal = 0; 
	BvSTotal = 0; 
	AvATotal = 0;

	int x = 0;
	x = getProfileInt("VvB_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("VvB_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		VvBKillMsg.push_back(value);
		VvBTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("SvB_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("SvB_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		SvBKillMsg.push_back(value);
		SvBTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("BvB_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("BvB_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		BvBKillMsg.push_back(value);
		BvBTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("VvV_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("VvV_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		VvVKillMsg.push_back(value);
		VvVTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("SvV_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("SvV_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		SvVKillMsg.push_back(value);
		SvVTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("BvV_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("BvV_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		BvVKillMsg.push_back(value);
		BvVTotal++;
		AvATotal++;
	}
	x = 0;
	x = getProfileInt("BvS_Kills","Total",0,"apb.ini");
	for (int c = 1; c <= x; c++)
	{
		char key[5],value[256];
		sprintf(key,"%d",c);
		getProfileString("BvS_Kills",key,"Error_BadKillMsg",value,256,"apb.ini");
		BvSKillMsg.push_back(value);
		BvSTotal++;	
		AvATotal++;
	}
	//sprintf(msg,"%d Kill Messages Loaded\n",AvATotal);
	//Console_Output(msg);
}

const char *GetNameOrPreset(GameObject *obj) {
	if (Get_Player_Name(obj) != NULL){
		return Get_Player_Name(obj);
	} else {
		return Commands->Get_Preset_Name(obj); 
	}
}
const char *GetName(GameObject *obj) {
	if (Get_Player_Name(obj) != NULL){
		return Get_Player_Name(obj);
	} else {
		return ""; 
	}
}
const char *TranslatePreset(const char * preset){
	char *msg;
	msg = "";
	getProfileString("Presets",preset,preset,msg,512,"apb.ini");
	return msg;
}
const char *GetPresetInfo(GameObject *obj) {
	return TranslatePreset(Commands->Get_Preset_Name(obj));
}

bool IsBaseDefense (GameObject *obj)  {
	if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Allied_Pillbox") == 0) return true;
	else if (strcmp(Commands->Get_Preset_Name(obj),"Allied_Turret") == 0) return true;
	else if (strcmp(Commands->Get_Preset_Name(obj),"Soviet_Flame_Tower") == 0) return true;
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Allied_AA_Gun") == 0) return true;
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Soviet_SAM_Site") == 0) return true;
	else if (strcmp(Commands->Get_Preset_Name(obj),"Soviet_Tesla") == 0) return true;
	return false;
}
/*int SendData (char* message) {
	if (WriteOut == false) return 0;
	FILE *FP;
	if ((FP = fopen("fds.out", "a")) == NULL) return 0;
	char messageprint[512];
	sprintf(messageprint,"%s\n",message);
	fputs(messageprint, FP );
	fclose( FP );
	return 1;
}
bool fileExists (char * fileName)
{
	struct stat buf;
	int i = stat ( fileName, &buf );
	if ( i == 0 ) return true;
	return false;
}
*/
void VehicleKillMessage (GameObject *obj, GameObject *shooter) {
	if (Get_Vehicle_Occupant_Count(obj) > 0) {		
		char msg[512], shooter_preset[512],obj_preset[512];
		const char *shooter_name, *obj_name;
		bool ShowMessage = false;

		obj_name = GetName(Get_Vehicle_Driver(obj));
		shooter_name = GetName(shooter);//Get_Player_Name(shooter);
		getProfileString("Presets",Commands->Get_Preset_Name(Get_Vehicle_Return(shooter)),Commands->Get_Preset_Name(shooter),shooter_preset,512,"apb.ini");
		getProfileString("Presets",Commands->Get_Preset_Name(obj),Commands->Get_Preset_Name(obj),obj_preset,512,"apb.ini");

		std::string killer(shooter_name),
			killed(obj_name),
			killerpreset(shooter_preset),
			killedpreset(obj_preset),
			KillMsg;
		
		if (Is_Building(shooter)) {
			KillMsg = BvVKillMsg[Commands->Get_Random_Int(0,BvVTotal)];
			ShowMessage = true;
		} else if (IsBaseDefense(shooter)) {
			KillMsg = BvVKillMsg[Commands->Get_Random_Int(0,BvVTotal)];
			ShowMessage = true;
		} else if (Is_Soldier(shooter)) {
			KillMsg = SvVKillMsg[Commands->Get_Random_Int(0,SvVTotal)];
			ShowMessage = true;
		} else if (Is_Vehicle(shooter)) {
			KillMsg = VvBKillMsg[Commands->Get_Random_Int(0,VvVTotal)];
			ShowMessage = true;
		}
		if (ShowMessage == true) {
			unsigned int n = 0;
			while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
			while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
			while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
			while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);

			sprintf(msg,"msg %s",KillMsg.c_str());
			Console_Input(msg);
		}
		KillMsg = "";
		killer = "";
		killed = "";
		killerpreset = "";
		killedpreset = "";
	}
}


void PlayerKillMessage (GameObject *obj, GameObject *shooter) {
	char msg[512], shooter_preset[512],obj_preset[512];
	const char *shooter_name, *obj_name;
	bool ShowMessage = false;

	obj_name = GetName(obj);
	shooter_name = GetName(shooter);
	getProfileString("Presets",Commands->Get_Preset_Name(shooter),Commands->Get_Preset_Name(shooter),shooter_preset,512,"apb.ini");
	getProfileString("Presets",Commands->Get_Preset_Name(obj),Commands->Get_Preset_Name(obj),obj_preset,512,"apb.ini");

	std::string killer(shooter_name),
		killed(obj_name),
		killerpreset(shooter_preset),
		killedpreset(obj_preset),
		KillMsg;
		
	if (Is_Building(shooter)) {
		KillMsg = BvSKillMsg[Commands->Get_Random_Int(0,BvSTotal)];
		ShowMessage = true;
	} else if (IsBaseDefense(shooter)) {
		KillMsg = BvSKillMsg[Commands->Get_Random_Int(0,BvSTotal)];
		ShowMessage = true;
	}
	if (ShowMessage == true) {
		unsigned int n = 0;
		while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
		while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
		while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
		while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);

		sprintf(msg,"msg %s",KillMsg.c_str());
		Console_Input(msg);
	}
		KillMsg = "";
		killer = "";
		killed = "";
		killerpreset = "";
		killedpreset = "";
}
/*
void KillMessage (GameObject *obj, GameObject *shooter,int type) {
	char msg[512], shooter_preset[512],obj_preset[512];
	const char *shooter_name, *obj_name;
	bool ShowMessage = false;

	if (Is_Vehicle(obj)){
		obj_name = GetName(Get_Vehicle_Driver(obj));
	} else {
		obj_name = GetName(obj);//Get_Player_Name(obj);
	}
	shooter_name = GetName(shooter);//Get_Player_Name(shooter);
	//SendData("shooter");

	//SendData("obj");


	getProfileString("Presets",Commands->Get_Preset_Name(Get_Vehicle_Return(shooter)),Commands->Get_Preset_Name(shooter),shooter_preset,512,"apb.ini");
	//SendData(shooter_preset);
	getProfileString("Presets",Commands->Get_Preset_Name(obj),Commands->Get_Preset_Name(obj),obj_preset,512,"apb.ini");
	//SendData(obj_preset);

	std::string killer(shooter_name),
				killed(obj_name),
				killerpreset(shooter_preset),
				killedpreset(obj_preset),
				KillMsg;

	switch(type){
		case 1: // Vehicle Death
			if (Is_Building(shooter)) {
				KillMsg = BvVKillMsg[Commands->Get_Random_Int(0,BvVTotal)];
				//SendData("vsbuilding");
				ShowMessage = true;

			} else if (IsBaseDefense(shooter)) {
				KillMsg = BvVKillMsg[Commands->Get_Random_Int(0,BvVTotal)];
				//SendData("vsbuilding");
				ShowMessage = true;
			} else if (Is_Soldier(shooter)) {
				KillMsg = SvVKillMsg[Commands->Get_Random_Int(0,SvVTotal)];
				//SendData("vssoldier");
				ShowMessage = true;
			} else if (Is_Vehicle(shooter)) {
				KillMsg = VvBKillMsg[Commands->Get_Random_Int(0,VvVTotal)];
				//SendData("vsvehicle");
				ShowMessage = true;
			}
			break;
		case 2: // Building Death
			if (Is_Building(shooter)) {
				KillMsg = BvBKillMsg[Commands->Get_Random_Int(0, BvBTotal)];
				//SendData("vsbuilding");
				ShowMessage = true;
			} else if (IsBaseDefense(shooter)) {
				KillMsg = BvBKillMsg[Commands->Get_Random_Int(0, BvBTotal)];
				//SendData("vsbuilding");
				ShowMessage = true;
			} else if (Is_Soldier(shooter)) {
				KillMsg = SvBKillMsg[Commands->Get_Random_Int(0, SvBTotal)];
				//SendData("vssoldier");
				ShowMessage = true;
			} else if (Is_Vehicle(shooter)) {
				KillMsg = VvBKillMsg[Commands->Get_Random_Int(0, VvBTotal)];
				//SendData("vsvehicle");
				ShowMessage = true;
			}
			break;
		case 3: // Player Death
			if (IsBaseDefense(shooter)) {
				KillMsg = BvSKillMsg[Commands->Get_Random_Int(0, BvSTotal)];
				//SendData("vsbuilding");
				ShowMessage = true;
			}
			break;
	}

	if (ShowMessage == true) {
		unsigned int n = 0;
		while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
		while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
		while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
		while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);

		sprintf(msg,"msg %s",KillMsg.c_str());
		Console_Input(msg);
	}
	// Old Code!
	char msg[512], killer[512], killed[512], msg2[512];
	const char *shooter_name, *obj_name;
	shooter_name = GetNameOrPreset(shooter);
	obj_name = GetNameOrPreset(obj);

	getProfileString("Presets",shooter_name,shooter_name,killer,512,"config.ini");
	getProfileString("Presets",obj_name,obj_name,killed,512,"config.ini");
	getProfileString("KillMessage",Commands->Get_Preset_Name(shooter)," > ",msg,512,"config.ini");
	sprintf(msg2,"msg %s%s%s",killer,msg,killed);
	Console_Input(msg2);
	//Console_Output(msg2);
	
}*/

void BuildingKillMessage (GameObject *obj, GameObject *shooter) {
	char msg[512], shooter_preset[512],obj_preset[512];
	const char *shooter_name, *obj_name;
	bool ShowMessage = false;

	obj_name = GetName(Get_Vehicle_Driver(obj));
	shooter_name = GetName(shooter);//Get_Player_Name(shooter);
	getProfileString("Presets",Commands->Get_Preset_Name(Get_Vehicle_Return(shooter)),Commands->Get_Preset_Name(Get_Vehicle_Return(shooter)),shooter_preset,512,"apb.ini");
	getProfileString("Presets",Commands->Get_Preset_Name(obj),Commands->Get_Preset_Name(obj),obj_preset,512,"apb.ini");

	std::string killer(shooter_name),
		killed(obj_name),
		killerpreset(shooter_preset),
		killedpreset(obj_preset),
		KillMsg;
	
	if (Is_Building(shooter)) {
		KillMsg = BvBKillMsg[Commands->Get_Random_Int(0, BvBTotal)];
		ShowMessage = true;
	} else if (IsBaseDefense(shooter)) {
		KillMsg = BvBKillMsg[Commands->Get_Random_Int(0, BvBTotal)];
		ShowMessage = true;
	} else if (Is_Soldier(shooter)) {
		KillMsg = SvBKillMsg[Commands->Get_Random_Int(0, SvBTotal)];
		ShowMessage = true;
	} else if (Is_Vehicle(shooter)) {
		KillMsg = VvBKillMsg[Commands->Get_Random_Int(0, VvBTotal)];
		ShowMessage = true;
	}
			
	if (ShowMessage == true) {
		unsigned int n = 0;
		while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
		while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
		while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
		while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);

		sprintf(msg,"msg %s",KillMsg.c_str());
		Console_Input(msg);
	}
		KillMsg = "";
		killer = "";
		killed = "";
		killerpreset = "";
		killedpreset = "";
}


void SH_BuildingLog::Created(GameObject *obj) {
	if (shown) return;
	shown = true;
	//char msg[512];
	//sprintf(msg,"bcreated %s", Commands->Get_Preset_Name(obj));
	//SendData(msg);	
}
void SH_BuildingLog::Killed(GameObject *obj, GameObject *shooter) {
	if (!shown) return;
	shown = false;
//	char msg[512];
	//sprintf(msg,"bkill %s %s", Commands->Get_Preset_Name(obj), Get_Player_Name(shooter));
	//SendData(msg);	
	//sprintf(msg,"msg %s destroyed the %s", Get_Player_Name(shooter), Commands->Get_Preset_Name(obj));
	//Console_Input(msg);
	BuildingKillMessage(obj,shooter);
}

void SH_PlayerLog::Killed(GameObject *obj, GameObject *shooter) {
//	char msg[512];
	//sprintf(msg,"pkill %s %s", Get_Player_Name(obj), Get_Player_Name(shooter));
	//SendData(msg);	
	PlayerKillMessage(obj, shooter);
	
	//if (IsBaseDefense(shooter)== true) { KillMessage(obj,shooter,3);}
}
void SH_VehicleLog::Created(GameObject *obj) {
	if (shown) return;
	shown = true;
	if (IsBaseDefense(obj)== true) { this->Destroy_Script();return;}
	//char msg[512];
	//sprintf(msg,"vcreated %s", Commands->Get_Preset_Name(obj));
	//SendData(msg);	
}
void SH_VehicleLog::Killed(GameObject *obj, GameObject *shooter) {
	if (!shown) return;
	shown = false;
	//char msg[512];
	//sprintf(msg,"vkill %s %s", Commands->Get_Preset_Name(obj), GetNameOrPreset(shooter));
	//SendData(msg);	
	//KillMessage(obj,shooter,1);
	VehicleKillMessage(obj, shooter);
}
void SH_AdvancedConsoleCommand::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,0.1f,1);
}
void SH_AdvancedConsoleCommand::Timer_Expired(GameObject *obj, int number)
{
       char CommandRead[600];
       std::ifstream cc ("fds.in");
       if (cc.is_open() == true)
       {
               while (!cc.eof())
               {
                       cc.getline(CommandRead,600);
                       if (CommandRead[0] != '\0')
                       {
                               Console_Input(CommandRead);
                       }
               }
               cc.close();
               remove("fds.in");
       }
       Commands->Start_Timer(obj,this,0.1f,0);
}

void SH_ObjectCreated::ObjectCreateHook(GameObject *obj) {
	Attach_Script_Is_Type(obj,Vehicle,"SH_VehicleLog","",2);
	Attach_Script_Is_Type(obj,Soldier,"SH_PlayerLog","",2);
}

ScriptRegistrant<SH_BuildingLog> SH_BuildingLog_Registrant("SH_BuildingLog","");
ScriptRegistrant<SH_PlayerLog> SH_PlayerLog_Registrant("SH_PlayerLog","");
ScriptRegistrant<SH_VehicleLog> SH_VehicleLog_Registrant("SH_VehicleLog","");
ScriptRegistrant<SH_AdvancedConsoleCommand> SH_AdvancedConsoleCommand_Registrant("SH_AdvancedConsoleCommand","");
ScriptRegistrant<SH_ObjectCreated> SH_ObjectCreated_Registrant("SH_ObjectCreated","");