/*********
Converts the source to monochrome.
Use with GenericPostProcessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

static const float3 fColorWeight = { 0.2125f, 0.7154f, 0.0721f };

float4 MonochromePS(float2 Tex : TEXCOORD0): COLOR0
{
	float3 output = tex2D(InputBufferSampler, Tex);
	return float4(dot(output,fColorWeight), 1.0f);
}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_1_4 MonochromePS();
    }
}