#ifndef STNET_H
#define STNET_H

#define GSA_MAX_PACKET_LENGTH 1024
#define GSA_TIMEOUT           120.0f

class gzGameSpyQuerySettings : public stSettingsBase {
public:
	gzGameSpyQuerySettings();
	void Load();

	bool m_enable;
	unsigned short m_bindPort;
	bool m_showPlayers;
	bool m_prependExMark;
};

class gzGameSpyQueryManager : public EventHandler, public gzSettingsEvent {
	aSocketUDP *m_socket;
	aIPv4Address m_gsaAddr;
	unsigned long m_queryCount;
	unsigned short m_bindPort;
	gzGameSpyQuerySettings *m_settings;
	float m_gsaTimeoutCounter;
public:
	const char *GetName()
	{
		return "gzGameSpyQueryManager";
	};
	void Delete();
	void Settings_Loaded();
	gzGameSpyQueryManager();
	void Think();
	
};
extern gzGameSpyQueryManager *gzGameSpyQueryMgr;

#if ISDEV()
class gzPlayerTraceRoute : public aThread {
	aIPv4Address m_dst;
public:
	gzPlayerTraceRoute(const char *ip);
	int Entry(void *);
};
#endif

#endif
