#include "stinc.h"
#include "stmisc.h"
#include "stchat.h"
#include "stplayer.h"
#include "stkeyhook.h"

void gzKeyHookCallback(void *data)
{
	((gzKeyHookBase *)data)->Triggered();
}
void gzKeyHookBase::Detach(nc_ScriptableGameObj *obj)
{
	this->nc_ScriptImpClass::Detach(obj);
	if (this->m_isSet == 1337)
		this->RemoveHook();
}
void gzKeyHookBase::Destroyed(nc_ScriptableGameObj *obj)
{
	if (this->m_isSet == 1337)
		this->RemoveHook();
}
void gzKeyHookBase::AddHook(const char *Key, nc_ScriptableGameObj *obj)
{
	if (this->m_isSet == 1337)
		this->RemoveHook();
	this->m_keyData = new gzKeyHookStruct;
	this->m_keyData->data = this;
	this->m_keyData->hook = gzKeyHookCallback;
	this->m_keyData->PlayerID = obj->As_SoldierGameObj()->Player->PlayerId;
	if (Key)
		this->m_keyData->key = newstr2(Key);
	else
		this->m_keyData->key = NULL;
	this->m_hookID = gzAddKeyHook(this->m_keyData);
}
void gzKeyHookBase::RemoveHook()
{
	if (this->m_hookID != 0)
	{
		gzRemoveKeyHook(this->m_hookID);
		this->m_hookID = 0;
		this->m_isSet = 0;
		if (this->m_keyData)
		{
			if (this->m_keyData->key)
			{
				delete [] this->m_keyData->key;
				this->m_keyData->key = NULL;
			}
			delete this->m_keyData;
			this->m_keyData = NULL;
		}
	}
}

void gzKeyHook_ProcCmd::Created(nc_ScriptableGameObj *obj)
{
	if (this->m_isSet != 1337)
	{
		this->AddHook(Get_Parameter("Key"),obj);
		this->m_isSet = 1337;
		this->m_lastPress = cGame->GameDuration_Seconds - 5;
	}
}
void gzKeyHook_ProcCmd::Triggered()
{
#if !ISDEV()
	if ((cGame->GameDuration_Seconds - this->m_lastPress) >= 5)
	{
#endif
		aWideString ignoreRet;
		const char *Key = Get_Parameter("Key");
		for (unsigned int i = 0; i < gzChatManagerClass::m_chatCommandList.Count(); i++)
		{
			for (unsigned int j = 0; j < gzChatManagerClass::m_chatCommandList[i]->m_commandList.Count(); j++)
			{
				if (gzChatManagerClass::m_chatCommandList[i]->m_keyhook_Key.GetLength() > 0 && gzChatManagerClass::m_chatCommandList[i]->m_keyhook_Key == Key)
				{
					gzChatManagerClass::m_chatCommandList[i]->Activate(
						gzChatManagerClass::m_chatCommandList[i]->m_keyhook_Param.GetLength() > 0 ? gzChatManagerClass::m_chatCommandList[i]->m_keyhook_Param.GetString() : L"",
						0,
						this->Owner()->As_SoldierGameObj()->Player->PlayerId,
						0,
						ignoreRet
					);
					break;
				}
			}
		}
		this->m_lastPress = cGame->GameDuration_Seconds;
#if !ISDEV()
	}
#endif
}
nc_ScriptRegistrant<gzKeyHook_ProcCmd> gzKeyHook_ProcCmd_Registrant("gzKeyHook_ProcCmd","Key:string,Type:int");

void gzKeyHook_WriteLog::Created(nc_ScriptableGameObj *obj)
{
	if (this->m_isSet != 1337)
	{
		this->AddHook(Get_Parameter("Key"),obj);
		this->m_isSet = 1337;
		this->m_lastPress = cGame->GameDuration_Seconds - 5;
	}
}
void gzKeyHook_WriteLog::Triggered()
{
#if !ISDEV()
	if ((cGame->GameDuration_Seconds - this->m_lastPress) >= 5)
	{
#endif
		if (this->Get_Int_Parameter("Type") == 0)
			stConsole::Out("%ls: %s\n", this->Owner()->As_SoldierGameObj()->Player->PlayerName.m_Buffer, this->Get_Parameter("Command"));
		else if (this->Get_Int_Parameter("Type") == 1)
			stConsole::Out("[Team] %ls: %s\n", this->Owner()->As_SoldierGameObj()->Player->PlayerName.m_Buffer, this->Get_Parameter("Command"));
		this->m_lastPress = cGame->GameDuration_Seconds;
#if !ISDEV()
	}
#endif
}
nc_ScriptRegistrant<gzKeyHook_WriteLog> gzKeyHook_WriteLog_Registrant("gzKeyHook_WriteLog","Key:string,Command:string,Type:int");

void gzKeyHook_NumpadToggle::Created(nc_ScriptableGameObj *obj)
{
	if (this->m_isSet != 1337)
	{
		this->AddHook(Get_Parameter("Key"),obj);
		this->m_isSet = 1337;
	}
}
void gzKeyHook_NumpadToggle::Triggered()
{
	//gzPlayer *gzData = gzPlayerManager::Find(this->Owner()->As_SoldierGameObj()->Player);
	//if (gzData)
	//{
	//	if (gzData->m_numpadMode == NUMPAD_TAUNT)
	//	{
	//		gzData->m_numpadMode = NUMPAD_PURCHASE;
	//		PagePlayer(gzData->GetPlayerData()->PlayerId, "Numpad keys are now in purchase mode.");
	//	}
	//	else if (gzData->m_numpadMode == NUMPAD_PURCHASE)
	//	{
	//		gzData->m_numpadMode = NUMPAD_TAUNT;
	//		PagePlayer(gzData->GetPlayerData()->PlayerId, "Numpad keys are now in taunt mode.");
	//	}
	//}
}
nc_ScriptRegistrant<gzKeyHook_NumpadToggle> gzKeyHook_NumpadToggle_Registrant("gzKeyHook_NumpadToggle","Key:string,ID:int");

void gzKeyHook_Numpad::Created(nc_ScriptableGameObj *obj)
{
	if (this->m_isSet != 1337)
	{
		this->AddHook(Get_Parameter("Key"),obj);
		this->m_isSet = 1337;
		this->m_lastPress = cGame->GameDuration_Seconds - 5;
	}
}
void gzKeyHook_Numpad::Triggered()
{
#if !ISDEV()
	if ((cGame->GameDuration_Seconds - this->m_lastPress) >= 5)
	{
#endif
		nc_SoldierGameObj *Soldier = this->Owner()->As_SoldierGameObj();
		if (Soldier->Human.State == 5 || Soldier->Defense.Health.Get() == 0.0f)
			return;
		if (Soldier->Vehicle)
		{
			PagePlayer(Soldier->Player->PlayerId, "You can not use this command while you're in vehicle.");
			return;
		}
		const char *Taunts[] = {
			"h_a_a0a0_l12",
			"H_A_a0a0_L22",
			"H_A_a0a0_L23",
			"H_A_a0a0_L24",
			"H_A_a0a0_L25",
			"H_A_a0a0_L58",
			"H_A_cresentkick",
			"H_A_sidekick",
			"H_A_punchcombo"
		};
		gzCommands->Set_Animation(this->Owner(), Taunts[Get_Int_Parameter("ID")], false, 0, 0.0f, -1.0f, false);
		this->m_lastPress = cGame->GameDuration_Seconds;
#if !ISDEV()
	}
#endif
}
nc_ScriptRegistrant<gzKeyHook_Numpad> gzKeyHook_Numpad_Registrant("gzKeyHook_Numpad","Key:string,ID:int");
