#include "stinc.h"
#include "stmisc.h"
#include "stsetting.h"

gzSettingsManager *gzSettingsMgr = NULL;
gzSettingsManager::gzSettingsManager()
{
	this->RegisterEvent(EVT_GAME_LEVEL_LOADED);
}
void gzSettingsManager::Delete()
{
	for (unsigned int i = 0; i < this->m_list.Count(); i++)
	{
		this->m_list[i]->Delete();
		delete this->m_list[i];
	}
	this->m_list.Clear();
}
void gzSettingsManager::Level_Loaded()
{
	for (unsigned int i = 0; i < this->m_list.Count(); i++)
	{
		this->m_list[i]->Load();
		if (this->m_list[i]->GetOwner())
			this->m_list[i]->GetOwner()->Settings_Loaded();
	}
	gzLogger("_GENERAL", "All settings have been loaded.");
}

void stSettingsBase::Close()
{
	if (this->m_cfg != NULL)
	{
		delete this->m_cfg;
		this->m_cfg = NULL;
	}
}
bool stSettingsBase::Open(const aString &file)
{
	this->Close();

	this->m_cfg = new aTextConfig(file);
	return this->m_cfg->IsLoaded();
}
