#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>
#include <time.h>
#include "date.h"
#include "scripts.h"
#include "fds.h"
#include "ncToken.h"
#include "ncThread.h"
#include "Hooks_Base.h"
#include "ReservedSlot.h"

#pragma warning(disable: 4100)

bool Initialed = false;
extern "C" {

BOOL __declspec(dllexport) __stdcall DllMain(HINSTANCE hinstDLL,
						DWORD	ul_reason_for_call,
						LPVOID	lpReserved
					 )
{
	return TRUE;
}

} // extern "C"

ReservedSlotClass::ReservedSlotClass()
{
	this->HostnameThread = ncThreadManager::New("Reserved Slot hostname resolver",&ReservedSlotClass::ResolveHostname,NULL);
	this->_SafeToDelete = false;
}
ReservedSlotClass::~ReservedSlotClass()
{
	for (unsigned int i = 0; i < this->NickList.size(); i++)
	{
		this->NickList[i].IPList.clear();
		this->NickList[i].SerialList.clear();
		this->NickList.erase(this->NickList.begin() + i);
		i--;
	}
	this->NickList.clear();
}
void ReservedSlotClass::Add(ReservedSlotDataStruct *Data)
{
	if (Data->IPList.empty())
	{
		ReservedSlotDataStruct::IPDataStruct ipdata;
		Data->HasHostname = false;
		ipdata.IsHostname = false;
		memset(ipdata.String,0,sizeof(ipdata.String));
		strcpy(ipdata.String,"*");
		Data->IPList.push_back(ipdata);
	}
	if (Data->SerialList.empty())
	{
		ReservedSlotDataStruct::SerialDataStruct data;
		memset(data.Serial,0,sizeof(data.Serial));
		strcpy(data.Serial,"*");
		Data->SerialList.push_back(data);
	}
	this->NickList.push_back(*Data);
}
void ReservedSlotClass::Add_Queue(nc_cPacket *packet, unsigned int DataIndex)
{
	ReservedSlotQueueStruct queue;
	queue.packet = (nc_cPacket *)malloc(sizeof(nc_cPacket));
	queue.CreateTime = GetTickCount();
	memset(queue.Hostname,0,sizeof(queue.Hostname));
	queue.State = 0;
	queue.Data = &this->NickList[DataIndex];
	memcpy(*&queue.packet,packet,sizeof(nc_cPacket));
	this->QueueList.push_back(queue);
}
bool ReservedSlotClass::Add_Temp(const wchar_t *Name)
{
	if (!this->NickList.empty())
	{
		for (unsigned int i = 0; i < this->NickList.size(); i++)
		{
			if (!wcsicmp(Name,this->NickList[i].Name))
				return false;
		}
	}
	ReservedSlotDataStruct data;
	data.Banned = false;
	data.ReservedSlot = true;
	wcscpy(data.Name,Name);
	data.OneTime = true;
	data.CreateTime = GetTickCount();
	this->Add(&data);
	return true;
}
void ReservedSlotClass::Clear()
{
	for (unsigned int i = 0; i < this->NickList.size(); i++)
	{
		if (!this->NickList[i].OneTime)
		{
			this->NickList[i].IPList.clear();
			this->NickList[i].SerialList.clear();
			this->NickList.erase(this->NickList.begin() + i);
			i--;
		}
	}
}
bool ReservedSlotClass::Is_In_List(const wchar_t *Name)
{
	if (this->NickList.empty())
		return false;
	for (unsigned int i = 0; i < this->NickList.size(); i++)
	{
		if (!wcsicmp(Name,this->NickList[i].Name))
			return true;
	}
	return false;
}
void ReservedSlotClass::Output()
{
	for (unsigned int i = 0; i < ReservedSlot->NickList.size(); i++)
	{
		Console.Output("----------------------------------\n");
		Console.Output("%S - Banned: %s - Reserved slot: %s - Temporary slot: %s\nList of allowed IP:\n",
			ReservedSlot->NickList[i].Name,ReservedSlot->NickList[i].Banned ? "Yes" : "No",
			ReservedSlot->NickList[i].ReservedSlot ? "Yes" : "No",
			ReservedSlot->NickList[i].OneTime ? "Yes" : "No"
		);
		for (unsigned int j = 0; j < ReservedSlot->NickList[i].IPList.size(); j++)
			Console.Output("\t%s\n",ReservedSlot->NickList[i].IPList[j].String);
		Console.Output("List of allowed serial hash:\n");
		for (unsigned int j = 0; j < ReservedSlot->NickList[i].SerialList.size(); j++)
			Console.Output("\t%s\n",ReservedSlot->NickList[i].SerialList[j].Serial);
	}
	Console.Output("----------------------------------\n");
}
void ReservedSlotClass::Think()
{
	for (unsigned int i = 0; i < this->NickList.size(); i++)
	{
		if (this->NickList[i].OneTime)
		{
			if ((GetTickCount() - this->NickList[i].CreateTime) > 900000)
			{
				Console.Output("%S has been removed from temporary reserved slot due to timeout.\n",this->NickList[i].Name);
				this->NickList.erase(this->NickList.begin() + i);
				i--;
			}
		}
	}
	for (unsigned int i = 0; i < this->QueueList.size(); i++)
	{
		if (this->QueueList[i].State == 3 || (GetTickCount() - this->QueueList[i].CreateTime) > 60000)
		{
			if (this->_SafeToDelete)
			{
				free(this->QueueList[i].packet);
				this->QueueList.erase(this->QueueList.begin() + i);
				i--;
			}
		}
		else if (this->QueueList[i].State == 2)
		{
			bool Found = false;
			for (unsigned int j = 0; j < this->QueueList[i].Data->IPList.size(); j++)
			{
				if (this->QueueList[i].Data->IPList[j].IsHostname && *this->QueueList[i].Data->IPList[j].String)
				{
					if (!stricmp(this->QueueList[i].Data->IPList[j].String,this->QueueList[i].Hostname) || wildcmp(this->QueueList[i].Data->IPList[j].String,this->QueueList[i].Hostname))
					{
						Found = true;
						break;
					}
				}
				else
				{
					if (!stricmp(this->QueueList[i].Data->IPList[j].String,inet_ntoa(this->QueueList[i].packet->Sender.sin_addr)) || wildcmp(this->QueueList[i].Data->IPList[j].String,inet_ntoa(this->QueueList[i].packet->Sender.sin_addr)))
					{
						Found = true;
						break;
					}
				}
			}
			if (!Found)
			{
				nc_cNetwork::PServerConnection->Send_Refuse_Sc(&this->QueueList[i].packet->Sender,VERSION_MISMATCH);
				nc_WideStringClass Nick;
				Nick.Get_String(0,true);
				Nick.Uninitialised_Grow(256);
				this->QueueList[i].packet->Get_Wide_Terminated_String(Nick.m_Buffer,256,true);
				Console.Output("%s(RDNS: %s) attempted to connect with disallowed IP/RDNS for nickname \"%S\"\n",
					inet_ntoa(this->QueueList[i].packet->Sender.sin_addr),
					*this->QueueList[i].Hostname ? this->QueueList[i].Hostname : "None",
					Nick.m_Buffer
				);
				Nick.Free_String();
			}
			else
			{
				cGame->MaxPlayers = 127;
				nc_cNetwork::PServerConnection->Process_Connection_Request(*this->QueueList[i].packet);
				cGame->MaxPlayers = ReservedSlot->MaxPlayers;
			}
			this->QueueList[i].State = 3;
		}
	}
}
void ReservedSlotClass::Load()
{
	if (!Initialed)
	{
		Console.Output("Error - Unable to load reserved slot. [1]\n");
		return;
	}

	ReservedSlot->Clear();
	FILE *list = fopen("Nicks.cfg","r");
	if (!list) return;
#ifdef __DEV__
	Console.Output("Loading Reserved Slot list...\n");
#endif
	char line[1024], cur[128];
	memset(&cur,0,sizeof(cur));
	ReservedSlotDataStruct data;
	while (!feof(list) && fgets(line,sizeof(line) -1,list)) {
		for (unsigned int i = strlen(line) -1; i >= 0; i--) { // Remove the spaces and CRLF at the end
			if (line[i] == ' ' || line[i] == '\n') line[i] = 0;
			else break;
		}
		if (strlen(line) > 2 && line[0] != ';') {
			if (line[0] == '[' && line[strlen(line) -1] == ']') {
				if (strlen(cur) > 0) ReservedSlot->Add(&data);
				memset(&cur,0,sizeof(cur));
				data.Banned = false;
				data.HasHostname = false;
				data.IPList.clear();
				data.ReservedSlot = false;
				data.SerialList.clear();
				data.OneTime = false;
				data.CreateTime = 0;
				strncpy(cur,line +1,strlen(line) -2);
				memset(data.Name,0,sizeof(data.Name));
				mbstowcs(data.Name,cur,sizeof(data.Name));
			}
			else {
				ncToken msg(line);
				if (!stricmp(msg.gettok(1,' ').to_chr(),"Banned")) data.Banned = true;
				else if (!stricmp(msg.gettok(1,' ').to_chr(),"ReservedSlot")) data.ReservedSlot = true;
				else if (!stricmp(msg.gettok(1,' ').to_chr(),"IP")) {
					for (int i = 2; i <= msg.numtok(' '); i++) {
						ReservedSlotDataStruct::IPDataStruct ipdata;
						ipdata.IsHostname = false;
						memset(ipdata.String,0,sizeof(ipdata.String));
						strncpy(ipdata.String,msg.gettok(i,' ').to_chr(),sizeof(ipdata.String) -1);
						for (unsigned int i = 0; i < strlen(ipdata.String); i++) {
							if (isalpha(ipdata.String[i])) {
								ipdata.IsHostname = true;
								data.HasHostname = true;
								break;
							}
						}
						data.IPList.push_back(ipdata);
					}
				}
				else if (!stricmp(msg.gettok(1,' ').to_chr(),"Serial")) {
					for (int i = 2; i <= msg.numtok(' '); i++) {
						ReservedSlotDataStruct::SerialDataStruct sdata;
						memset(sdata.Serial,0,sizeof(sdata.Serial));
						if (strlen(msg.gettok(i,' ').to_chr()) == 32)
						{
							strcpy(sdata.Serial,msg.gettok(i,' ').to_chr());
							data.SerialList.push_back(sdata);
						}
					}
				}
			}
		}
	}
	ReservedSlot->Add(&data);
#ifdef __DEV__
	ReservedSlot->Output();
	//Console.Input("smp 0");
#endif
	ReservedSlot->MaxPlayers = cGame->MaxPlayers;

	for (int i = 0; i < nc_ConsoleFunctionManager::FunctionList.Count(); i++) {
		unsigned long offset = (unsigned long)*(unsigned long *)*&nc_ConsoleFunctionManager::FunctionList[i];

		// Remove "plimit" and "plimitd" from bhs.dll
		if (offset >= 0x45000000)
		{
			if (strstr(nc_ConsoleFunctionManager::FunctionList[i]->Get_Name(),"plimit"))
			{
				nc_ConsoleFunctionManager::FunctionList.Delete(i);
				i--;
			}
		}
	}
	nc_ConsoleFunctionManager::Sort_Function_List();
	nc_ConsoleFunctionManager::Verbose_Help_File();
}
void __stdcall ReservedSlotClass::ResolveHostname()
{
	if (ReservedSlot)
	{
		ReservedSlot->_SafeToDelete = true;
		for (;;)
		{
			if (!ReservedSlot->QueueList.empty())
			{
				ReservedSlot->_SafeToDelete = false;
				for (unsigned int i = 0; i < ReservedSlot->QueueList.size(); i++)
				{
					if (ReservedSlot->QueueList[i].State == 0)
					{
#ifdef __DEV__
						Console.Output("Resolving %s...\n",inet_ntoa(ReservedSlot->QueueList[i].packet->Sender.sin_addr));
#endif
						ReservedSlot->QueueList[i].State = 1;
						hostent *host = gethostbyaddr((char *)&ReservedSlot->QueueList[i].packet->Sender.sin_addr,sizeof(sockaddr_in),AF_INET);
						if (host)
						{
							strncpy(ReservedSlot->QueueList[i].Hostname,host->h_name,sizeof(ReservedSlot->QueueList[i].Hostname) -1);
#ifdef __DEV__
							Console.Output("Resolved %s to %s\n",inet_ntoa(ReservedSlot->QueueList[i].packet->Sender.sin_addr),host->h_name);
#endif
						}
						else
						{
#ifdef __DEV__
							Console.Output("Unable to resolve %s\n",inet_ntoa(ReservedSlot->QueueList[i].packet->Sender.sin_addr));
#endif
						}
						ReservedSlot->QueueList[i].State = 2;
					}
				}
			}
			ReservedSlot->_SafeToDelete = true;
			Sleep(1000);
		}
	}
}
void ReservedSlotClass::ReceiveSerial(const nc_cGameSpyCsChallengeResponseEvent *Response)
{
	nc_cPlayer *pData = nc_cPlayerManager::Find_Player(Response->ID);
	if (!pData)
		return;
	char Hash[33];
	strncpy(Hash,Response->Hash.m_Buffer,32);
	Hash[32] = 0;
	for (unsigned int i = 0; i < ReservedSlot->NickList.size(); i++)
	{
		if (!wcsicmp(pData->PlayerName.m_Buffer,ReservedSlot->NickList[i].Name))
		{
			if (!ReservedSlot->NickList[i].SerialList.empty())
			{
				bool Found = false;
				for (unsigned int j = 0; j < ReservedSlot->NickList[i].SerialList.size(); j++)
				{
					if (!stricmp(ReservedSlot->NickList[i].SerialList[j].Serial,"*") || !stricmp(ReservedSlot->NickList[i].SerialList[j].Serial,Hash))
					{
						Found = true;
						break;
					}
				}
				if (!Found)
				{
					Console.Output("%s attempted to connect with disallowed serial(%s) for nickname \"%S\"\n",
						inet_ntoa(nc_cNetwork::PServerConnection->RemoteList[Response->ID]->Address.sin_addr),
						Hash,
						ReservedSlot->NickList[i].Name
					);
					nc_cNetwork::Server_Kill_Connection(Response->ID);
					nc_cNetwork::Cleanup_After_Client(Response->ID);
					Console.Output("%S was kicked\n",pData->PlayerName.m_Buffer);
				}
			}
			break;
		}
	}
}
ReservedSlotClass *ReservedSlot;

ConsoleIO Console;
void ConsoleIO::Input(const char *msg, ...) {
	if (!*msg) return;
	char buf[256];
	va_list args;
	va_start(args,msg);
	_vsnprintf(buf,255,msg,args);
	va_end(args);
	_asm {
		mov eax, 0x428960
		lea edx, buf
		push edx
		call eax
	}
}
void ConsoleIO::Output(const char *msg, ...) {
	if (!msg || !*msg)
		return;
	va_list args;
	va_start(args,msg);
	int size = _vscprintf(msg,args);
	char *tmp = new char[size +1];
	vsprintf(tmp,msg,args);
	va_end(args);
	date logdate;
	logdate.refreshdate();
	ncString renlog;
	renlog.Format("renlog_%s.txt",logdate.get_date_string());
	FILE *logFile = fopen(renlog.GetString(),"a");
	if (logFile)
	{
		time_t rawtime;
		tm *timeinfo;
		time(&rawtime);
		timeinfo = localtime(&rawtime);
		fprintf(logFile,"[%02d:%02d:%02d] ",timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec);
		fputs(tmp,logFile);
		fclose(logFile);
	}
	printf("%s",tmp);
	renlog.Free_String();
	delete [] tmp;
}

void PatchData(void *buf, unsigned long size, unsigned long addr) {
	unsigned long PID = GetCurrentProcessId();
	HANDLE PHandle = OpenProcess(PROCESS_ALL_ACCESS, false, PID);
	WriteProcessMemory(PHandle, (void *)addr, buf, size, NULL);
	CloseHandle(PHandle);
}
void PatchJump(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char jmp = 0xE9;
	PatchData(&jmp,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchCall(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char call = 0xE8;
	PatchData(&call,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchByte(unsigned char Byte, unsigned long size, unsigned long addr) {
	for (unsigned long i = 0; i < size; i++) PatchData(&Byte,1,addr +i);
}

#define LOWER(chr) ((chr >= 'A') && (chr <= 'Z') ? chr+32 : chr)
char *stristr(const char *m_pStr1, const char *m_pStr2) {
	register char *m_pCP = (char *)m_pStr1;
	register char *m_pS1, *m_pS2;
	while (*m_pCP)
	{
		m_pS1 = m_pCP;
		m_pS2 = (char *) m_pStr2;
		while (*m_pS1 && *m_pS2 && !(LOWER(*m_pS1) - LOWER(*m_pS2)))
		{
			m_pS1++, m_pS2++;
		}
		if (!*m_pS2)
		{
			return m_pCP;
		}
		m_pCP++;
	}
	return NULL;
}

int __fastcall wildcmp(const char *wild, const char *string) {
	register const char *cp = NULL, *mp = NULL;
	while ((*string) && (*wild != '*')) {
		if ((*wild != *string) && (*wild != '?')) return 0;
		wild++;
		string++;
	}
	while (*string) {
		if (*wild == '*') {
			if (!*++wild) return 1;
			mp = wild;
			cp = string+1;
		}
		else if ((*wild == *string) || (*wild == '?')) {
			wild++;
			string++;
		}
		else {
			wild = mp;
			string = cp++;
		}
	}
	while (*wild == '*') wild++;
	return !*wild;
}

void Frame_Hook()
{
	ReservedSlot->Think();
}

void __stdcall ProcessConnectionRequest_Hook(nc_cPacket &packet)
{
	if (Initialed)
	{
		unsigned char PlayersCheckBytes[] = { 0xE8, 0xB3, 0xD0, 0xFB, 0xFF };
		PatchData(&PlayersCheckBytes,5,0x458758);
		nc_WideStringClass Name;
		Name.Get_String(0,true);
		Name.Uninitialised_Grow(256);
		packet.Get_Wide_Terminated_String(Name.m_Buffer,256,true);
		packet.BitReadPosition = 0;
		if (ReservedSlot->Is_In_List(Name.m_Buffer))
		{
			for (unsigned int i = 0; i < ReservedSlot->NickList.size(); i++)
			{
				if (!wcsicmp(ReservedSlot->NickList[i].Name,Name.m_Buffer))
				{
					if (ReservedSlot->NickList[i].Banned)
					{
						nc_cNetwork::PServerConnection->Send_Refuse_Sc(&packet.Sender,VERSION_MISMATCH);
						Console.Output("%s attempted to connect with a banned nickname \"%S\"\n",inet_ntoa(packet.Sender.sin_addr),Name);
					}
					else if (ReservedSlot->NickList[i].HasHostname)
						ReservedSlot->Add_Queue(&packet,i);
					else
					{
						bool Found = false;
						char *IP = inet_ntoa(packet.Sender.sin_addr);
						for (unsigned int j = 0; j < ReservedSlot->NickList[i].IPList.size(); j++)
						{
							if (wildcmp(ReservedSlot->NickList[i].IPList[j].String,IP))
							{
								Found = true;
								break;
							}
						}
						if (!Found)
						{
							nc_cNetwork::PServerConnection->Send_Refuse_Sc(&packet.Sender,VERSION_MISMATCH);
							Console.Output("%s attempted to connect from disallowed IP for nickname \"%S\"\n",inet_ntoa(packet.Sender.sin_addr),Name);
						}
						else
						{
							cGame->MaxPlayers = 127;
							nc_cNetwork::PServerConnection->Process_Connection_Request(packet);
							cGame->MaxPlayers = ReservedSlot->MaxPlayers;
						}
					}
					if (ReservedSlot->NickList[i].OneTime)
						ReservedSlot->NickList.erase(ReservedSlot->NickList.begin() + i);
					break;
				}
			}
		}
		else
			nc_cNetwork::PServerConnection->Process_Connection_Request(packet);
		Name.Free_String();
	}
	else
		nc_cNetwork::PServerConnection->Process_Connection_Request(packet);
}

__declspec(naked) void cRemoteHostSizePatch()
{
	_asm {
		mov Initialed, 1
		mov eax, 127
		sub esp, 0x10
		mov edx, 0x617ED7
		jmp edx
	}
}

Init_Class::Init_Class()
{
	if (!Init_Hooks())
	{
		MessageBox(0,"Failed to load Hooks.dll. ReservedSlot.dll has been disabled.","FATAL ERROR",MB_OK);
		return;
	}
	if (Get_Hooks_Version() < MINIMUM_HOOKS_VERSION)
	{
		char msg[512];
		sprintf(msg,"Error - ReservedSlot.dll is incompatible with Hooks.dll version below %s. Current Hooks.dll version is %.2f, please upgrade.",MINIMUM_HOOKS_VERSION,Get_Hooks_Version());
		MessageBox(0,msg,"Error",MB_OK);
		return;
	}
	RegisterFDSStartUpHook(Init_Class::Init_Hook);
}
void Init_Class::Init_Hook()
{
	DLL_Init();
}
Init_Class InitClass;

#ifdef __DEV__
void __stdcall WOLAPI_Income_Data(const char *Message)
{
	Console.Output("WOLAPI msg: [IN] %s",Message);
}
__declspec(naked) void WOLAPI_Income_Data_Hook()
{
	_asm {
		push ebp
		mov ebp, esp
		sub esp, 0xAC
		push ebx
		push ecx
		push 0x21037F40
		call WOLAPI_Income_Data
		pop ecx
		mov ebx, 0x21009182
		jmp ebx
	}
}

void __stdcall WOLAPI_Outgoing_Data(const char *Message)
{
	Console.Output("WOLAPI msg: [OUT] %s",Message);
}
__declspec(naked) void WOLAPI_Outgoing_Data_Hook()
{
	_asm {
		push ebp
		mov ebp, esp
		sub esp, 0xC
		push esi
		push ecx
		push 0x210382F0
		call WOLAPI_Outgoing_Data
		pop ecx
		mov esi, 0x2100E640
		jmp esi
	}
}
#endif

int WOL_Response_MaxPlayers;
__declspec(naked) void WOLAPI_JOINGAME_Response_Hook()
{
	WOL_Response_MaxPlayers = cGame->MaxPlayers +1;
	_asm {
		mov eax, WOL_Response_MaxPlayers
		retn
	}
}
__declspec(naked) void WOLAPI_Hook_Callback()
{
	_asm {
		push 128
		push [esi+4]
		mov ecx, 0x2100884A
		jmp ecx
	}
}
void __stdcall Setup_WOLAPI_Hook()
{
	// Patch to remove the limit from bhs.dll in nickname exploit fix. Offset is retrieved from 0x426B8F
	unsigned long pLimitMax = 0;
	memcpy(&pLimitMax, (void *)0x426B8F, 4);
	if (pLimitMax >= 0x45000000 && pLimitMax < 0x45100000)
		*(int *)pLimitMax = 127;

	// Remove "plimit" patch placed bhs.dll in game_info
	unsigned char disableBHSpLimit[] = { 0x8B, 0xB0, 0xF8, 0x01, 0x00, 0x00 };
	PatchData(&disableBHSpLimit,6,0x426B8D);
	PatchData(&disableBHSpLimit,6,0x426BE3);

	unsigned char Joingame_Hook_Bytes[] = { 0xE8, 0xFE, 0x19, 0x01, 0x00 };
	unsigned char Callback_Hook_Bytes[] = { 0xFF, 0x76, 0x08, 0xFF, 0x76, 0x04 };
	if (!memcmp((void *)0x2100B515,Joingame_Hook_Bytes,5) && !memcmp((void *)0x21008844,Callback_Hook_Bytes,6))
	{
		PatchCall(&WOLAPI_JOINGAME_Response_Hook,0x2100B515);
		PatchJump(&WOLAPI_Hook_Callback,0x21008844);
#ifdef __DEV__
		PatchJump(&WOLAPI_Income_Data_Hook,0x21009178);
		PatchJump(&WOLAPI_Outgoing_Data_Hook,0x2100E639);
#endif
	}
	else
		Console.Output("Error - Failed to initial WOL functions. Players can NOT join via WOL if the channel is full. \n");
}
__declspec(naked) void WOLAPI_CreateChannel_Hook()
{
	_asm {
		mov eax, [eax+0x1AC]
		push eax
		call Setup_WOLAPI_Hook
		pop eax
		mov ecx, 0x4C7556
		jmp ecx
	}
}
void DLL_Init()
{
	// Hooks registration
	RegisterLoadLevelHook(ReservedSlotClass::Load);
	RegisterFrameHook(Frame_Hook);
	RegisterSerialHashHook(ReservedSlotClass::ReceiveSerial);
	PatchCall(&ProcessConnectionRequest_Hook,0x6185E8);
	PatchJump(&cRemoteHostSizePatch,0x617ED0);
	PatchJump(&WOLAPI_CreateChannel_Hook,0x4C7550);

	// Initial console commands
#ifdef __DEV__
	ReservedSlotList = new ReservedSlotListConsoleCommand;
#endif
	ReloadReservedSlot = new ReloadReservedSlotConsoleCommand;
	AddTempReservedSlot = new AddTempReservedSlotConsoleCommand;
	MaxPlayersLimit = new MaxPlayersLimitConsoleCommand;

	// Initial main class
	ReservedSlot = new ReservedSlotClass;

	// Just a message...
	printf("ReservedSlot.dll %s by Adad loaded - Built-on %s %s\n",VERSION_STATE,__DATE__,__TIME__);
}
