#ifndef FDS_STRING
#define FDS_STRING

class StringClass {
public:
	char *m_Buffer;
	static char **m_EmptyString;
	static char *m_NullChar;
	StringClass() {
		this->m_Buffer = *this->m_EmptyString;
	}
	StringClass &operator=(StringClass &str) {
		this->Uninitialised_Grow(strlen(str.m_Buffer) +1);
		this->Store_Length(strlen(str.m_Buffer));
		memcpy(this->m_Buffer,str.m_Buffer,strlen(str.m_Buffer) +1);
		return *this;
	}
	StringClass &operator=(const char *str) {
		if (str) {
			this->Uninitialised_Grow(strlen(str) +1);
			this->Store_Length(strlen(str));
			memcpy(this->m_Buffer,str,strlen(str) +1);
		}
		return *this;
	}
	~StringClass() {
		this->Free_String();
	}
	char operator[](int Index)
	{
		return this->m_Buffer[Index];
	}
	int Get_Length();
	void Store_Length(int length);
	void Get_String(int size, bool is_temp);
	void Resize(int size);
	void Uninitialised_Grow(int size);
	void Free_String();
	void Format_Args(const char *str, va_list &args);
	void Format(const char *text, ...);
	void Copy_Wide(const wchar_t *wstr);
};

class WideStringClass {
public:
	wchar_t *m_Buffer;
	static wchar_t **m_EmptyString;
	static wchar_t *m_NullChar;
	WideStringClass() {
		this->m_Buffer = *this->m_EmptyString;
	}
	WideStringClass &operator=(WideStringClass &wstr) {
		this->Uninitialised_Grow(wcslen(wstr.m_Buffer) +2);
		this->Store_Length(wcslen(wstr.m_Buffer));
		memcpy(this->m_Buffer,wstr.m_Buffer,wcslen(wstr.m_Buffer) +2);
		return *this;
	}
	wchar_t operator[](int Index)
	{
		return this->m_Buffer[Index];
	}
	~WideStringClass() {
		this->Free_String();
	}
	int Get_Length();
	void Store_Length(int length);
	void Convert_From(char const *text);
	void Uninitialised_Grow(int size);
	wchar_t Get_String(int size, bool is_temp);
	void Resize(int size);
	void Free_String();
	void Format(wchar_t const *text, ...);
	bool Is_ANSI();
};

#endif
