#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "scripts.h"
#include "fds.h"
#include "Hooks_Base.h"

_RegisterRadioHook RegisterRadioHook;
_RegisterChatHook RegisterChatHook;
_RegisterJoinHook RegisterJoinHook;
_RegisterFrameHook RegisterFrameHook;
_RegisterSerialHashHook RegisterSerialHashHook;
_RegisterPlayerLeftHook RegisterPlayerLeftHook;
_RegisterSpawnHook RegisterSpawnHook;
_RegisterLoadLevelHook RegisterLoadLevelHook;
_RegisterGameOverHook RegisterGameOverHook;
_RegisterFDSStartUpHook RegisterFDSStartUpHook;
_GetHooksVersion Get_Hooks_Version;

bool Init_Hooks()
{
	FILE *Hooks = fopen("Hooks.dll","r");
	if (!Hooks)
		return false;
	fclose(Hooks);
	HMODULE HooksDLL = LoadLibrary("Hooks.dll");
	RegisterRadioHook = (_RegisterRadioHook)GetProcAddress(HooksDLL,"Register_RadioHook");
	RegisterChatHook = (_RegisterChatHook)GetProcAddress(HooksDLL,"Register_ChatHook");
	RegisterJoinHook = (_RegisterJoinHook)GetProcAddress(HooksDLL,"Register_JoinHook");
	RegisterFrameHook = (_RegisterFrameHook)GetProcAddress(HooksDLL,"Register_FrameHook");
	RegisterSerialHashHook = (_RegisterSerialHashHook)GetProcAddress(HooksDLL,"Register_SerialHashHook");
	RegisterPlayerLeftHook = (_RegisterPlayerLeftHook)GetProcAddress(HooksDLL,"Register_PlayerLeftHook");
	RegisterSpawnHook = (_RegisterSpawnHook)GetProcAddress(HooksDLL,"Register_SpawnHook");
	RegisterLoadLevelHook = (_RegisterLoadLevelHook)GetProcAddress(HooksDLL,"Register_LoadLevelHook");
	RegisterGameOverHook = (_RegisterGameOverHook)GetProcAddress(HooksDLL,"Register_GameOverHook");
	RegisterFDSStartUpHook = (_RegisterFDSStartUpHook)GetProcAddress(HooksDLL,"Register_FDSStartUpHook");
	Get_Hooks_Version = (_GetHooksVersion)GetProcAddress(HooksDLL,"Get_Version");
	return true;
}
