#ifndef FDS_CONSOLE
#define FDS_CONSOLE

#include "fds.h"

class ConsoleFunctionClass;
class ConsoleFunctionManager {
public:
	void Init();
	void Shutdown();
	static void Sort_Function_List();
	void Help(const char *str);
	int Get_Function_Count();
	static void Verbose_Help_File();
	void Next_Verbose_Help_Screen();
	void Parse_Input(const char *str);
	bool Get_Command_Suggestion(const char *, const char *);
	ConsoleFunctionClass *Find_Function_Node(char const *str);
	void Print(const char *str, ...);
	static DynamicVectorClass<ConsoleFunctionClass *> &FunctionList;
	static unsigned int &Count;
};

class ConsoleFunctionClass {
public:
	virtual const char *Get_Name() = 0;
	virtual const char *Get_Alias() {
		return 0;
	}
	virtual const char *Get_Help() = 0;
	virtual void Activate(char *) = 0;
	virtual ~ConsoleFunctionClass() {
	}
	ConsoleFunctionClass() {
		_asm {
			lea eax, this
			push eax
			mov eax, 0x428FE0
			mov ecx, 0x81D098
			call eax
		}
	}
};

class ConsoleModeClass {
public:
	char *Get_Log_File_Name();
	void Log_To_Disk(const char *message);
	void Add_Message(WideStringClass *wstr, Vector3 *color, bool unk);
};
extern ConsoleModeClass *ConsoleMode;

ConsoleFunctionClass *Find_Console_Command(const char *name);
void Remove_Console_Command(const char *name);

#endif
