#ifndef FDS_AUDIO
#define FDS_AUDIO

/* Don't have */
class LogicalSoundClass;


class AudiableSoundDefinitionClass : public DefinitionClass {
public:
	virtual ~AudiableSoundDefinitionClass();
	PersistFactoryClass &Get_Factory();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	PersistClass *Create();
	virtual AudibleSoundClass *Create_Sound(int);
	virtual void Initialize_From_Sound(AudibleSoundClass *);
	virtual StringClass Get_Filename(void);
	virtual StringClass Get_Display_Text(void);
	virtual float Get_Max_Vol_Radius(void);
	virtual float Get_DropOff_Radius(void);
	virtual Vector3 Get_Sphere_Color(void);
	virtual float Get_Volume(void);
	virtual float Get_Volume_Randomizer(void);
	virtual float Get_Start_Offset(void);
	virtual float Get_Pitch_Factor(void);
	virtual float Get_Pitch_Factor_Randomizer(void);
	virtual int Get_Virtual_Channel(void);
	virtual void Set_Volume(float);
	virtual void Set_Volume_Randomizer(float);
	virtual void Set_Max_Vol_Radius(float);
	virtual void Set_DropOff_Radius(float);
	virtual void Set_Start_Offset(float);
	virtual void Set_Pitch_Factor(float);
	virtual void Set_Pitch_Factor_Randomizer(float);
	virtual void Set_Virtual_Channel(int);
	virtual LogicalSoundClass *Create_Logical(void);
	float Priority; // 0x1C
	float Volume; // 0x20
	float Volume_Random; // 0x24
	float Pad; // 0x28
	int LoopCount; // 0x2C
	int VirtualChannel; // 0x30
	float DropOffRadius; // 0x34
	float MaxVolRadius; // 0x38
	bool Is3DSound; // 0x3C
	StringClass Filename; // 0x40
	int Type; // 0x44
	StringClass DisplayText; // 0x48
	float StartOffset; // 0x4C
	float PitchFactor; // 0x50
	float PitchFactorRandom; // 0x54
	int LogicalType; // 0x58
	float LogicalNotifyDelay; // 0x5C
	float LogicalDropOffRadius; // 0x60
	bool CreateLogicalSound; // 0x64
	Vector3 SphereColor; // 0x68
};

#endif
