#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <psapi.h>
#include <vector>
#include "scripts.h"
#include "fds.h"
#include "ncVector.h"
#include "Hooks.h"

std::vector<unsigned long> RadioHookCallList;
std::vector<unsigned long> ChatHookCallList;
std::vector<unsigned long> JoinHookCallList;
std::vector<unsigned long> FrameHookCallList;
std::vector<unsigned long> SerialHashHookCallList;
std::vector<unsigned long> PlayerLeftHookCallList;
std::vector<unsigned long> SpawnHookCallList;
std::vector<unsigned long> LoadLevelHookCallList;
std::vector<unsigned long> GameOverHookCallList;
std::vector<unsigned long> FDSStartUpHookCallList;

extern "C" {
BOOL __declspec(dllexport) __stdcall DllMain(HINSTANCE hinstDLL,
						DWORD	ul_reason_for_call,
						LPVOID	lpReserved
					 )
{
	return TRUE;
}

__declspec(dllexport) void Register_RadioHook(unsigned long offset)
{
	RadioHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_ChatHook(unsigned long offset)
{
	ChatHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_JoinHook(unsigned long offset)
{
	JoinHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_FrameHook(unsigned long offset)
{
	FrameHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_SerialHashHook(unsigned long offset)
{
	SerialHashHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_PlayerLeftHook(unsigned long offset)
{
	PlayerLeftHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_SpawnHook(unsigned long offset)
{
	SpawnHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_LoadLevelHook(unsigned long offset)
{
	LoadLevelHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_GameOverHook(unsigned long offset)
{
	GameOverHookCallList.push_back(offset);
}

__declspec(dllexport) void Register_FDSStartUpHook(unsigned long offset)
{
	FDSStartUpHookCallList.push_back(offset);
}

__declspec(dllexport) double Get_Version()
{
	return VERSION;
}

} // extern "C"

void PatchData(void *buf, unsigned long size, unsigned long addr) {
	unsigned long PID = GetCurrentProcessId();
	HANDLE PHandle = OpenProcess(PROCESS_ALL_ACCESS, false, PID);
	WriteProcessMemory(PHandle, (void *)addr, buf, size, NULL);
	CloseHandle(PHandle);
}
void PatchJump(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char jmp = 0xE9;
	PatchData(&jmp,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchCall(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char call = 0xE8;
	PatchData(&call,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchByte(unsigned char Byte, unsigned long size, unsigned long addr) {
	for (unsigned long i = 0; i < size; i++) PatchData(&Byte,1,addr +i);
}

bool __stdcall ClientChat(nc_cCsTextObj *CsTextObj)
{
	bool Continue = true;
	typedef bool (*_ChatHook)(nc_cCsTextObj *);
	for (unsigned int i = 0; i < ChatHookCallList.size(); i++)
	{
		if (!((_ChatHook)ChatHookCallList[i])(CsTextObj))
		{
			Continue = false;
			CsTextObj->Set_Delete_Pending();
		}
	}
	return Continue;
}
__declspec(naked) void ClientChat_Hook()
{
	_asm {
		push ecx
		push ecx
		call ClientChat
		test al, al
		pop ecx
		jz nomsg
		push esi
		mov esi, ecx
		push 0x7F4068
		mov edx, 0x4B5C18
		jmp edx
nomsg:
		retn
	}
}

bool __stdcall ClientRadio(nc_CSAnnouncement *Radio)
{
	typedef bool (*_RadioHook)(nc_CSAnnouncement *);
	for (unsigned int i = 0; i < RadioHookCallList.size(); i++)
	{
		if (!((_RadioHook)RadioHookCallList[i])(Radio))
		{
			Radio->Set_Delete_Pending();
			return false;
		}
	}
	return true;
}
__declspec(naked) void ClientRadio_Hook()
{
	_asm {
		push ecx
		push ecx
		call ClientRadio
		test al, al
		pop ecx
		jz noradio
		push edi
		mov edi, ecx
		push 0x7F4068
		mov edx, 0x4B3668
		jmp edx
noradio:
		retn
	}
}

void __stdcall PlayerJoin(nc_cPlayer *pData)
{
	typedef bool (*_JoinHook)(nc_cPlayer *);
	for (unsigned int i = 0; i < JoinHookCallList.size(); i++)
		((_JoinHook)JoinHookCallList[i])(pData);
}
__declspec(naked) void PlayerJoin_Hook()
{
	_asm {
		pusha
		push esi
		call PlayerJoin
		popa
		mov ecx, 0x81FF84
		mov ecx, [ecx]
		mov edx, 0x4B4517
		jmp edx
	}
}

void __stdcall Frame_Hook()
{
	if (nc_cNetwork::PServerConnection)
	{
		typedef bool (*_FrameHook)();
		for (unsigned int i = 0; i < FrameHookCallList.size(); i++)
			((_FrameHook)FrameHookCallList[i])();
	}
	_asm {
		mov eax, 0x405660
		call eax
	}
}

void __stdcall SerialHash(nc_cGameSpyCsChallengeResponseEvent *Response)
{
	typedef void (*_SerialHashHook)(nc_cGameSpyCsChallengeResponseEvent *);
	for (unsigned int i = 0; i < SerialHashHookCallList.size(); i++)
		((_SerialHashHook)SerialHashHookCallList[i])(Response);
}
__declspec(naked) void SerialHash_Hook()
{
	_asm {
		push ebp
		mov ebp, esp
		push ecx
		call SerialHash
		mov esp, ebp
		pop ebp
		retn 4
	}
}

void __stdcall PlayerLeft(int pID)
{
	typedef void (*_PlayerLeftHook)(int);
	for (unsigned int i = 0; i < PlayerLeftHookCallList.size(); i++)
		((_PlayerLeftHook)PlayerLeftHookCallList[i])(pID);
}
__declspec(naked) void PlayerLeft_Hook()
{
	_asm {
		push ebp
		mov ebp, esp
		push [ebp+0x1C]
		call PlayerLeft
		mov esp, ebp
		pop ebp
		pop ebx
		add esp, 0x10
		retn
	}
}

bool __stdcall SpawnProc_Hook(int pID)
{
	typedef bool (*_SpawnHook)(int);
	for (unsigned int i = 0; i < SpawnHookCallList.size(); i++)
		if (!((_SpawnHook)SpawnHookCallList[i])(pID))
			return false;
	return true;
}
__declspec(naked) void Spawn_Hook(int pID)
{
	_asm {
		push ebp
		mov ebp, esp
		push pID
		call SpawnProc_Hook
		mov esp, ebp
		pop ebp
		test al, al
		jz disallow
		sub esp, 0x12C
		mov eax, 0x4067D6
		jmp eax
disallow:
		retn
	}
}

void __stdcall GameOver_Hook() {
	typedef void (*_GameOverHook)();
	for (unsigned int i = 0; i < GameOverHookCallList.size(); i++)
		((_GameOverHook)GameOverHookCallList[i])();
	_asm {
		mov al, [0x81D524]
	}
}

void __stdcall LevelLoaded_Hook() {
	typedef void (*_LoadLevelHook)();
	for (unsigned int i = 0; i < LoadLevelHookCallList.size(); i++)
		((_LoadLevelHook)LoadLevelHookCallList[i])();
	_asm {
		mov eax, [0x81FF84]
		mov eax, [eax]
	}
}

void __stdcall FDSStartUp_Hook()
{
	typedef void (*_FDSStartUpHook)();
	for (unsigned int i = 0; i < FDSStartUpHookCallList.size(); i++)
		((_FDSStartUpHook)FDSStartUpHookCallList[i])();
	nc_ConsoleFunctionManager::Sort_Function_List();
}

void Join_Hook(nc_cPlayer *pData)
{
	if (Get_Game_Mode() != 4) Request_Serial(pData->PlayerId);
}

Init_Class::Init_Class()
{
	const char *LoadDLL[] = {
		"Serial.dll",
		"ReservedSlot.dll",
		"TextFilter.dll",
	};
	for (int i = 0; i < sizeof(LoadDLL) /4; i++)
	{
		FILE *DLL = fopen(LoadDLL[i],"r");
		if (DLL)
		{
			fclose(DLL);
			LoadLibrary(LoadDLL[i]);
		}
	}

	// Install hooks
	PatchJump(&ClientChat_Hook,0x4B5C10);
	PatchJump(&ClientRadio_Hook,0x4B3660);
	PatchJump(&PlayerJoin_Hook,0x4B4511);
	PatchCall(&Frame_Hook,0x43B9D2);
	PatchJump(&SerialHash_Hook,0x4B7134);
	PatchJump(&PlayerLeft_Hook,0x461D2B);
	PatchJump(&Spawn_Hook,0x4067D0);
	PatchCall(&GameOver_Hook,0x474C9A);
	PatchCall(&LevelLoaded_Hook,0x40244B);
	PatchCall(&FDSStartUp_Hook,0x4264C1);

	int buf = (int)&Join_Hook;
	Register_JoinHook(buf);
}
Init_Class InitClass;
