#ifndef FDS_PHYSICS
#define FDS_PHYSICS

/* Forwarder */
class PhysClass;
class DynamicPhysClass;
class MoveablePhysClass;
class Phys3Class;
class RigidBodyClass;
class HumanPhysClass;
class VehiclePhysClass;
class MotorVehicleClass;
class WheeledVehicleClass;
class TrackedVehicleClass;
class VTOLVehicleClass;
class StaticPhysClass;
class StaticAnimPhysClass;
class RenderObjClass;
class MaterialEffectClass;
class DefenseObjectDefClass;

/* Don't have */
class PhysRayCollisionTestClass;
class PhysAABoxCollisionTestClass;
class PhysOBBoxCollisionTestClass;
class PhysAABoxIntersectionTestClass;
class PhysOBBoxIntersectionTestClass;
class PhysMeshIntersectionTestClass;
class RenderInfoClass;
class SpecialRenderInfoClass;
class StateVectorClass;
class Matrix3;
class SceneClass;
class CullSystemClass;


class AnimCollisionManagerDefClass {
public:
	int CollisionMode; // 0x0
	int AnimationMode; // 0x4
	StringClass AnimationName; // 0x8
};

class DynamicShadowManagerClass {
public:
	PhysClass *Physics; // 0x0
	int unkds1; // 0x4
	float unkds2; // 0x8
	float unkds3; // 0xC
	bool unkds4; // 0x10
	float unkds5; // 0x14
	float unkds6; // 0x18
	float unkds7; // 0x1C
};

class ProjectorManagerDefClass {
public:
	bool Enable; // 0x0
	bool Perspective_Projection; // 0x1
	bool IsAdditive; // 0x2
	bool IsAnimated; // 0x3
	float OrthoWidth; // 0x4
	float OrthoHeight; // 0x8
	float HorizontalFOV; // 0xC
	float VerticalFOV; // 0x10
	float NearZ; // 0x14
	float FarZ; // 0x18
	float Intensity; // 0x1C
	StringClass TextureName; // 0x20
	StringClass BoneName; // 0x24
};

class CullSystemClass {
public:
	MultiListClass<PhysClass> List;
};

class CullableClass : public RefCountClass {
public:
	CullSystemClass *CullSystem; // 0x4
	int unkc2; // 0x8
	AABoxClass BoundingBox; // 0xC
};

class PhysDefClass : public DefinitionClass {
public:
	virtual ~PhysDefClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	const char *Get_Type_Name();
	bool Is_Type(const char *);
	StringClass ModelName; // 0x1C
	bool Is_Pre_Lit; // 0x20
};
class PhysClass : public CullableClass, public PersistClass, public MultiListObjectClass {
public:
	~PhysClass();
	virtual void Definition_Changed();
	virtual bool Needs_Timestep();
	virtual void pure_virtual1();
	virtual void Post_Timestep_Process();
	virtual void pure_virtual2();
	virtual void pure_virtual3();
	virtual int Cast_Ray(PhysRayCollisionTestClass &);
	virtual int Cast_AABox(PhysAABoxCollisionTestClass &);
	virtual int Cast_OBBox(PhysOBBoxCollisionTestClass &);
	virtual int Intersection_Test(PhysAABoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysOBBoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysMeshIntersectionTestClass &);
	virtual void Link_To_Carrier(PhysClass *,RenderObjClass *);
	virtual void Peek_Carrier_Sub_Object();
	virtual int Push(Vector3  const&);
	virtual int Internal_Link_Rider(PhysClass *);
	virtual bool Internal_Unlink_Rider(PhysClass *);
	virtual void Set_Model(RenderObjClass *);
	virtual unsigned int Get_Vis_Object_ID();
	virtual void Render(RenderInfoClass &);
	virtual void Vis_Render(SpecialRenderInfoClass &);
	virtual void Render_Vis_Meshes(RenderInfoClass &);
	virtual void Get_Shadow_Blob_Box(AABoxClass *);
	virtual bool Is_Casting_Shadow();
	virtual DynamicPhysClass *As_DynamicPhysClass(); // 0x68
	virtual MoveablePhysClass *As_MoveablePhysClass(); // 0x6C
	virtual Phys3Class *As_Phys3Class(); // 0x70
	virtual HumanPhysClass *As_HumanPhysClass(); // 0x74
	virtual RigidBodyClass *As_RigidBodyClass(); // 0x78
	virtual VehiclePhysClass *As_VehiclePhysClass(); // 0x7C
	virtual MotorVehicleClass *As_MotorVehicleClass(); // 0x80
	virtual WheeledVehicleClass *As_WheeledVehicleClass(); // 0x84
	virtual void *As_MotorcycleClass(); // 0x88
	virtual TrackedVehicleClass *As_TrackedVehicleClass(); // 0x8C
	virtual VTOLVehicleClass *As_VTOLVehicleClass(); // 0x90
	virtual StaticPhysClass *As_StaticPhysClass(); // 0x94
	virtual StaticAnimPhysClass *As_StaticAnimPhysClass(); // 0x98
	virtual void As_ElevatorPhysClass(); // 0x9C
	virtual void As_DamageableStaticPhysClass(); // 0xA0
	virtual void As_DoorPhysClass(); // 0xA4
	virtual void As_DecorationPhysClass(); // 0xA8
	virtual void As_TimedDecorationPhysClass(); // 0xAC
	virtual void As_DynamicAnimPhysClass(); // 0xB0
	virtual void As_LightPhysClass(); // 0xB4
	virtual void As_RenderObjPhysClass(); // 0xB8
	virtual void As_ProjectileClass(); // 0xBC
	virtual void As_AccessiblePhysClass(); // 0xC0
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual bool Is_Simulation_Disabled();
	virtual bool Is_Rendering_Disabled();
	virtual void Update_Sun_Status();
	virtual void On_Post_Load();
	int CollisionMode; // 0x38
	RenderObjClass *PhysRender; // 0x3C
	StringClass NamePrefix; // 0x40
	int unkp2; // 0x44
	int VisObjectID; // 0x48
	CombatPhysObserverClass *PhysObserver; // 0x4C
	PhysDefClass *Definition; // 0x50
	RefMultiListClass<MaterialEffectClass> MaterialRefList; // 0x54
	int unkp5; // 0x6C
	int unkp6; // 0x70
	int unkp7; // 0x74
};

class DynamicPhysDefClass : public PhysDefClass {
public:
	// No variable
};
class DynamicPhysClass : public PhysClass {
public:
	~DynamicPhysClass();
	virtual void Set_Model(RenderObjClass *);
	virtual unsigned int Get_Vis_Object_ID();
	DynamicPhysClass *As_DynamicPhysClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual bool Is_Simulation_Disabled();
	virtual bool Is_Rendering_Disabled();
	void On_Post_Load();
	bool unkdp1; // 0x78
	int unkdp2; // 0x7C
	int unkdp3; // 0x80
};

class WW3DAssetManager {
public:
};
class RiderManagerClass {
public:
	MultiListClass<PhysClass> List;
};
class AnimCollisionManagerClass {
public:
	struct CollidableObjClass {
	};
	int var0;
	int AnimationMode;
	float var8;
	float LoopStart; // 0xC
	float LoopEnd; // 0x10
	WW3DAssetManager *WW3DAsset; // 0x14
	float CurrentFrame; // 0x18
	int var1C;
	int var20;
	RiderManagerClass RiderManager; // 0x24
	float EndFrame; // 0x38
	int var3C;
	DynamicVectorClass<AnimCollisionManagerClass::CollidableObjClass> CollidableObjList; // 0x40
};
class DecorationPhysClass : public DynamicPhysClass {
public:
	int var84;
	int var88;
	int var8C;
	int var90;
	int var94;
	int var98;
	AnimCollisionManagerClass *AnimCollsionManager; // 0x9C
};

class MoveablePhysDefClass : public DynamicPhysDefClass {
public:
	float Mass; // 0x24
	float GravScale; // 0x28
	float Elasticity; // 0x2C
	int CinematicCollisionMode; // 0x30
};
class MoveablePhysClass : public DynamicPhysClass {
public:
	~MoveablePhysClass();
	virtual void Definition_Changed();
	virtual bool Needs_Timestep();
	virtual void Post_Timestep_Process();
	virtual void Link_To_Carrier(PhysClass *,RenderObjClass *);
	virtual void Peek_Carrier_Sub_Object();
	virtual void Get_Shadow_Blob_Box(AABoxClass *);
	virtual bool Is_Casting_Shadow();
	MoveablePhysClass *As_MoveablePhysClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	void On_Post_Load();
	virtual void Set_Mass(float);
	virtual void Set_Gravity_Multiplier(float);
	virtual void Set_Elasticity(float);
	virtual void Get_Inertia_Inv(Matrix3 *);
	virtual bool Can_Teleport(Matrix3D  const&,bool,MultiListClass<PhysClass> *);
	virtual bool Can_Teleport_And_Stand(Matrix3D const&,Matrix3D *); // 0xE4
	virtual void Find_Teleport_Location(Vector3 const&,float,Vector3 *);
	virtual bool Can_Move_To(Matrix3D const&);
	virtual int Cinematic_Move_To(Matrix3D  const&);
	float MassDef; // 0x84
	float MassProc; // 0x88
	float GravityMultiplier; // 0x8C
	float Elasticity; // 0x90
	int unkmp5; // 0x94
	int unkmp6; // 0x98
	int unkmp7; // 0x9C
	DynamicShadowManagerClass Shadow; // 0xA0
};

class Phys3DefClass : public MoveablePhysDefClass {
public:
	float NormSpeed; // 0x34
	float SlideAngel; // 0x38
	float StepHeight; // 0x3C
};
class Phys3Class : public MoveablePhysClass {
public:
	struct GroundStateStruct {
		bool unk; // 0x0
		bool unkgss2; // 0x1
		bool unkgss3; // 0x2
		int unkgss4; // 0x4
		int unkgss5; // 0x8
		Vector3 unkgss6; // 0xC
		Vector3 unkgss7; // 0x18
		PhysClass *GroundPhysics; // 0x24
		int unkgss9; // 0x28
	};
	~Phys3Class();
	virtual void Timestep(float);
	virtual Matrix3D *Get_Transform();
	virtual void Set_Transform();
	virtual int Cast_Ray(PhysRayCollisionTestClass &);
	virtual int Cast_AABox(PhysAABoxCollisionTestClass &);
	virtual int Cast_OBBox(PhysOBBoxCollisionTestClass &);
	virtual int Intersection_Test(PhysAABoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysOBBoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysMeshIntersectionTestClass &);
	virtual int Push(Vector3  const&);
	virtual void Set_Model(RenderObjClass *);
	virtual void Get_Shadow_Blob_Box(AABoxClass *);
	Phys3Class *As_Phys3Class();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	void On_Post_Load();
	virtual bool Can_Teleport(Matrix3D  const&,bool,MultiListClass<PhysClass> *);
	virtual bool Can_Teleport_And_Stand(Matrix3D const&,Matrix3D *);
	virtual void Find_Teleport_Location(Vector3 const&,float,Vector3 *);
	virtual bool Can_Move_To(Matrix3D const&);
	virtual void Get_Velocity(Vector3 *);
	virtual void Set_Velocity(Vector3  const&);
	virtual AABoxClass *Get_Bounding_Box();
	virtual AABoxClass *Get_Collision_Box();
	virtual void Apply_Impulse(Vector3  const&);
	virtual void Apply_Impulse(Vector3  const&,Vector3  const&);
	virtual bool Is_In_Contact();
	virtual void Set_In_Contact(bool);
	virtual int Get_Contact_Surface_Type();
	virtual void Invalidate_Ground_State();
	virtual void Set_Position(Vector3  const&);
	virtual Vector3 *Get_Position();
	virtual void Set_Heading(float);
	virtual float Get_Heading();
	virtual void Set_Slide_Angle(float);
	virtual float Get_Slide_Angle();
	virtual void Set_Normalized_Speed(float); // 0x138
	virtual float Get_Normalized_Speed(); // 0x13C
	virtual bool Collide(Vector3  const&);
	PersistFactoryClass &Get_Factory();
	virtual int Get_Ground_State();
	virtual void Check_Ground(AABoxClass  const&,Phys3Class::GroundStateStruct *,float);
	virtual int User_Move(float);
	virtual int Ballistic_Move(float);
	virtual int Slide_Move(Phys3Class::GroundStateStruct  const&,float);
	virtual int Normal_Move(Phys3Class::GroundStateStruct  const&,float);
	virtual int Collide_Move(Vector3  const&,float);
	AABoxClass ShadowBlob; // 0xC0
	bool IsInContact; // 0xD8
	int ContactSurfaceType; // 0xDC
	Vector3 Position; // 0xE0
	Vector3 Velocity; // 0xEC
	float Heading; // 0xF8
	float NormSpeed; // 0xFC
	Vector3 SlideAngel; // 0x100
	float StepHeight; // 0x10C
	int unkp32; // 0x110
	int unkp33; // 0x114
	Phys3Class::GroundStateStruct GroundState; // 0x118
	int unkp34; // 0x144
};

class RigidBodyDefClass : public MoveablePhysDefClass {
public:
	float AerodynamicDrag; // 0x34
	int unkrbd2; // 0x38
};
class RigidBodyClass : public MoveablePhysClass {
public:
	~RigidBodyClass();
	virtual void Timestep(float);
	virtual Matrix3D *Get_Transform();
	virtual void Set_Transform(const Matrix3D &);
	virtual int Cast_Ray(PhysRayCollisionTestClass &);
	virtual int Cast_AABox(PhysAABoxCollisionTestClass &);
	virtual int Cast_OBBox(PhysOBBoxCollisionTestClass &);
	virtual int Intersection_Test(PhysAABoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysOBBoxIntersectionTestClass &);
	virtual int Intersection_Test(PhysMeshIntersectionTestClass &);
	virtual int Push(const Vector3 &);
	virtual void Set_Model(RenderObjClass *);
	virtual void Get_Shadow_Blob_Box(AABoxClass *);
	RigidBodyClass *As_RigidBodyClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	void On_Post_Load();
	virtual void Set_Mass(float);
	virtual void Get_Inertia_Inv(Matrix3 *);
	virtual bool Can_Teleport(Matrix3D  const&,bool,MultiListClass<PhysClass> *);
	virtual bool Can_Teleport_And_Stand(Matrix3D  const&,Matrix3D*);
	virtual void Get_Velocity(Vector3 *);
	virtual void Set_Velocity(Vector3  const&);
	virtual void Get_Bounding_Box();
	virtual void Get_Angular_Velocity(Vector3 *);
	virtual void Set_Angular_Velocity(Vector3  const&);
	virtual void Apply_Impulse(Vector3  const&);
	virtual void Apply_Impulse(Vector3  const&,Vector3  const&);
	PersistFactoryClass &Get_Factory();
	void Get_State(StateVectorClass &);
	void Set_State(StateVectorClass  const&,int);
	void Compute_Derivatives(float,StateVectorClass *,StateVectorClass *,int);
	virtual void Compute_Inertia();
	virtual void Compute_Force_And_Torque(Vector3 *,Vector3 *);
	virtual bool Can_Go_To_Sleep(float);
	class ODESystemClass {
		char ode_holder[0x58];
	};
	ODESystemClass ODE; // 0xC0
};

class ProjectileClass : public MoveablePhysClass {
public:
};

class HumanPhysDefClass : public Phys3DefClass {
public:
	// No variable
};
class HumanPhysClass : public Phys3Class {
public:
	virtual ~HumanPhysClass();
	virtual void Timestep(float);
	virtual void Render(RenderInfoClass &);
	HumanPhysClass *As_HumanPhysClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual bool Is_Simulation_Disabled();
	virtual bool Is_Rendering_Disabled();
	PersistFactoryClass &Get_Factory();
	virtual void Check_Ground(AABoxClass  const&,Phys3Class::GroundStateStruct *,float);
	virtual int Slide_Move(Phys3Class::GroundStateStruct  const&,float);
	virtual int Normal_Move(Phys3Class::GroundStateStruct  const&,float);
};

class VehiclePhysDefClass : public RigidBodyDefClass {
public:
	float SpringConstant; // 0x3C
	float DampingConstant; // 0x40
	float SpringLength; // 0x44
	float TractionMultiplier; // 0x48
	float LateralMomentArm; // 0x4C
	float TractiveMomentArm; // 0x50
	float EngineFlameLength; // 0x54
	bool IsFake; // 0x58
};
class VehiclePhysClass : public RigidBodyClass {
public:
	~VehiclePhysClass();
	virtual void Definition_Changed();
	virtual void Timestep(float);
	virtual void Set_Model(RenderObjClass *);
	virtual void Render(RenderInfoClass &);
	VehiclePhysClass *As_VehiclePhysClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	virtual bool Is_Simulation_Disabled();
	virtual bool Is_Rendering_Disabled();
	virtual void Compute_Force_And_Torque(Vector3 *, Vector3 *);
	virtual bool Can_Go_To_Sleep(float);
	virtual void pure_virtual4();
	virtual float Get_Normalized_Engine_Flame();
};

class VTOLVehicleDefClass : public VehiclePhysDefClass {
public:
	float MaxVerticalAcceleration; // 0x5C
	float MaxHorizontalAcceleration; // 0x60
	float MaxFuselagePitch; // 0x64
	float MaxFuselageRoll; // 0x68
	float PitchControllerGain; // 0x6C
	float PitchControllerDamping; // 0x70
	float RollControllerGain; // 0x74
	float RollControllerDamping; // 0x78
	float MaxYewVelocity; // 0x7C
	float YawControllerGain; // 0x80
	float MaxEngineRotation; // 0x84
	float RotorSpeed; // 0x88
	float RotorAcceleration; // 0x8C
	float RodorDeceleration; // 0x90
};
class VTOLVehicleClass : public VehiclePhysClass {
public:
	~VTOLVehicleClass();
	virtual void Timestep(float);
	virtual void Set_Model(RenderObjClass *);
	virtual void Render(RenderInfoClass &);
	VTOLVehicleClass *As_VTOLVehicleClass();
	bool Save(ChunkSaveClass &);
	bool Load(ChunkLoadClass &);
	void On_Post_Load();
	PersistFactoryClass &Get_Factory();
	virtual void Compute_Force_And_Torque(Vector3 *, Vector3 *);
	virtual void Alloc_Suspension_Element();
	virtual float Get_Normalized_Engine_Flame();
	virtual bool Can_Go_To_Sleep(float);
	//float EngineFlame; // 0x330
};

class MotorVehicleDefClass : public VehiclePhysDefClass {
public:
	float MaxEngineTorque; // 0x5C
	StringClass EngineTorqueCurveFileName; // 0x60
	int unkmvd1; // 0x64
	int GearCount; // 0x68
	float GearRatio[12]; // 0x6C
	float FinaDriveGearRatio; // 0x9C
	float DriveTrainIntertia; // 0xA0
	float ShiftUpRpm; // 0xA4
	float ShiftDownRpm; // 0xA8
	float MaxSteeringAngel; // 0xAC
	float unkmvd2; // 0xB0
};

class TrackedVehicleDefClass : public VehiclePhysDefClass {
public:
	float MaxEngineTorque; // 0x5C
	float TrackUScaleFactor; // 0x60
	float TrackVScaleFactor; // 0x64
	float TurnTorqueScaleFactor; // 0x68
};

class WheeledVehicleDefClass : public MotorVehicleDefClass {
public:
	float unkwvd; // 0xB4
};

class MotorcycleDefClass : public WheeledVehicleDefClass {
public:
	float LeanK0; // 0xB8
	float LeanK1; // 0xBC
};

class DecorationPhysDefClass : public PhysDefClass {
public:
	// No variable
};

class DynamicAnimPhysDefClass : public DecorationPhysDefClass {
public:
	AnimCollisionManagerDefClass AnimCollisionManagerDefinition; // 0x24
	bool CastsShadows; // 0x30
	float ShadowNearZ; // 0x34
	float ShadowFarZ; // 0x38
};

class StaticPhysDefClass : public PhysDefClass {
public:
	bool IsNonOccluder; // 0x24
};

class StaticAnimPhysDefClass : public StaticPhysDefClass {
public:
	bool unksapd1; // 0x28
	AnimCollisionManagerDefClass AnimCollision; // 0x2C
	ProjectorManagerDefClass Projector; // 0x38
	bool ShadowDynamicObjs; // 0x60
	bool ShadowIsAdditive; // 0x61
	bool ShadowIgnoresZRotation; // 0x62
	float ShadowNearZ; // 0x64
	float ShadowFarZ; // 0x68
	float ShadowIntensity; // 0x6C
	bool unksapd2; // 0x70
};

class AccessiblePhysDefClass : public StaticAnimPhysDefClass {
public:
	int LockCode; // 0x74
};

class BuildingAggregateDefClass : public StaticAnimPhysDefClass {
public:
	int AnimLogicMode; // 0x74
	bool IsMCT; // 0x78
	int Frame0[9]; // 0x7C
	int Frame1[9]; // 0xA0
	bool AnimationEnabled[9]; // 0xC4
};

class DamageableStaticPhysDefClass : public StaticAnimPhysDefClass {
public:
	unsigned long KilledExplosion; // 0x74
	int LiveLoopStart; // 0x78
	int LiveLoopEnd; // 0x7C
	int LiveTwitchStart; // 0x80
	int LiveTwitchEnd; // 0x84
	int DeathTransitionStart; // 0x88
	int DeathTransitionEnd; // 0x8C
	int DeathLoopStart; // 0x90
	int DeathLoopEnd; // 0x94
	int DeathTwitchStart; // 0x98
	int DeathTwitchEnd; // 0x9C
	bool PlayTwitchesToCompletion; // 0xA0
	DefenseObjectDefClass DefenseDef; // 0xA4
};

class DoorPhysDefClass : public AccessiblePhysDefClass {
public:
	OBBoxClass TriggerZone1; // 0x78
	OBBoxClass TriggerZone2; // 0xB4
	float CloseDelay; // 0xF0
	unsigned long OpenSoundID; // 0xF4
	unsigned long CloseSoundID; // 0xF8
	unsigned long UnlockSoundID; // 0xFC
	unsigned long AccessDeniedID; // 0x100
	bool DoorOpensForVehicles; // 0x104
};

class ElevatorPhysDefClass : public AccessiblePhysDefClass {
public:
	OBBoxClass Zones[4]; // 0x78
	float unk; // 0x168
};

class RenderObjClass : public RefCountClass, public PersistClass, public MultiListObjectClass {
public:
	virtual ~RenderObjClass();
	virtual void pure_virtual1();
	virtual unsigned long Class_ID();
	virtual char *Get_Name(); // 0x10
	virtual void Set_Name(const char *Name);
	virtual char *Get_Base_Model_Name();
	virtual void Set_Base_Model_Name();
	virtual int Get_Num_Polys();
	virtual void pure_virtual2();
	virtual void Special_Render(SpecialRenderInfoClass &);
	virtual void On_Frame_Update();
	virtual void Restart();
	virtual void Add(SceneClass *);
	virtual void Remove();
	virtual SceneClass *Get_Scene();
	virtual SceneClass *Peek_Scene();
	virtual void Set_Container(RenderObjClass *);
	virtual RenderObjClass *Get_Container();
	virtual void Validate_Transform();
	virtual void Set_Transform(Matrix3D  const&);
	virtual void Set_Position(Vector3  const&);
	virtual void Notify_Added(SceneClass *);
	virtual void Notify_Removed(SceneClass *);
	virtual int Get_Num_Sub_Objects();
	virtual RenderObjClass *Get_Sub_Object(int);
	virtual void Add_Sub_Object(RenderObjClass *);
	virtual void Remove_Sub_Object(RenderObjClass *);
	virtual void Get_Sub_Object_By_Name(char  const*);
	virtual int Get_Num_Sub_Objects_On_Bone(int);
	virtual void Get_Sub_Object_On_Bone(int, int);
	virtual int Get_Sub_Object_Bone_Index(RenderObjClass *);
	virtual void Add_Sub_Object_To_Bone(RenderObjClass*,int);
	virtual void Add_Sub_Object_To_Bone(RenderObjClass*,char  const*);
	virtual void Remove_Sub_Objects_From_Bone(char  const*);
	virtual void Update_Sub_Object_Transforms(void);
	int State; // 0x18
	Matrix3D Transform; // 0x1C
	SphereClass BoundSphere; // 0x4C
	AABoxClass BoundBox; // 0x5C
	float NativeScreenSize; // 0x74
	bool unkro; // 0x78
	SceneClass *Scene; // 0x7C
	RenderObjClass *Container; // 0x80
	void *UserData; // 0x84
	char *Model; // 0x88
	StringClass Prefix; // 0x8C
	int unkro3; // 0x90
	int unkro4; // 0x94
};

class PathNodeClass {
public:
};
class PathObjectClass {
public:
};
class PathSolveClass : public RefCountClass, public PostLoadableClass {
public:
	struct PathDataStruct {
	};
	~PathSolveClass();
	void On_Post_Load();
	Vector3 StartPos; // 0x10
	Vector3 DestPos; // 0x1C
	int State; // 0x28
	float Priority; // 0x2C
	int BirthTime; // 0x30
	int var34;
	int var38;
	DynamicVectorClass<PathNodeClass> NodeList; // 0x3C
	void *var54;
	int var58;
	int var5C;
	bool var60;
	int var64;
	DynamicVectorClass<PathSolveClass::PathDataStruct> PathDataList; // 0x68
	PathObjectClass PathObject; // 0x80
};

class PathClass : public RefCountClass {
public:
	int State; // 0x4
	int var8; // 0x8
	Vector3 StartPos; // 0xC
	Vector3 DestPos; // 0x18
	Vector3 NextPos; // 0x24
	float MovementRaduis; // 0x30
	Vector3 Velocity; // 0x34
};

class PathMgrClass {
public:
	static DynamicVectorClass<PathSolveClass *> &AvailablePathList;
};

class SceneClass : public RefCountClass {
public:
};

class WidgetUserClass {
public:
};

class PhysicsSceneClass : public SceneClass, public WidgetUserClass {
public:
	static PhysicsSceneClass *&TheScene;
	GenericMultiListIterator Get_Static_Object_Iterator() {
		GenericMultiListIterator Iterator;
		_asm {
			mov eax, 0x6220C0
			lea edx, Iterator
			push edx
			call eax
		}
		return Iterator;
	}
	//GenericMultiListIterator StaticObjectIterator; // 0x1F4
};

class CollisionMath {
public:
	static bool Overlap_Test(OBBoxClass &Box, const Vector3 &Position);
};

class CollisionEventClass {
public:
	PhysClass *AttachedObjPhys; // 0
};

#endif
