/*
	0.2.2
	  Fixed
	    Log date is a month behind
		Connection from FDS always output "(null)"

		5 Apr 2010
		Updated servserv Server parameter
		Updated XWIS server IP

	1.0.0
		New
			Automatic DNS update for servserv.westwood.com and WOL
*/

#include "xproxy.h"
#include "settings.h"
#include "manager.h"
#include "frame.h"
#include "dns.h"

bool g_CanExit = false;

xProxyBase::xProxyBase()
	: m_deletePending(false)
{
	g_ObjList.Add(this);
}
void xProxyBase::SetDeletePending()
{
	if (!this->m_deletePending)
		this->m_deletePending = true;
}
bool xProxyBase::IsDeletePending()
{
	return this->m_deletePending;
}

xProxyListener::xProxyListener()
{
#if VERC(1, 0, 0)
#elif VERC(0, 2, 0)
	aIPv4Address servserv("servserv.westwood.com", 4005);
	if (servserv.Address() != "255.255.255.255")
	{
		aSocketTCP wolList;
		if (wolList.Connect(servserv))
		{
			static const char *reqString = "verchk 32512 65556\n" \
						"lobcount 3072\n" \
						"whereto NoUser NoPass 3072 65573 0000000000000000000000\n" \
						"QUIT\n";
			wolList.Send(reqString, strlen(reqString));
			aString msg;
			for (int i = 1; i <= 300; i++)
			{
				char buf[1500];
				int len = wolList.Recv(buf, sizeof(buf) - 1, 1);
				if (len > 0 && *buf)
				{
					buf[len] = '\0';
					msg += buf;
					if (strstr(buf, ": 607"))
					{
						Log("WOL servers list received.");
						break;
					}
				}
				Sleep(1);
			}

			/*
				: 605 u :xwis.net 4003 '0:XWIS' -8 36.1083 -115.0582
				: 605 u :xwis.net 5000 'Live chat server' -8 36.1083 -115.0582
				: 608 u :serv1.renegadeladder.com 4850 'Gameres Server' -8 36.1083 -115.0582
				: 609 u :serv1.renegadeladder.com 3845 'Ladder server' -8 36.1083 -115.0582
				: 612 u :mangler1.westwood.com 4321 'Port Mangler' -8 36.1083 -115.0582
				: 612 u :renchat4.westwood.com 4321 'Port Mangler' -8 36.1083 -115.0582
				: 612 u :xwis.net 4321 'Port Mangler' -8 36.1083 -115.0582
				: 615 u :159.153.160.1 0 'Korea Ping server' -8 36.1083 -115.0582
				: 615 u :159.153.176.3 0 'UK Ping server' -8 36.1083 -115.0582
				: 615 u :159.153.192.10 0 'US West Ping server' -8 36.1083 -115.0582
				: 615 u :159.153.224.10 0 'US East Ping server' -8 36.1083 -115.0582
				: 615 u :203.166.10.69 0 'Australia Ping server' -8 36.1083 -115.0582
				: 615 u :210.174.186.252 0 'Japan Ping server' -8 36.1083 -115.0582
				: 615 u :211.72.252.17 0 'Taiwan Ping server' -8 36.1083 -115.0582
				: 615 u :ra2chat.westwood.com 0 'WW Ping server' -8 36.1083 -115.0582
			*/

			aToken lines(msg.GetString());
			for (int i = 1; i <= lines.numtok('\n'); i++)
			{
				if (lines.gettok(i, '\n').gettok(2,' ').ToLong() == 605 && (lines.gettok(i, '\n').gettok(6, ' ').GetData().Contain(',') || lines.gettok(i, '\n').gettok(6, ' ').GetData().Contain(':')))
				{
					aSocketTCP *port = new aSocketTCP(aSOCKET_NONBLOCKING);
					aIPv4Address listenData;
					listenData.Address("0.0.0.0");
					listenData.Port((unsigned short)lines.gettok(i, '\n').gettok(5, ' ').ToLong());
					if (!port->Listen(listenData))
					{
						Log("Error: Unable to bind to port %d; Error: %d", lines.gettok(i, '\n').gettok(5, ' ').ToLong(), port->GetError());
						delete port;
					}
					else
						this->m_bindList.Add(port);
				}
			}
			Log("Ready to accept FDS connections.");
		}
		else
			Log("Unable to connect to servserv.westwood.com; Error: %d", wolList.GetError());
	}
	else
		Log("Error: Unable to resolve servserv.westwood.com");
#else
	WSADATA wsaData;
	WSAStartup(MAKEWORD(2, 2), &wsaData);

	hostent *host = gethostbyname("servserv.westwood.com");

	WSACleanup();

	if (host)
	{
		char servservIP[16];
		sockaddr_in addr;
		memcpy(&addr.sin_addr.s_addr, host->h_addr_list[0], host->h_length);
		if (host->h_length > 0)
			strncpy(servservIP, inet_ntoa(addr.sin_addr), 15);
		aSocketTCP wolList;
		aIPv4Address wolListAddr(servservIP, 4005);
		if (wolList.Connect(wolListAddr))
		{
			static const char *reqString = "verchk 32512 65556\n" \
						"lobcount 3072\n" \
						"whereto NoUser NoPass 3072 65573 0000000000000000000000\n" \
						"QUIT\n";
			wolList.Send(reqString, strlen(reqString));

			aString msg;
			for (int i = 1; i <= 300; i++)
			{
				char buf[1500];
				int len = wolList.Recv(buf, sizeof(buf) - 1, 1);
				if (len > 0 && *buf)
				{
					buf[len] = '\0';
					msg += buf;
					if (strstr(buf, "607 UserName :goodbye"))
					{
						Log("WOL servers list received.");
						break;
					}
				}
				Sleep(1);
			}

			aToken lines(msg.GetString());
			for (int i = 1; i <= lines.numtok('\n'); i++)
			{
				if (lines.gettok(i, '\n').gettok(2,' ').ToLong() == 605 && lines.gettok(i, '\n').gettok(6, ' ').GetData().Contain(','))
				{
					aSocketTCP *port = new aSocketTCP(aSOCKET_NONBLOCKING);
					aIPv4Address listenData;
					listenData.Address("0.0.0.0");
					listenData.Port((unsigned short)lines.gettok(i, '\n').gettok(5, ' ').ToLong());
					if (!port->Listen(listenData))
					{
						Log("Error: Unable to bind to port %d; Error: %d", lines.gettok(i, '\n').gettok(5, ' ').ToLong(), port->GetError());
						delete port;
					}
					else
						this->m_bindList.Add(port);
				}
			}
			Log("Ready to accept FDS connections.");
		}
		else
			Log("Unable to connect to servserv.westwood.com; Error: %d\n", wolList.GetError());
	}
	else
		Log("Error: Unable to resolve servserv.westwood.com");
#endif
}
void xProxyListener::Init()
{
	aVector<aDnsResponse *> ans;

	aDnsResult *res = xProxyManager::m_dns->Query("servserv.westwood.com", DNS_TYPE_A, true);
	res->GetResults(&ans, DNS_TYPE_A);

	if (ans.Count() > 0)
	{
		Log("Resolved servserv.westwood.com to: %s", ans[0]->data.GetString());

		aIPv4Address addr(ans[0]->data.GetString(), 4005);
		aSocketTCP wolList;
		if (wolList.Connect(addr))
		{
			static const char *reqString = "verchk 32512 65556\n" \
					"lobcount 3072\n" \
					"whereto NoUser NoPass 3072 65573 0000000000000000000000\n" \
					"QUIT\n";
		wolList.Send(reqString, strlen(reqString));
		aString msg;

		unsigned long start = GetTickCount();
		while ((GetTickCount() - start) < 5000)
		{
			char buf[1500];
			int len = wolList.Recv(buf, sizeof(buf) - 1, 1);
			if (len > 0 && *buf)
			{
				buf[len] = '\0';
				msg += buf;
				if (strstr(buf, ": 607"))
				{
					Log("WOL servers list received.");
					break;
				}
			}
			Sleep(1);
		}

#ifdef __DEV__
		Log(msg.GetString());
#endif

		/*
			: 605 u :xwis.net 4003 '0:XWIS' -8 36.1083 -115.0582
			: 605 u :xwis.net 5000 'Live chat server' -8 36.1083 -115.0582
			: 608 u :serv1.renegadeladder.com 4850 'Gameres Server' -8 36.1083 -115.0582
			: 609 u :serv1.renegadeladder.com 3845 'Ladder server' -8 36.1083 -115.0582
			: 612 u :mangler1.westwood.com 4321 'Port Mangler' -8 36.1083 -115.0582
			: 612 u :renchat4.westwood.com 4321 'Port Mangler' -8 36.1083 -115.0582
			: 612 u :xwis.net 4321 'Port Mangler' -8 36.1083 -115.0582
			: 615 u :159.153.160.1 0 'Korea Ping server' -8 36.1083 -115.0582
			: 615 u :159.153.176.3 0 'UK Ping server' -8 36.1083 -115.0582
			: 615 u :159.153.192.10 0 'US West Ping server' -8 36.1083 -115.0582
			: 615 u :159.153.224.10 0 'US East Ping server' -8 36.1083 -115.0582
			: 615 u :203.166.10.69 0 'Australia Ping server' -8 36.1083 -115.0582
			: 615 u :210.174.186.252 0 'Japan Ping server' -8 36.1083 -115.0582
			: 615 u :211.72.252.17 0 'Taiwan Ping server' -8 36.1083 -115.0582
			: 615 u :ra2chat.westwood.com 0 'WW Ping server' -8 36.1083 -115.0582
		*/

		aToken lines(msg.GetString());
		for (int i = 1; i <= lines.numtok('\n'); i++)
		{
			aToken line = lines.gettok(i, '\n');
			if (line.gettok(2,' ').ToLong() == 605 && (line.gettok(6, ' ').GetData().Contain(',') || line.gettok(6, ' ').GetData().Contain(':')))
			{
				aSocketTCP *port = new aSocketTCP(aSOCKET_NONBLOCKING);
				aIPv4Address listenData;
				listenData.Address("0.0.0.0");
				listenData.Port((unsigned short)line.gettok(5, ' ').ToLong());
				if (!port->Listen(listenData))
				{
					Log("Error: Unable to bind to port %d; Error: %d", line.gettok(5, ' ').ToLong(), port->GetError());
					delete port;
				}
				else
				{
					Log("Listening on port %hu.", port->GetPort());
					this->m_bindList.Add(port);
				}

				res = xProxyManager::m_dns->Query(line.gettok(4, ' ').GetData().Mid(1));
				res->GetResults(&ans, DNS_TYPE_A);

				if (ans.Count() > 0)
				{
					Log("Resolved server \"%s\" to IP %s", line.gettok(4, ' ').GetData().Mid(1).GetString(), ans[0]->data.GetString());
					xProxyManager::m_settings->m_serverIP = line.gettok(4, ' ').GetData().Mid(1);
				}
				else
					Log("Unable to resolve server \"%s\". Please consider changing DNS settings in \"xProxy.cfg\".", line.gettok(4, ' ').GetData().Mid(1).GetString());
			}
		}
		Log("Ready to accept FDS connections.");
	}
	else
		Log("Unable to connect to servserv.westwood.com; Error: %d", wolList.GetError());
	}
	else
		Log("[Warning] Unable to resolve servserv.westwood.com from DNS server \"%s\".", xProxyManager::m_settings->m_dnsIP.GetString());
}
void xProxyListener::Delete()
{
	for (unsigned int i = 0; i < this->m_bindList.Count(); i++)
		delete this->m_bindList[i];
	this->m_bindList.Clear();
}
void xProxyListener::Think()
{
	for (unsigned int i = 0; i < this->m_bindList.Count(); i++)
	{
		aSocketTCP *newClient = this->m_bindList[i]->Accept(aSOCKET_NONBLOCKING);
		if (newClient)
		{
			bool allow = false;
			for (unsigned int j = 0; j < xProxyManager::m_settings->m_allowFdsIP.Count(); j++)
			{
				if (newClient->GetAddress().Matches(xProxyManager::m_settings->m_allowFdsIP[j]))
				{
					allow = true;
					break;
				}
			}
			if (allow)
			{
				Log("Incoming connection on port %d from %s:%u", this->m_bindList[i]->GetPort(), newClient->GetIPAddress().GetString(), newClient->GetPort());
				new xProxyConnection(newClient, this->m_bindList[i]->GetPort());
			}
			else
			{
				Log("Unauthorized connection on port %hu from %s:%hu", this->m_bindList[i]->GetPort(), newClient->GetIPAddress().GetString(), newClient->GetPort());
				newClient->Close();
			}
		}
	}
}

xProxyConnection::xProxyConnection(aSocketTCP *client, unsigned short serverPort)
	: m_state(0),
	  m_clientSocket(client),
	  m_wolSocket(NULL),
	  m_serverPort(serverPort),
	  m_reconnectCounter(-999.0f),
	  m_timeoutCounter(WOL_TIMEOUT),
	  m_waitingStartGameEvent(false),
	  m_gameStarted(false)
{
}
void xProxyConnection::Delete()
{
	xpDELETE(this->m_clientSocket);
	xpDELETE(this->m_wolSocket);
}
void xProxyConnection::Think()
{
	// Client connection
	char data[1500];
	memset(&data, 0, sizeof(data));
	int len = this->m_clientSocket->Recv(data, sizeof(data) - 1, 1);

	// Socket contains error
	if (len == -1)
	{
		switch (this->m_clientSocket->GetError())
		{
			case 10045: // Operation not supported
			case 10052: // Network dropped connection on reset
			case 10053: // Software caused connection abort
			case 10054: // Connection reset by peer
			case 10060: // Connection timed out
			case 10065: // No route to host
				if (this->m_nick.IsEmpty())
					Log("Connection from %s:%d closed. Disconnecting WOL...", this->m_clientSocket->GetAddress().GetString(), this->m_clientSocket->GetPort());
				else
					Log("[%s] FDS disconnected. Disconnecting WOL...", this->m_nick.GetString());
				if (this->m_wolSocket)
					this->m_wolSocket->Send("QUIT\n", 5);
				this->SetDeletePending();
				break;
		}
	}

	// Gracefully closed the connection
	else if (len == 0)
	{
		if (this->m_nick.IsEmpty())
			Log("Connection from %s:%d closed. Disconnecting WOL...", this->m_clientSocket->GetAddress().GetString(), this->m_clientSocket->GetPort());
		else
			Log("[%s] FDS disconnected. Disconnecting WOL...", this->m_nick.GetString());
		this->SetDeletePending();
	}

	// Have data!
	else if (len > 0 && *data)
	{
		// Packet data buffer
		aString packet = data;
		memset(&data, 0, sizeof(data));

		// Continue to check until the socket read buffer becomes empty
		while (this->m_clientSocket->Recv(data, sizeof(data) - 1, 1) > 0 && *data)
		{
			packet += data;
			memset(&data, 0, sizeof(data));
		}

		// Filtered output
		aString fltredMsg;

		aToken token(packet.GetString());
		for (int i = 1; i <= token.numtok('\n'); i++)
		{
			aString line = token.gettok(i, '\n').GetData();
			if (!line.IsEmpty() && this->ProcessClient(line))
			{
				fltredMsg += line;
				fltredMsg += '\n';
#ifdef __DEV__
				Log("[%s;OUT]: %s", this->m_nick.GetString(), line.GetString());
#endif
			}
		}

		// Check for WOL connection
		if (this->m_wolSocket == NULL && this->m_reconnectCounter == -999.0f)
		{
			if (!this->m_nick.IsEmpty() && !this->m_password.IsEmpty() && !this->m_serial.IsEmpty())
			{
				bool nickConnected = false;

				// Nickname duplicate check
				// Let FDS to determine the timeout to prevent massive spam
				if (xProxyManager::m_settings->m_blockDuplicate)
				{
					for (unsigned int i = 0; i < g_ObjList.Count(); i++)
					{
						if (!g_ObjList[i]->IsDeletePending() && g_ObjList[i] != this && g_ObjList[i]->AsConnection())
						{
							if (g_ObjList[i]->AsConnection()->m_nick == this->m_nick)
							{
								Log("[Warning] Duplicate instance of \"%s\" detected.", this->m_nick.GetString());
								nickConnected = true;
								break;
							}
						}
					}
				}

				if (!nickConnected)
				{
					this->m_wolSocket = new aSocketTCP(aSOCKET_NONBLOCKING);
					this->Create(NULL);
					this->Run();
				}
			}
		}

		if (this->m_wolSocket && this->m_wolSocket->IsConnected())
			this->m_wolSocket->Send(fltredMsg.GetString(), fltredMsg.GetLength());

		//Log("OUTGOING: %s", fltredMsg.Trim("\n", ncTRIM_END).GetString());
	}

	// STARTG event to prevent FDS crash
	if (this->m_waitingStartGameEvent)
	{
		this->m_startGameCounter -= xProxyFrameManager::GetFrameTime();
		if (this->m_startGameCounter < 0.0f)
		{
			Log("[%s] Timeout for waiting STARTG event from WOL. Sending fake event...", this->m_nick.GetString());

			aString fakeSTARTG;
			fakeSTARTG.Printf(":%s!u@h STARTG u :%s %s :1 %ld\n",
				this->m_nick.GetString(),
				this->m_nick.GetString(),
				this->m_ip.GetString(),
				aDateTime::Now().GetTicks()
			);
			this->m_clientSocket->Send(fakeSTARTG.GetString(), fakeSTARTG.GetLength());
			this->m_waitingStartGameEvent = false;
		}
	}

	if (this->m_wolSocket)
	{
		switch (this->m_state)
		{
			case -1: // Failed to connect
				Log("[%s] Unable to connect to WOL; Error: %d; Reconnecting in %.0f second(s)...", this->m_nick.GetString(), this->m_wolSocket->GetError(), WOL_RECONNECT_TIME);
				xpDELETE(this->m_wolSocket);
				this->m_state = 0;
				this->m_timeoutCounter = 99999.0f;
				break;

			case 1: // Connected
				this->m_state++;

				// Send log on information
				aString data;
				data.Printf(
					"CVERS %d %d\n" \
					"PASS supersecret\n" \
					"NICK %s\n" \
					"apgar %s 0\n" \
					"SERIAL %s\n" \
					"USER UserName HostName irc.westwood.com :RealName\n" \
					"verchk 32512 720916\n" \
					"SETOPT 17,33\n",
					this->m_cvers[0],
					this->m_cvers[1],
					this->m_nick.GetString(),
					this->m_password.GetString(),
					this->m_serial.GetString(),
					this->m_nick.GetString()
				);
				for (unsigned int i = 0; i < this->m_wolSendQueue.Count(); i++)
				{
					data += this->m_wolSendQueue[i];
					data += "\n";
				}
				this->m_wolSendQueue.Clear();

				this->m_wolSocket->Send(data.GetString(), data.GetLength());
				this->m_timeoutCounter = WOL_TIMEOUT;
				Log("[%s] WOL connection established.", this->m_nick.GetString());
				break;
		}
	}

	if (this->m_wolSocket)
	{
		// Built-in keep-alive because WOL didn't send PING to FDS
		this->m_sendKeepAliveCounter -= xProxyFrameManager::GetFrameTime();
		if (this->m_sendKeepAliveCounter < 0.0f)
		{
			this->m_wolSocket->Send("TIME\n", 5);
			this->m_sendKeepAliveCounter = WOL_KEEPALIVE_TIME;
		}

		// Timeout counters
		this->m_timeoutCounter -= xProxyFrameManager::GetFrameTime();
		if (this->m_timeoutCounter < 0.0f && this->m_wolSocket->IsConnected())
		{
			if (!this->IsDeletePending())
			{
				Log("[%s] No response from WOL from the last %.0f second(s). Closing connection and reconnecting in %.0f second(s).",
					this->m_nick.GetString(),
					WOL_TIMEOUT,
					WOL_RECONNECT_TIME
				);
				xpDELETE(this->m_wolSocket);
				this->m_reconnectCounter = WOL_RECONNECT_TIME;
			}
		}
		else
		{
			memset(&data, 0, sizeof(data));
			len = this->m_wolSocket->Recv(data, sizeof(data), 1);

			// Socket contains error
			if (len == -1)
			{
				int error = this->m_wolSocket->GetError();
				switch (error)
				{
					case 10045: // Operation not supported
					case 10052: // Network dropped connection on reset
					case 10053: // Software caused connection abort
					case 10054: // Connection reset by peer
					case 10060: // Connection timed out
					case 10065: // No route to host
						Log("[%s] WOL disconnected; Error: %d; Reconnecting in %.0f second(s)", this->m_nick.GetString(), error, WOL_RECONNECT_TIME);
						xpDELETE(this->m_wolSocket);
						this->m_timeoutCounter = 99999.0f;
						break;
				}
				xpDELETE(this->m_wolSocket);
				this->m_reconnectCounter = WOL_RECONNECT_TIME;
			}

			// WOL shutdown the connection gracefully
			else if (len == 0)
			{
				Log("[%s] WOL disconnected. Reconnecting in %.0f second(s)...", this->m_nick.GetString(), WOL_RECONNECT_TIME);
				xpDELETE(this->m_wolSocket);
				this->m_reconnectCounter = WOL_RECONNECT_TIME;
				this->m_timeoutCounter = 99999.0f;
			}

			// Have data!
			else if (len > 0 && *data)
			{
				// Reset timeout counter
				this->m_timeoutCounter = WOL_TIMEOUT;

				aString packet = data;
				memset(&data, 0, sizeof(data));

				// Continue to check until the socket read buffer becomes empty
				while (this->m_clientSocket->Recv(data, sizeof(data) - 1, 1) > 0 && *data)
				{
					packet += data;
					memset(&data, 0, sizeof(data));
				}

				// Filtered output
				aString fltredMsg;

				// Process WOL messages
				aToken token(packet);
				for (int i = 1; i <= token.numtok('\n'); i++)
				{
					aString line = token.gettok(i, '\n').GetData();
					if (!line.IsEmpty() && this->ProcessWOL(line))
					{
						fltredMsg += line;
						fltredMsg += '\n';
#ifdef __DEV__
						Log("[%s;IN]: %s", this->m_nick.GetString(), line.GetString());
#endif
					}
				}

				if (!fltredMsg.IsEmpty())
				{
					// Send to client
					this->m_clientSocket->Send(fltredMsg.GetString(), fltredMsg.GetLength());
				}
			}
		}
	}
	else
	{
		if (this->m_reconnectCounter > -999.0f)
		{
			if (this->m_reconnectCounter >= 0.0f)
				this->m_reconnectCounter -= xProxyFrameManager::GetFrameTime();

			if (this->m_reconnectCounter < 0.0f)
			{
				if (!this->m_nick.IsEmpty() && !this->m_password.IsEmpty() && !this->m_serial.IsEmpty())
				{
					Log("[%s] Attempting to reconnect to WOL...", this->m_nick.GetString());
					this->m_wolSendQueue.Add(aString::Format("JOINGAME #%s 2 128 12 3 1 0 0", this->m_nick.GetString()));
					this->m_wolSocket = new aSocketTCP(aSOCKET_NONBLOCKING);
					this->Create(NULL);
					this->Run();
				}
			}
		}
	}
}
bool xProxyConnection::ProcessClient(aString &msg)
{
	aToken token(msg);
	if (msg.Left(5) == "CVERS")
	{
		this->m_cvers[0] = ((aString)token.gettok(2, ' ').GetData()).ToLong();
		this->m_cvers[1] = ((aString)token.gettok(3, ' ').GetData()).ToLong();
	}
	else if (msg.Left(4) == "NICK")
	{
		this->m_nick = token.gettok(2, ' ').GetData().GetString();
		this->m_nick = this->m_nick.Trim("\r\n\t ", aTRIM_END);
	}
	else if (msg.Left(5) == "APGAR")
		this->m_password = token.gettok(2, ' ').GetData();
	else if (msg.Left(6) == "SERIAL")
		this->m_serial = token.gettok(2, ' ').GetData();
	else if (msg.Left(5) == "TOPIC")
	{
		int nameLen = *token.gettok(4, ' ').GetData().GetString() - 32;
		if (nameLen < 0)
		{
			Log("Error: [1] Invalid TOPIC detected from %s -> %s\n", this->m_nick.GetString(), msg.GetString());
			return false;
		}

		int mapLen = *(token.gettok(4, token.numtok(' '), ' ').GetData().GetString() + 1 + nameLen) - 32;
		if (mapLen < 0)
		{
			Log("Error: [2] Invalid TOPIC detected from %s -> %s\n", this->m_nick.GetString(), msg.GetString());
			return false;
		}

		this->m_map = token.gettok(4, token.numtok(' '), ' ').GetData().GetString() + nameLen + 2;
		this->m_map.Resize(mapLen);
		if (this->m_map.Find('.', true) != -1)
			this->m_map.Resize(this->m_map.Find('.', true));

		if (xProxyManager::m_settings->m_fakePing)
			msg = msg.Replace((msg.Right(15).Left(1) == "|") ? msg.Right(31).Left(17) : msg.Right(17), "0000000000000000");
	}
	else if (msg.Left(6) == "STARTG")
	{
		if (this->m_gameStarted)
			Log("[%s] Map change: %s", this->m_nick.GetString(), this->m_map.GetString());
		else
		{
			Log("[%s] Game started: %s", this->m_nick.GetString(), this->m_map.GetString());
			this->m_gameStarted = true;
		}

		// Fake STARTG
		if (this->m_wolSocket && this->m_gameStarted)
		{
			this->m_waitingStartGameEvent = true;
			this->m_startGameCounter = WOL_STARTGAME_TIMEOUT;
		}
		else
		{
			Log("WOL is not connected or logged on. Sending fake STARTG...");

			aString fakeSTARTG;
			fakeSTARTG.Printf(":%s!u@h STARTG u :%s %s :1 %ld\n",
				this->m_nick.GetString(),
				this->m_nick.GetString(),
				this->m_ip.GetString(),
				aDateTime::Now().GetTicks()
			);
			this->m_clientSocket->Send(fakeSTARTG.GetString(), fakeSTARTG.GetLength());
		}
	}
	else if (msg.Left(8) == "JOINGAME")
	{
		if (token.numtok(' ') == 10)
		{
			this->m_gamePassword = token.gettok(10, ' ').GetData().GetString();
			this->m_gamePassword.Resize(this->m_gamePassword.GetLength() - 1);
		}
	}
	return true;
}
bool xProxyConnection::ProcessWOL(aString& msg)
{
	aToken token(msg.GetString());
	aString cmd = token.gettok(2, ' ').GetData();
	aString user = (token.gettok(1, '!').GetData().GetString() + 1);

	// Block commands from ignored user
	for (unsigned int i = 0; i < xProxyManager::m_settings->m_ignoreUsers.Count(); i++)
	{
		if (xProxyManager::m_settings->m_ignoreUsers[i] == user)
		{
			Log("[%s] Ignored command from %s", this->m_nick.GetString(), user.GetString());
			return false;
		}
	}

	// Output commands
	for (int i = 0; i < sizeof(Wol_log_cmds) / 4; i++)
	{
		if (cmd == Wol_log_cmds[i] && this->m_nick == user)
		{
			Log("[%s] IN from %s - %s", this->m_nick.GetString(), user.GetString(), token.gettok(2, token.numtok(' ') - 1, ' ').GetData().GetString());
			break;
		}
	}

	// Block invalid commands
	for (int i = 0; i < sizeof(Wol_ignore_cmds) / 4; i++)
	{
		if (cmd == Wol_ignore_cmds[i])
			return false;
	}

#if VERC(0, 2, 1)
	// Crash if FDS loaded maps already
	if (this->m_gameStarted && msg.Contain(":closing link:"))
		return false;
#endif

	if (cmd == "372")
	{
		if (msg == ": 372 u :- Error: invalid password")
		{
			Log("[%s] WOL reported invalid password. Disconnecting...", this->m_nick.GetString());
			this->m_clientSocket->Send("ERROR :closing link:(Password needed for that nickname.)", 56);
			this->SetDeletePending();
		}
		else if (msg.Left(41) == ": 372 u :- Your serial number is invalid.")
		{
			Log("[%s] WOL reported invalid serial. Disconnecting...", this->m_nick.GetString());
			this->m_clientSocket->Send("ERROR :Closing Link:(Your Serial# is not in the database!)", 58);
			this->SetDeletePending();
		}
	}

	else if (cmd == "379")
		Log("[%s] Logged on successfully.", this->m_nick.GetString());

	else if (cmd == "STARTG")
		this->m_waitingStartGameEvent = false;

	else if (cmd == "USERIP")
	{
		if (this->m_ip.IsEmpty())
			this->m_ip = ((aString)token.gettok(4, ' ').GetData()).Trim("\r\n\t ", aTRIM_END);
	}
	return true;
}
int xProxyConnection::Entry(void *)
{
	int ret = 0;
	if (this->m_wolSocket)
	{
		aIPv4Address wol(xProxyManager::m_settings->m_serverIP, this->m_serverPort);
		ret = (this->m_wolSocket->Connect(wol) ? 1 : -1);
	}
	return ret;
}
void xProxyConnection::OnExit(int ExitCode)
{
	this->m_state = ExitCode;
}

int appExit(DWORD type)
{
	switch (type)
	{
		case CTRL_C_EVENT:
		case CTRL_CLOSE_EVENT:
		case CTRL_LOGOFF_EVENT:
		case CTRL_SHUTDOWN_EVENT:
			g_CanExit = true;
			break;
	}
	return 1;
}

int main(int argc, char *argv[])
{
	SetConsoleCtrlHandler((PHANDLER_ROUTINE)appExit, TRUE);

	sprintf(_version, "%d.%d.%d", __VER_MAJOR, __VER_MINOR, __VER_RELEASE);

	char title[64];
	sprintf(title, "xProxy %s", _version);
#ifdef __DEV__
	strcat(title, " DEV");
#endif
	SetConsoleTitle(title);

	COORD size;
	size.X = 80;
	size.Y = SHRT_MAX - 1;
	SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE), size);

	SetUnhandledExceptionFilter(ExceptionHandler);

	xProxyManager::m_dns = new xProxyDns;
	xProxyManager::m_settings = new xProxySettings;

	// Settings have to be loaded first
	Log("xProxy v%d.%d.%d started - Built on %s at %s", __VER_MAJOR, __VER_MINOR, __VER_RELEASE, __DATE__, __TIME__);

	xProxyManager::m_settings->ShowSettings();

	(xProxyManager::m_Listener = new xProxyListener)->Init();
	xProxyManager::m_frame = new xProxyFrameManager;
	g_CanExit = false;

	while (!g_CanExit)
	{
		for (unsigned int i = 0; i < g_ObjList.Count(); i++)
		{
			if (g_ObjList[i]->IsDeletePending())
			{
				g_ObjList[i]->Delete();
				delete g_ObjList[i];
				g_ObjList.Delete(i);
				i--;
			}
			else
				g_ObjList[i]->Think();
		}
		Sleep(1);
	}

#ifdef __DEV__
	Log("Initializing shutdown procedures...");
#endif

	for (unsigned int i = 0; i < g_ObjList.Count(); i++)
	{
		g_ObjList[i]->Delete();
		delete g_ObjList[i];
	}
	g_ObjList.Clear();

#ifdef __DEV__
	m_dumpMemoryReport("xProxy.memreport.log");
#endif
	return EXIT_SUCCESS;
}

void Log(const char *msg, ...)
{
	g_CriticalSection.Enter();
	va_list args;
	va_start(args, msg);
	int len = _vscprintf(msg, args);
	char *fmtMsg = new char[len + 1];
	vsprintf(fmtMsg, msg, args);
	va_end(args);
	aDateTime now = aDateTime::Now();

	if (xProxyManager::m_settings->m_writeLog)
	{
		aFile log("xProxy.log", "a");
		if (log.IsOpened())
		{
			log.Write(now.Format("[%d-%m-%Y %H:%M:%S] "));
			log.Write(fmtMsg, len);
			log.Write("\n", 1);
		}
	}

	printf("[%02d:%02d:%02d] %s\n",
		now.GetHour(),
		now.GetMinute(),
		now.GetSecond(),
		fmtMsg
	);
	delete [] fmtMsg;
	g_CriticalSection.Leave();
}

long __stdcall ExceptionHandler(EXCEPTION_POINTERS *lpExceptionInfo)
{
	// Create dir
	_mkdir("crashdump");

	// Generate crash dump filename
	aString filename;
	aDateTime now = aDateTime::Now();
	filename.Printf("crashdump\\dump_%u-%u-%u_%02u;%02u;%02u.dmp", now.GetDay(), now.GetMonth(), now.GetYear(), now.GetHour(), now.GetMinute(), now.GetSecond());

	// Create file
	HANDLE dumpFile = CreateFile(filename.GetString(), GENERIC_READ | GENERIC_WRITE, FILE_SHARE_WRITE | FILE_SHARE_READ, 0, CREATE_ALWAYS, 0, 0);

	// Initial needed parameters
	MINIDUMP_EXCEPTION_INFORMATION expParam;
	expParam.ThreadId = GetCurrentThreadId();
	expParam.ExceptionPointers = lpExceptionInfo;
	expParam.ClientPointers = true;

	// Set dump options
	MINIDUMP_TYPE dumpOption = (MINIDUMP_TYPE)(MiniDumpWithDataSegs | MiniDumpWithIndirectlyReferencedMemory);

	// Write to file
	MiniDumpWriteDump(GetCurrentProcess(), GetCurrentProcessId(), dumpFile, dumpOption, &expParam, NULL, NULL);

	// Delete stuff
	CloseHandle(dumpFile);

	return EXCEPTION_EXECUTE_HANDLER;
}
