#ifndef __XPROXY_H
#define __XPROXY_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <direct.h>
#include <dbghelp.h>
#include <sys/stat.h>

// aLib
#include "aLib.h"
#include "aVector.h"
#include "aString.h"
#include "aToken.h"
#include "aThread.h"
#include "aSocket.h"
#include "aDns.h"
#include "aFile.h"
#include "aTreeConfig.h"
#include "aDateTime.h"

#include "verctrl.h"

#define CFG_RELOAD_TIME         60.0f
#define WOL_TIMEOUT             300.0f
#define WOL_RECONNECT_TIME      15.0f
#define WOL_STARTGAME_TIMEOUT   10.0f
#define WOL_KEEPALIVE_TIME      (WOL_TIMEOUT / 2.0f)

#define xpDELETE(x) if (x != NULL) { delete x; x = NULL; }

static const char *Wol_log_cmds[] = {
	"GAMEOPT",
	"JOIN",
	"JOINGAME",
	"KICK",
	"PAGE",
	"PART",
	"QUIT",
};

static const char *Wol_ignore_cmds[] = {
	"NOTICE",
	"PRIVMSG",
};

class xProxyBase;
class xProxySettings;
class xProxyListener;
class xProxyConnection;
class xProxyConnector;

static char _version[24];
static aCriticalSection g_CriticalSection;
extern bool g_CanExit;
static aVector<xProxyBase *> g_ObjList;

class xProxyBase {
	bool m_deletePending;
public:
	xProxyBase();
	virtual ~xProxyBase() { };
	virtual void Init() { };
	virtual void Delete() = 0;
	virtual void Think() { };
	virtual xProxyConnection* AsConnection() { return NULL; };
	void SetDeletePending();
	bool IsDeletePending();
};


class xProxyListener : public xProxyBase {
	aVector<aSocketTCP *> m_bindList;
public:
	xProxyListener();
	void Init();
	void Delete();
	void Think();
};

class xProxyConnection : public xProxyBase, public aThread {
	int            m_state;
	aSocketTCP*    m_clientSocket;
	aSocketTCP*    m_wolSocket;
	unsigned short m_serverPort;
	int            m_cvers[2];
	aString        m_nick;
	aString        m_password;
	aString        m_serial;
	aString        m_ip;
	aString        m_gamePassword;
	aString        m_map;
	aString        m_lastTopic;
	aStringArray   m_wolSendQueue;
	float          m_reconnectCounter;
	float          m_timeoutCounter;
	float          m_sendKeepAliveCounter;
	float          m_startGameCounter;
	bool           m_waitingStartGameEvent;
	bool           m_gameStarted;
public:
	xProxyConnection(aSocketTCP *client, unsigned short serverPort);
	void Delete();
	void Think();
	xProxyConnection* AsConnection() { return this; };

	// Process messages from FDS
	bool ProcessClient(aString &);

	// Process messages from WOL
	bool ProcessWOL(aString &);

	// Connect thread functions
	int Entry(void *);
	void OnExit(int ExitCode);
};

void Log(const char *msg, ...);
long __stdcall ExceptionHandler(struct _EXCEPTION_POINTERS *lpExceptionInfo);

#endif
