#include "General.h"
#include "MAPCHConsoleCommand.h"
#include "cScTextObj.h"
#include "CommandLineParser.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"

static int getClientIdByIdentifier(const char* clientIdentifier)
{
	assert(clientIdentifier);
	const cPlayer* player = Find_Player(atoi(clientIdentifier));
	int result;
	if (player)
		result = player->PlayerId;
	else
		result = -1;
	return result;
}

static bool isClientId(const int id)
{
	return id > 0 && id < 128 && Find_Player(id);
}

class CommandMAPCH :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "mapch"; 
	}
	const char* Get_Help() 
	{ 
		return "MAPCH <player> <map> - Check if a given client has a given map. Host only.";
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please enter a player ID.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid player ID.");
			}
			else
			{
				const char* File = arguments.getRemainingString();
				if(!File)
				{
					Console_Output("Please enter a file name to check.");
				}
				else
				{
		//			cScTextObj* TextObj = (cScTextObj*)operator new(sizeof(cScTextObj));
	//				TextObj = TextObj->Constructor();

					WideStringClass Netcode = StringClass::getFormattedString("j\n71\n%d\n%s\n", clientId, File);
					Send_Client_Text(Netcode, TEXT_MESSAGE_PRIVATE, true, -2, clientId, true, true);
				}
			}
		}
	}
};

class MAPCHCONSOLECOMMAND : public Plugin
{
public:
	MAPCHCONSOLECOMMAND()
	{
		ConsoleFunctionList.Add(new CommandMAPCH);
		Sort_Function_List();
		Verbose_Help_File();
	}
	~MAPCHCONSOLECOMMAND()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "mapch") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

MAPCHCONSOLECOMMAND mapchconsolecommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &mapchconsolecommand;
}