package BRenBot;

use POE;
use plugin;
use modules;

sub CHANNEL () { plugin::get_irc_channel()  };

our %additional_events =
(
	"destroyveh" => "destroyveh",
    "refund" => "refund",
    "spectate" => "spectate",
	"save" => "save",
	"bmute" => "bmute",
	"ballow" => "ballow",
	"zeropoints" => "zeropoints",
    "zeropointsMessage" => "zeropointsMessage"

);

our $plugin_name;
our %config;

sub destroyveh
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ( $args{arg} =~ m/^\!\S+\s(.+)$/i )
	{
		my ( $result, %player ) = plugin::getPlayerData ( $1 );
		if ( $result == 1 )
		{
			plugin::RenRemCMD ( "destroy_vehicle $player{id}" );
			plugin::RenRemCMD("ppage $player{id} Your vehicle was destroyed by request.");
		}
		else { doMsg("Error: $args{arg1} was not found ingame, or is not unique",$args{nicktype}, "A"); }
	}
	else
	{
        doMsg("Syntax: !destroyveh <player>",$args{nicktype}, "A");
	}
}

sub refund
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ($args{arg1} && $args{arg2}  && ($args{arg2} =~ m/^(-?\d+)$/ ))
	{
		my ( $result, %player ) = playerData::getPlayerData( $args{'arg1'} );
		if ( $result == 1 )
		{
			my $amount = $args{arg2};
			plugin::RenRemCMD ( "givecredits $player{id} $amount" );
			plugin::RenRemCMD("ppage $player{id} you have been giving $amount credits by $args{nick}.");
			plugin::ircmsg ( " $player{name} was refunded $amount credits by $args{nick}", A);
		}
		else 
		{
			doMsg("Error: $args{arg1} was not found ingame, or is not unique",$args{nicktype}, "A");
		}
	}
    else
    {
		doMsg("Syntax: !refund <player> <amount>",$args{nicktype}, "A");
	}
}


sub spectate
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ( $args{arg} =~ m/^\!\S+\s(.+)$/i )
	{
		my ( $result, %player ) = plugin::getPlayerData ( $1 );
		if ( $result == 1 )
		{
	        if ((modules::IsHalfMod($player{name}) || modules::IsFullMod($player{name}) || modules::IsAdmin($player{name}) ))
	        {
				plugin::RenRemCMD ( "spectate $player{id}" );
				plugin::ircmsg ( "spectate mode set for $player{name}", A);
            }
            else { plugin::ircmsg ( "Spectate can only be used on administators or permanent moderators", A); }
		}
		else { plugin::ircmsg ( "$1 was not found ingame, or is not unique", A); }
	}
	else
	{
		plugin::ircmsg ( "Usage: !spectate <modname>", A);
	}
}

sub save
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};

	my ( $result, %player ) = plugin::getPlayerData ( $args{nick} );
	if ( $result == 1 )
	{
		if ( $args{arg1} eq "turret" )
		{
		plugin::RenRemCMD ( "savecords $player{id} turret" );
		}
		elsif ( $args{arg1} eq "tower" )
		{
		plugin::RenRemCMD ( "savecords $player{id} tower" );
		}
		elsif ( $args{arg1} eq "gdiemp" )
		{
		plugin::RenRemCMD ( "savecords $player{id} gdiemp" );
		}
		elsif ( $args{arg1} eq "nodemp" )
		{
		plugin::RenRemCMD ( "savecords $player{id} nodemp" );
		}
    }
}

sub bmute
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ( $args{arg} =~ m/^\!\S+\s(.+)$/i )
	{
		my ( $result, %player ) = plugin::getPlayerData ( $1 );
		if ( $result == 1 )
		{
			plugin::RenRemCMD ( "beacon_disallow $player{id}" );
		}
		else 
		{ 
			doMsg(" Error: $args{arg1} was not found ingame, or is not unique",$args{nicktype}, "A"); 
		}
	}
	else
	{
		doMsg("Syntax: !bmute <player>",$args{nicktype}, "A");
	}
}

sub ballow
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ( $args{arg} =~ m/^\!\S+\s(.+)$/i )
	{
		my ( $result, %player ) = plugin::getPlayerData ( $1 );
		if ( $result == 1 )
		{
			plugin::RenRemCMD ( "beacon_allow $player{id}" );
		}
		else { doMsg(" Error: $args{arg1} was not found ingame, or is not unique",$args{nicktype}, "A"); }
	}
	else
	{
        doMsg("Syntax: !ballow <player>",$args{nicktype}, "A");
	}
}

sub VeteranMessage
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

	if ( $args{line} =~ m/^_VETERAN\s(.+)/i )
	{
		plugin::ircmsg ( "3[Veteran] $1", "A" );
	}
}

sub zeropointsMessage
{
    my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
    my %args = %{$args};

	if ( $args{line} =~ m/^_ZP\s(.+)/i )
	{
		plugin::ircmsg ( "3[Zeropoints] $1", "A" );
	}
}

sub zeropoints
{
	my ( $session, $heap, $args ) = @_[ SESSION, HEAP, ARG0 ];
	my $kernel = $_[KERNEL];
	my %args = %{$args};
    plugin::RenRemCMD ( "zp" );
}

sub doMsg
{
	my ( $msg, $nicktype, $chantype ) = ($_[0], $_[1], $_[2]);
	if ($nicktype == 1)
	{
		plugin::ircmsg ($msg, $chantype );
	}
	else
	{
		plugin::RenRemCMD("msg ".$msg);
	}
}

sub start
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};
}

sub stop
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};
}

sub command
{
	my ( $kernel, $session, $heap, $args ) = @_[ KERNEL, SESSION, HEAP, ARG0 ];
	my %args = %{$args};

    if ( $args{command} eq "destroyveh" )
	{
		$kernel->yield( "destroyveh" => \%args );
	}
	elsif ( $args{command} eq "refund" )
	{
		$kernel->yield( "refund" => \%args );
    }
	elsif ( $args{command} eq "spectate" )
	{
		$kernel->yield( "spectate" => \%args );
    }
	elsif ( $args{command} eq "save" )
	{
		$kernel->yield( "save" => \%args );
	}
	elsif ( $args{command} eq "bmute" )
	{
		$kernel->yield( "bmute" => \%args );
	}
	elsif ( $args{command} eq "ballow" )
	{
		$kernel->yield( "ballow" => \%args );
	}
        elsif ( $args{command} eq "zeropoints" )
	{
		$kernel->yield("zeropoints" => \%args);
	}
}



1;