;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; WOLProxy v1.2 Copyright  2004-2011 Tiberian Technologies
; 
; Changelog:
; 2011 Jan 28 - Release v1.2
; - Revised to reflect many changes to XWIS IP/port locations
;
; 2006 Sept 03 - Release v1.1
; - Automatic reconnection to WOL 
; - Automatic detection of WOL non-response to map start command, sends fake response to FDS to prevent it from crashing
; - IP banning with wildcards, effective for preventing IP harvesting bots and exploiters. (Not an effective ban for players)
; 
;
; v1.00
; - Initial release
;
; CREDITS -
; v1.0  - v00d00 (v00d00 Net Services) - initial concept and release
; v1.1,1.2  - Crimson - Auto-reconnect functionality, ip banning
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



















on 1:START:{
  echo -st 13*** WOLProxy v1.1 Copyright  2004-2011 Tiberian Technologies
  echo -st 13*** Listening on ports: 4003, 4004, 4005
  unset %WOL_*
  socklisten WOLpUSA 4003
  socklisten WOLpEUR 4004
  socklisten WOLpPAC 4005
  .timer 0 1 globaltimer
}

alias -l inlist {
  var %i = 1, %j = $numtok($2,32)
  while (%i <= %j) {
    if ($gettok($2,%i,32) iswm $strip($1)) return 1
    inc %i
  }
  return 0
}

alias -l istimer {
  var %i = 1, %j = $timer(0)
  while (%i <= %j) {
    if ($timer(%i) == $1) return $true
    inc %i
  }
  return $false
}

alias -l WOLp_bans {
  var %i = 1, %j = $numtok(%WOL.bans,32)
  while (%i <= %j) {
    .timer $+ $rand(0,1000) -o 1 %i .sockwrite -nt WOL_r $+ $mid($1,6) MODE $chr(35) $+ %WOL_r [ $+ [ $mid($1,6) $+ _NICK ] ] +b $gettok(%WOL.bans,%i,32)
    .timer $+ $rand(0,1000) -o 1 %i WOLp_Log $1 04Banning $gettok(%WOL.bans,%i,32)
    inc %i
  }
}

alias reconnect1 {
  if ($sock(WOL_r $+ $1).status == active) {
    .sockwrite -nt WOL_r $+ $1 CVERS 11020 12288
    .sockwrite -nt WOL_r $+ $1 PASS supersecret
    .sockwrite -nt WOL_r $+ $1 NICK %WOL_r [ $+ [ $1 $+ _NICK ] ]
    .sockwrite -nt WOL_r $+ $1 apgar %WOL_r [ $+ [ $1 $+ _PASSWORD ] ]
    .sockwrite -nt WOL_r $+ $1 SERIAL %WOL_r [ $+ [ $1 $+ _SERIAL ] ]
    .sockwrite -nt WOL_r $+ $1 USER UserName HostName irc.westwood.com :RealName
    .sockwrite -nt WOL_r $+ $1 verchk 32512 720916
    .sockwrite -nt WOL_r $+ $1 SETOPT 17,33
  }
}

alias reconnect2 {
  if ($sock(WOL_r $+ $1).status == active) {
    WOLp_Log2 WOL_r $+ $1 Sending reconnect string 2
    .sockwrite -nt WOL_r $+ $1 SETOPT 17,33
    .sockwrite -nt WOL_r $+ $1 GETINSIDER %WOL_r [ $+ [ $1 $+ _NICK ] ]
    .sockwrite -nt WOL_r $+ $1 TIME
    .sockwrite -nt WOL_r $+ $1 SETCODEPAGE 1252
    .sockwrite -nt WOL_r $+ $1 JOINGAME %WOL_r [ $+ [ $1 $+ _JOINGAME ] ]
  }
}

alias -l WOLp_Cleanup {
  unset %WOL_ [ $+ [ [ $1 ] $+ [ $mid($2,6) ] $+ _* ] ]
  if ($1 == r) {
    set %WOL_active $remtok(%WOL_active,$mid($2,6),1,32)
  }
}

;alias to echo
alias -l WOLp_Log {
  if ($gettok($sock(WOL_l $+ $mid($1,6)).mark,2,32) != 0) {
    echo -st 03[WOLProxy  $+ $gettok($sock(WOL_l $+ $mid($1,6)).mark,2,32) $+ 03] $2-
  }
  else {
    echo -st 03[WOLProxy  $+ $mid($1,6) $+ 03] $2-
  }
}

;alias for debugs
alias -l WOLp_Log2 {
  if (%WOL.debug == 1) {
    if ($gettok($sock(WOL_l $+ $mid($1,6)).mark,2,32) != 0) {
      echo -st 03[WOLProxy  $+ $gettok($sock(WOL_l $+ $mid($1,6)).mark,2,32) $+ 03] $2-
    }
    else {
      echo -st 03[WOLProxy  $+ $mid($1,6) $+ 03] $2-
    }
  }
}

alias globaltimer {
  var %i = 1, %j = $numtok(%WOL_active,32)
  while (%i <= %j) {
    var %cur = $gettok(%WOL_active,%i,32)
    if (%WOL_r [ $+ [ %cur $+ _ONLINE ] ] == 0 || $sock(WOL_r $+ %cur).status != active) {
      if (!$istimer(%cur $+ rc1) && !$istimer(%cur $+ rc2)) {
        .sockopen WOL_r $+ %cur %WOL.ip $sock(WOL_l $+ %cur).bindport
        .timer $+ %cur $+ rc1 1 5 reconnect1 %cur
        .timer $+ %cur $+ rc2 1 6 reconnect2 %cur
      }
    }
    if (%WOL_r [ $+ [ %cur $+ _STARTG ] ] != 0) {
      WOLp_Log2 WOL_r $+ %cur Checking STARTG - values: $ctime - $int(%WOL_r [ $+ [ %cur $+ _STARTG ] ]) = $calc($ctime - $int(%WOL_r [ $+ [ %cur $+ _STARTG ] ]))
      if ($calc($ctime - $int(%WOL_r [ $+ [ %cur $+ _STARTG ] ])) > 10) {
        set %WOL_r [ $+ [ %cur $+ _STARTG ] ] 0
        .sockwrite -nt WOL_l $+ %cur %WOL_r [ $+ [ %cur $+ _NICK ] ] $+ !u@h STARTG u : $+ %WOL_r [ $+ [ %cur $+ _NICK ] ] $gettok(%WOL_r [ $+ [ %cur $+ _STARTGSTR ] ],3,32) $gettok(%WOL_r [ $+ [ %cur $+ _STARTGSTR ] ],4,32) $ctime
        WOLp_Log2 WOL_r $+ %cur No STARTG received from WOL, sent fake STARTG response to FDS
      }
    }
    inc %i
  }
}

on *:socklisten:WOLp*: { 
  var %rnd = $rand(11111111,99999999)
  sockaccept WOL_l $+ %rnd
  sockmark WOL_l $+ %rnd 0 0 $sock($sockname).port
  WOLp_Log WOL_l $+ %rnd 11Incoming connection on port $sock($sockname).port 11from $sock(WOL_l $+ %rnd).ip $+ : $+ $sock(WOL_l $+ %rnd).port
}

on *:sockopen:WOL_r*:{
  var %i = 1
  set %WOL_active $addtok(%WOL_active,$mid($sockname,6),32)
  sockmark WOL_l $+ $mid($sockname,6) 1 $gettok($sock(WOL_l $+ $mid($sockname,6)).mark,2-,32)
  while (%i <= $var(%WOL_l*,0)) {
    if ($mid($sockname,6) == $mid($var(%WOL_l*,%i),7,8)) {
      WOLp_Log2 $sockname DEBUG OUT: $var(%WOL_l*,%i).value
      .sockwrite -nt $sockname $var(%WOL_l*,%i).value
    }
    inc %i
  }
  WOLp_Cleanup l $sockname
  set %WOL_r [ $+ [ $mid($sockname,6) $+ _STARTG ] ] 0
}

on *:sockread:WOL_l*:{
  if ($sockerr > 0) return
  var %incoming
  :nextread
  sockread %incoming
  if ($sockbr == 0) return
  if (%incoming == $null) goto nextread
  var %cmd = $left(%incoming,$pos(%incoming,$chr(32),1))
  var %data = $mid(%incoming,$calc($pos(%incoming,$chr(32),1) + 1))
  if ($gettok($sock($sockname).mark,1,32) == 0) {
    set % [ $+ [ $sockname $+ _ $+ [ $var(%WOL_l*,0) ] ] ] %incoming
    if (%cmd == NICK) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _NICK ] ] $gettok(%incoming,2,32)
      set %WOL_r $+ _ $+ $gettok(%incoming,2,32) $mid($sockname,6)
      WOLp_Log $sockname 11Now referring to the socket as $gettok(%incoming,2,32)
      sockmark $sockname 0 $gettok(%incoming,2,32) $gettok($sock($sockname).mark,3,32)
      sockopen WOL_r $+ $mid($sockname,6) 195.13.63.165 $gettok($sock($sockname).mark,3,32)
      WOLp_Log $sockname 11Creating WOL connection - Port $gettok($sock($sockname).mark,3,32)
    }
    elseif (%cmd == apgar) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _PASSWORD ] ] %data
    }
    elseif (%cmd == SERIAL) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _SERIAL ] ] %data
    }
  }
  else {
    WOLp_Log2 $sockname DEBUG OUT: %incoming
    if (%cmd == TOPIC) {
      var %topic = $mid(%incoming,$calc($pos(%incoming,:) + 41))
      var %namelen = $calc($asc($mid(%topic,1,1)) - 32)
      var %maplen = $calc($asc($mid(%topic,$calc(%namelen + 2),1)) - 32)
      var %map = $gettok($mid(%topic,$calc(%namelen + 3),%maplen),1,46)
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _MAP ] ] %map
    }
    elseif (%cmd == STARTG) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _STARTG ] ] $ctime
      WOLp_Log2 $sockname Sent STARTG to WOL, awaiting STARTG reply
      if ($gettok($sock($sockname).mark,1,32) == 1) {
        WOLp_Log $sockname 11Game started: %WOL_r [ $+ [ $mid($sockname,6) $+ _MAP ] ]
        WOLp_bans $sockname
        sockmark $sockname 2 $gettok($sock($sockname).mark,2-,32)
      }
      else WOLp_Log $sockname 11Map change: %WOL_r [ $+ [ $mid($sockname,6) $+ _MAP ] ]
    }
    elseif (%cmd == JOINGAME) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _JOINGAME ] ] %data
    }
    .sockwrite -nt WOL_r $+ $mid($sockname,6) %incoming
  }
  goto nextread
}

on *:sockread:WOL_r*:{
  if ($sockerr > 0) return
  var %incoming
  :nextread
  sockread %incoming
  if ($sockbr == 0) return
  if (%incoming == $null) goto nextread

  var %data = %incoming
  WOLp_Log2 $sockname DEBUG IN: %data
  if ($left(%data,1) == :) {
    var %prefix = $mid(%data,2,$calc($pos(%data,$chr(32),1) - 1))
    if (! isin %prefix) var %prefix = $left(%prefix,$calc($pos(%prefix,!) - 1))
    var %data = $mid(%data,$calc($pos(%data,$chr(32),1) + 1))
  }
  else var %prefix = irc.westwood.com
  var %command = $left(%data,$pos(%data,$chr(32),1))
  var %data = $mid(%data,$calc($pos(%data,$chr(32),1) + 1))

  if (%WOL_r [ $+ [ $mid($sockname,6) $+ _ONLINE ] ] == 0) {
    WOLp_Log $sockname 11FDS/WOL link established
  }
  set %WOL_r [ $+ [ $mid($sockname,6) $+ _ONLINE ] ] 1

  if ($inlist(%prefix,%WOL.ignore_users) == 1) {
    WOLp_Log $sockname 04Ignored %command from %prefix
  }
  else {
    if ((%prefix != irc.westwood.com)) {
      if (%command == JOINGAME) {
        var %joiner_ip = $longip($gettok(%data,6,32))
        if ($len(%joiner_ip) < 2) {
          var %joiner_ip = 0.0.0.0
        }
        if ($inlist(%joiner_ip,%WOL.banips) == 1) {
          var %channel = $chr(35) $+ %WOL_r [ $+ [ $mid($sockname,6) $+ _NICK ] ]
          .sockwrite -nt WOL_r $+ $mid($sockname,6) KICK %channel %prefix
          .sockwrite -nt WOL_r $+ $mid($sockname,6) BAN %channel %prefix   
          WOLp_Log $sockname KICKING BANNED USER @ IP: %joiner_ip $+ 
        }
      }
    }
    if (%command == STARTG) {
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _STARTG ] ] 0
      set %WOL_r [ $+ [ $mid($sockname,6) $+ _STARTGSTR ] ] %data
      WOLp_Log2 $sockname Received STARTG from WOL
    }
    if (%command != ERROR) {
      .sockwrite -nt WOL_l $+ $mid($sockname,6) %incoming
    }
  }
  goto nextread
}

on *:sockclose:WOL_l*:{
  WOLp_Cleanup l $sockname
  WOLp_Cleanup r $sockname
  WOLp_Log $sockname 11FDS disconnected - Disconnecting WOL
  sockclose WOL_r $+ $mid($sockname,6)
}

on *:sockclose:WOL_r*:{
  set %WOL_r [ $+ [ $mid($sockname,6) $+ _ONLINE ] ] 0
  WOLp_Log $sockname 11WOL disconnected - Reconnecting
}
