/*	Renegade Scripts.dll
	SSAOW keyhook scripts
	Copyright 2006 WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/


#include <vector>
#include "scripts.h"
#include "engine.h"
#include "keyhook.h"
#include "aow.h"

void debug_k (KeyHookStruct *k, int hookid, char *text)
{
	/*
	char tmp[256];
	sprintf	(tmp, "%p %s k->hook = %p, k->ID = %d, k->key %s, hookid = %d", k->data, text, k->hook, k->ID, k->key, hookid);
	Console_Output(tmp);
	*/	
}

void KeyHookCall(void *Data)
{
	MDB_KeyHook *Base = (MDB_KeyHook *)Data;
	Base->KeyHookFunc();
}

int MDB_KeyHook::AddHook(const char *Key, GameObject *obj)
{
	k = 0;
	k = new KeyHookStruct;
	k->data = this;
	k->hook = KeyHookCall;
	k->ID = Get_Player_ID(obj);
	k->key = strdup(Key);
	if (is_keyhook_set == 1337)
	{
		RemoveHook();
	}
	hookid = AddKeyHook(k);
	return hookid;
}

void MDB_KeyHook::RemoveHook()
{
	if (hookid != 0 && RemoveKeyHook != 0)
	{
		RemoveKeyHook(hookid);
		hookid = 0;
		if (k != 0)
		{
			delete k;
			k = 0;
		}
	}
}

void MDB_KeyHook::Detach(GameObject *obj)
{
	if (is_keyhook_set == 1337)
	{
		RemoveHook();
	}
}

void MDB_KeyHook::Destroyed(GameObject *obj)
{
	if (is_keyhook_set == 1337)
	{
		RemoveHook();
	}
}

void MDB_Taunt_Key::Created(GameObject *obj)
{
	if (is_keyhook_set != 1337)
	{
		hookid = AddHook(Get_Parameter("Key"),obj);
		is_keyhook_set = 1337;
	}
}

void MDB_Taunt_Key::KeyHookFunc()
{
	if (Get_Vehicle(Owner()) == 0)
	{
		Commands->Set_Animation(Owner(),Get_Parameter("Anim"),false,0,0.0f,-1.0f,false);
	}
}

void MDB_WriteLog_Key::Created(GameObject *obj)
{
	if (is_keyhook_set != 1337)
	{
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress = The_Game()->GameDuration_Seconds-8;
		is_keyhook_set = 1337;
	}
}

void MDB_WriteLog_Key::KeyHookFunc()
{
	char message[100];
	if ((The_Game()->GameDuration_Seconds - LastPress) >= 8)
	{
		if (Get_Int_Parameter("Type") == 0)
		{
			sprintf(message,"%s: %s",Get_Player_Name(Owner()),Get_Parameter("Write"));
		}
		else
		{
			sprintf(message,"[Team] %s: %s",Get_Player_Name(Owner()),Get_Parameter("Write"));
		}
		WriteLog(message,false);
		LastPress = The_Game()->GameDuration_Seconds;
	}
}

void MDB_VehOwn_Key::Created(GameObject *obj)
{
	if (is_keyhook_set != 1337)
	{
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress = The_Game()->GameDuration_Seconds-5;
		is_keyhook_set = 1337;
	}
}

void MDB_VehOwn_Key::KeyHookFunc()
{
	if ((The_Game()->GameDuration_Seconds - LastPress) >= 5)
	{
		VehicleOwner(Commands->Get_ID(Owner()),Get_Int_Parameter("Type"));
		LastPress = The_Game()->GameDuration_Seconds;
	}
}

ScriptRegistrant<MDB_Taunt_Key>	MDB_Taunt_Key_Registrant("MDB_Taunt_Key","Key:string,Anim:string");
ScriptRegistrant<MDB_WriteLog_Key> MDB_WriteLog_Key_Registrant ("MDB_WriteLog_Key","Key:string,Write:string,Type:int");
ScriptRegistrant<MDB_VehOwn_Key> MDB_VehOwn_Key_Registrant("MDB_VehOwn_Key","Key:string,Type:int");
