/*	Renegade Scripts.dll
	Main SSAOW scripts and functions
	Copyright 2006 Vloktboky, WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "scripts.h"
#include "profile.h"
#include "date.h"
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "aow.h"
#include "gamelog.h"
#include <fstream>
#include <iostream>
#include "crate.h"
#include <vector>
#include <string>
#include <time.h>

const char *Ver = "1.5";

bool Gameover = false;
char CurrMap[30];
char ServerName[30];
bool FirstObject = true;
std::vector<std::string> SvSKillMsg;
std::vector<std::string> VvSKillMsg;
std::vector<std::string> DisableList;
std::vector<std::string> WeaponStartEngL1;
std::vector<std::string> WeaponStartEngL2;
std::vector<std::string> WeaponStartOther;
int SvSKillMsgTotal = 0;
int VvSKillMsgTotal = 0;
std::vector<std::string> StealthUsers;

Setting::Setting() {
	ReportBuildingDamage = true;
	ReportBuildingDeath = true;
	BuildingDeathRewardPage = false;
	BuildingDamageInt = 30.0f;
	AFKKick = false;
	AFKWait = 10;
	DropWeapons = true;
	ShowPlayerPurchase = false;
	ShowPlayerKillMessage = false;
	Weather = true;
	LogVehCreate = false;
	LogVehDeath = false;
	PlayVehDeathAnim = false;
	EnableVehicleDamageAnim = true;
	LogHarvesterDeath = true;
	OBGEnable = true;
	DestroyPlayerVeh = true;
	DisableBaseDefenses = false;
	DisablePowerPlants = false;
	DisableRefineries = false;
	DisableSoldierFactories = false;
	DisableVehicleFactories = false;
	DisableRepairPads = false;
	DisableCommCenters = false;
	Gamelog = true;
	EnableVehicleWreckages = false;
	DefenseShell = false;
	EnableNewCrates = false;
	VehCrate = false;
	CombatRefill = false;
	RefillTime = 0;
	EnableVehOwn = true;
	GameMode = 1;
	InvinBuild = false;
	DisableBeacons = false;
	Log = true;
	EchoLog = true;
	SpawnWeap = true;
	NewGamelog = true;
	ForceTeam = -1;
	BWDetector = true;
	BWDefault = 56000;
	BWPunishKick = false;
	MergeGamelogRenlog = false;
}

Setting *Settings = new Setting;


bool IsDisabled(const char *Preset) {
	if (!DisableList.empty()) {
		std::vector<std::string>::iterator it;
		for (it = DisableList.begin(); it != DisableList.end(); ++it) {
			if (strstr((*it).c_str(),Preset)) return true;
		}
	}
	return false;
}

bool IsDisabled(GameObject *obj) {
	return IsDisabled(Commands->Get_Preset_Name(obj));
}


void CheckBW() {
	int Players = The_Game()->MaxPlayers;
	for (int i = 1;i <= Players;i++) {
		if (Get_GameObj(i)) {
			int BW = Get_Bandwidth(i);
			if (BW < Settings->BWDefault) {
				char Msg[256];
				if (Settings->BWPunishKick) {
					sprintf(Msg,"%s wurde gekickt wegen zu langsamer Verbindung.",Get_Player_Name_By_ID(i));
					FDSMessage(Msg,"_ALERT");
					sprintf(Msg,"kick %d",i);
					Console_Input(Msg);
					sprintf(Msg,"allow %s",Get_Player_Name_By_ID(i));
					Console_Input(Msg);
				}
				else {
					sprintf(Msg,"setbw %d %d",i,Settings->BWDefault);
					Console_Input(Msg);
					sprintf(Msg,"%s versuchte mit einem 56k Modem reinzukommen. Speed auf Minimum gesetzt.",Get_Player_Name_By_ID(i));
					FDSMessage(Msg,"_ALERT");
					sprintf(Msg,"ppage %d die Internetspeed von dir is weniger als %d Sie wurde auf %d gesetzt.",i,Settings->BWDefault,Settings->BWDefault);
					Console_Input(Msg);
				}
			}
		}
	}
}

void PlayerJoinHook(int i,const char *Nick) {
	int BW = Get_Bandwidth(i);
			if (BW < Settings->BWDefault) {
				char Msg[256];
				if (Settings->BWPunishKick) {
					sprintf(Msg,"%s wurde gekickt wegen zu langsamer Internetverbindung.",Get_Player_Name_By_ID(i));
					FDSMessage(Msg,"_ALERT");
					sprintf(Msg,"kick %d",i);
					Console_Input(Msg);
					sprintf(Msg,"allow %s",Get_Player_Name_By_ID(i));
					Console_Input(Msg);
				}
				else {
					sprintf(Msg,"setbw %d %d",i,Settings->BWDefault);
					Console_Input(Msg);
					sprintf(Msg,"%s versuchte mit einem 56k Modem reinzukommen. Speed auf Minimum gesetzt.",Get_Player_Name_By_ID(i));
					FDSMessage(Msg,"_ALERT");
					sprintf(Msg,"ppage %d die Internetspeed von dir is weniger als %d Sie wurde auf %d gesetzt.",i,Settings->BWDefault,Settings->BWDefault);
					Console_Input(Msg);
				}
			}
}

void ObjectHookCall (void *data,GameObject *obj) {
	ObjectHookClass *Base = (ObjectHookClass*)data;
	Base->NewObject(obj);
}


void ObjectHookClass::Start() {
	o = new ObjectCreateHookStruct;
	o->hook = ObjectHookCall;
	o->data = (void*)this;
	id = AddObjectCreateHook(o);
}

void ObjectHookClass::NewObject(GameObject *obj) {
	/*
	if (FirstObject == true) {
		FirstObject = false;
		RecognizeMap(true);
	}*/
	if (strstr(Commands->Get_Preset_Name(obj),"Crate") || strstr(Commands->Get_Preset_Name(obj),"crate")) {
		Attach_Script_Once(obj,"MDB_CNC_Crate","");
	}
	if (Settings->Gamelog) GamelogObjectHook(obj);
}

ObjectHookClass::~ObjectHookClass()
{
	if (id && RemoveObjectCreateHook) RemoveObjectCreateHook(id);
}


float Get_Character_Price (const char* Preset)
{
	float Price = 0;
	if (stricmp(Preset,"CnC_GDI_Engineer_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_GDI_Engineer_2SF") == 0) Price = 350;
	else if (stricmp(Preset,"CnC_GDI_Grenadier_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_GDI_Grenadier_2SF") == 0) Price = 450;
	else if (strstr(Preset,"CnC_Ignatio_Mobius")) Price = 1000;
	else if (stricmp(Preset,"CnC_GDI_MiniGunner_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_GDI_MiniGunner_1Off") == 0) Price = 175;
	else if (stricmp(Preset,"CnC_GDI_MiniGunner_2SF") == 0) Price = 500;
	else if (strstr(Preset,"CnC_GDI_MiniGunner_3Boss")) Price = 1000;
	else if (stricmp(Preset,"CnC_GDI_RocketSoldier_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_GDI_RocketSoldier_1Off") == 0) Price = 225;
	else if (stricmp(Preset,"CnC_GDI_RocketSoldier_2SF") == 0) Price = 400;
	else if (stricmp(Preset,"CnC_Nod_Engineer_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_Nod_FlameThrower_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_Nod_FlameThrower_1Off") == 0) Price = 150;
	else if (stricmp(Preset,"CnC_Nod_FlameThrower_2SF") == 0) Price = 400;
	else if (strstr(Preset,"CnC_Nod_FlameThrower_3Boss")) Price = 1000;
	else if (stricmp(Preset,"CnC_Nod_Minigunner_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_Nod_Minigunner_1Off") == 0) Price = 175;
	else if (stricmp(Preset,"CnC_Nod_Minigunner_2SF") == 0) Price = 500;
	else if (strstr(Preset,"CnC_Nod_Minigunner_3Boss")) Price = 1000;
	else if (strstr(Preset,"CnC_Nod_MiniGunner_3Boss")) Price = 1000;
	else if (stricmp(Preset,"CnC_Nod_RocketSoldier_0") == 0) Price = 0;
	else if (stricmp(Preset,"CnC_Nod_RocketSoldier_1Off") == 0) Price = 225;
	else if (stricmp(Preset,"CnC_Nod_RocketSoldier_2SF") == 0) Price = 450;
	else if (strstr(Preset,"CnC_Nod_RocketSoldier_3Boss")) Price = 1000;
	else if (stricmp(Preset,"CnC_Nod_Technician_0") == 0) Price = 350;
	else if (strstr(Preset,"CnC_Sydney_PowerSuit")) Price = 1000;
	else if (stricmp(Preset,"CnC_Sydney") == 0) Price = 150;
	return Price;
}

void WriteLog(const char *Message, bool ShowTime)
{
	date logdate;
	logdate.refreshdate();
	char FDSlogname[100];
#ifdef WIN32
	sprintf(FDSlogname, "renlog_%s.txt",logdate.get_date_string());
#else
	sprintf(FDSlogname, "bhs_renlog_%s.txt",logdate.get_date_string());
#endif
	FILE *FP;
	if ((FP = fopen( FDSlogname, "a")) == NULL) return;
	char messageprint[512];
	char hours[5];
	char mins[5];
	char secs[5];
	time_t rawtime;
	struct tm *timeinfo;
	time(&rawtime);
	timeinfo = localtime(&rawtime);
	int hour = timeinfo->tm_hour;
	int min = timeinfo->tm_min;
	int sec = timeinfo->tm_sec;
	if (hour < 10) sprintf(hours,"0%d",hour);
	else sprintf(hours,"%d",hour);
	if (min < 10) sprintf(mins,"0%d",min);
	else sprintf(mins,"%d",min);
	if (sec < 10) sprintf(secs,"0%d",sec);
	else sprintf(secs,"%d",sec);
	sprintf(messageprint,"[%s:%s:%s] %s\n",hours,mins,secs,Message);
	fputs( messageprint, FP );
	fclose( FP );
	return;
}

void add_stealth_user(const char* name)
{
	StealthUsers.push_back(name);
}

char *Translate_Preset(GameObject *obj)
{
	const char *preset = Commands->Get_Preset_Name(obj);
	char *TransName = new char[256];
	getProfileString("Translated_Preset",preset,preset,TransName,256,"ssaow.ini");
	return TransName;
}

char *Translate_Weapon(GameObject *obj)
{
	const char *preset = Get_Current_Weapon(obj);
	char *TransName = new char[256];
	getProfileString("Translated_Preset",preset,preset,TransName,256,"ssaow.ini");
	return TransName;
}

char *Get_Preset_Info(GameObject *obj) {
	char *Return = new char[256];
	if (Is_Soldier(obj)) {
		if (Get_Vehicle(obj)) {
			sprintf(Return,"%s",Translate_Preset(Get_Vehicle_Return(obj)));
		}
		else {
			sprintf(Return,"%s/%s",Translate_Preset(obj),Translate_Weapon(obj));
		}
	}
	else {
		sprintf(Return,"%s",Translate_Preset(obj));
	}
	return Return;
}

GameObject *GVDA(int Type, int Size, GameObject *obj)
{
	GameObject *retString = 0;
	int Random;
	if (Type == 1)
	{
		if (Size == 1)
		{
			Random = Commands->Get_Random_Int(1,3);
			if (Random == 1) retString = Commands->Create_Object("SFX.Arrow_Troops_Concrete",Commands->Get_Position(obj));
			else if (Random == 2) retString = Commands->Create_Object("SFX.Arrow_Troops_Generic",Commands->Get_Position(obj));
			else retString = Commands->Create_Object("SFX.Arrow_Troops_Concrete",Commands->Get_Position(obj));
		}
		else if (Size == 2)
		{
			Random = Commands->Get_Random_Int(1,3);
			if (Random == 1) retString = Commands->Create_Object("SFX.Arrow_Troops_Metal",Commands->Get_Position(obj));
			else if (Random == 2) retString = Commands->Create_Object("SFX.Arrow_Troops_Snow",Commands->Get_Position(obj));
			else retString = Commands->Create_Object("SFX.Arrow_Troops_Metal",Commands->Get_Position(obj));
		}
	}
	else if (Type == 2)
	{
		retString = Commands->Create_Object("SFX.Arrow_Troops_Stone",Commands->Get_Position(obj));
	}
	else if (Type == 4)
	{
		retString = Commands->Create_Object("SFX.Arrow_Troops_Wood",Commands->Get_Position(obj));
	}
	char ID[20];
	sprintf(ID,"%d",Commands->Get_ID(obj));
	Commands->Attach_Script(retString,"MDB_Destroy_When_Object_Destroyed",ID);
	return retString;
}

void FDSMessage(const char* Message, const char* LogHeader)
{
	if (!Settings->Log && stricmp(LogHeader,"_GAMELOG")) return;
	date renremdate;
	renremdate.refreshdate();
	char FDSlogname[100];
	char FDSlogbegin[85];
	getProfileString("General","FDSLogRoot","ssaowlog",FDSlogbegin,85,"ssaow.ini");
	sprintf(FDSlogname, "%s_%s.txt",FDSlogbegin,renremdate.get_date_string());
	FILE *FP;
	if ( (FP = fopen( FDSlogname, "a")) == NULL ) return;
	char messageprint[512];
	char hours[5];
	char mins[5];
	char secs[5];
	time_t rawtime;
	struct tm *timeinfo;
	time(&rawtime);
	timeinfo = localtime(&rawtime);
	int hour = timeinfo->tm_hour;
	int min = timeinfo->tm_min;
	int sec = timeinfo->tm_sec;
	if (hour < 10) sprintf(hours,"0%d",hour);
	else sprintf(hours,"%d",hour);
	if (min < 10) sprintf(mins,"0%d",min);
	else sprintf(mins,"%d",min);
	if (sec < 10) sprintf(secs,"0%d",sec);
	else sprintf(secs,"%d",sec);
	if (Settings->EchoLog && stricmp(LogHeader,"_GAMELOG")) printf("%s\n",Message);
	sprintf(messageprint,"[%s:%s:%s] %s %s\n",hours,mins,secs,LogHeader,Message);
	fputs( messageprint, FP );
	fclose( FP );
}

char *FirstMap() {
	char Conf[50],Conf2[50];
	char *FirstMap2 = new char[30];
	getProfileString("Server","Config","svrcfg_cnc.ini",Conf,50,"server.ini");
	sprintf(Conf2,"data/%s",Conf);
	getProfileString("Settings","MapName00","null",FirstMap2,30,Conf2);
	return FirstMap2;
}

char *LoadSettingStringFirstMap(const char *Setting,const char *Default="null",bool Global=true,bool Map=true) {
	char *TempSet = new char[200];
	char TempSet2[200];
	if (Global)
	{
		getProfileString("General",Setting,Default,TempSet2,200,"ssaow.ini");
	}
	if (Map)
	{
		getProfileString(FirstMap(),Setting,TempSet2,TempSet,200,"ssaow.ini");
	}
	return TempSet;
}

bool LoadSetting(const char *Setting,int Default=1,bool Global=true,bool Map=true)
{
	int TempSet = Default;
	if (Global)
	{
		TempSet = getProfileInt("General",Setting,Default,"ssaow.ini");
	}
	if (Map)
	{
		TempSet = getProfileInt(CurrMap,Setting,TempSet,"ssaow.ini");
	}
	return TempSet;
}

int LoadSettingInt(const char *Setting,int Default=1,bool Global=true,bool Map=true)
{
	int TempSet = Default;
	if (Global)
	{
		TempSet = getProfileInt("General",Setting,Default,"ssaow.ini");
	}
	if (Map)
	{
		TempSet = getProfileInt(CurrMap,Setting,TempSet,"ssaow.ini");
	}
	return TempSet;
}

const char *LoadSettingString(const char *Setting,const char *Default="null",bool Global=true,bool Map=true) {
	char *TempSet = new char[200];
	char TempSet2[200];
	if (Global)
	{
		getProfileString("General",Setting,Default,TempSet2,200,"ssaow.ini");
	}
	if (Map)
	{
		getProfileString(CurrMap,Setting,TempSet2,TempSet,200,"ssaow.ini");
	}
	return TempSet;
}

float LoadSettingFloat(const char *Setting,float Default=1.0,bool Global=true,bool Map=true)
{
	float TempSet = Default;
	if (Global)
	{
		TempSet = getProfileFloat("General",Setting,Default,"ssaow.ini");
	}
	if (Map)
	{
		TempSet = getProfileFloat(CurrMap,Setting,TempSet,"ssaow.ini");
	}
	return TempSet;
}

void Chat(int ID,int Type,const wchar_t *Msg);

void RecognizeMap(bool IsLoad) {
	if (IsLoad == true) {
		StealthUsers.erase(StealthUsers.begin(),StealthUsers.end());
		strcpy(CurrMap,The_Game()->MapName);
		getProfileString("Server","Nickname","WESTWOOD",ServerName,30,"server.ini");
		char mapname[100];
		sprintf(mapname,"-> Map \"%s\" detected, loading settings..",CurrMap);
		FDSMessage(mapname,"_GENERAL");
		bool ShowSetChangeMess = false;
		AddChatHook(Chat);
		AddPlayerJoinHook(PlayerJoinHook);

		Settings->Gamelog = LoadSetting("Enable_Gamelog",1,true,false);
		Settings->NewGamelog = LoadSetting("Enable_NewGamelog",1,true,false);
		Settings->Log = LoadSetting("EnableLog",1,true,false);
		Settings->EchoLog = LoadSetting("EchoLog",1,true,false);
		Settings->Gamelog_Archive_Logfiles = LoadSetting("Gamelog_Archive_Logfiles",1,true,false);
		Settings->MergeGamelogRenlog = LoadSetting("Write_Gamelog_to_SSAOWlog",0,true,false);
		
		int PSet_Mode = Settings->GameMode;
		Settings->GameMode = LoadSettingInt("GameMode");
		if (Settings->GameMode > 5 || Settings->GameMode < 1 || Settings->GameMode == 2)
		{
			Settings->GameMode = 1;
			FDSMessage("Gamemode out of range. Defaulting to AOW.","_ERROR");
		}
		char Mode[30],Mode2[80];
		if (Settings->GameMode == 1) sprintf(Mode,"All Out War");
		else if (Settings->GameMode == 2) sprintf(Mode,"Capture The Flag");
		else if (Settings->GameMode == 3) sprintf(Mode,"Snipers Only");
		else if (Settings->GameMode == 4) sprintf(Mode,"500 Snipers Only");
		else if (Settings->GameMode == 5) sprintf(Mode,"Infantry Only");
		sprintf(Mode2,"Running in %s mode.",Mode);
		FDSMessage(Mode2,"_GENERAL");
		if (PSet_Mode != Settings->GameMode && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_RBDM = Settings->ReportBuildingDamage;
		Settings->ReportBuildingDamage = LoadSetting("ReportBuildingDamage");
		if (PSet_RBDM != Settings->ReportBuildingDamage && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_RBDT = Settings->ReportBuildingDeath;
		Settings->ReportBuildingDeath = LoadSetting("ReportBuildingDeath");
		if (PSet_RBDT != Settings->ReportBuildingDeath && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_BDRP = Settings->BuildingDeathRewardPage;
		Settings->BuildingDeathRewardPage = LoadSetting("BuildingDeathRewardPage",0);
		if (PSet_BDRP != Settings->BuildingDeathRewardPage && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		float PSet_BDI = Settings->BuildingDamageInt;
		Settings->BuildingDamageInt = LoadSettingFloat("BuildingDamageInterval",30.0f);
		if (PSet_BDI != Settings->BuildingDamageInt && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_AFL = Settings->AFKKick;
		Settings->AFKKick = LoadSetting("AFKKick",0);
		if (PSet_AFL != Settings->AFKKick && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		int PSet_AFKWait = Settings->AFKWait;
		Settings->AFKWait = LoadSettingInt("AFKWait",10);
		if (Settings->AFKWait < 2)
		{
			FDSMessage("Error: AFKWait must be at least 2 minutes. Defaulting to 10 minutes.","_GENERAL");
			Settings->AFKWait = 10;
		}
		else if (PSet_AFKWait != Settings->AFKWait && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		char PSet_AFKPage[200];
		strcpy(PSet_AFKPage,Settings->AFKPageMessage);
		strcpy(Settings->AFKPageMessage,LoadSettingString("AFKPageMessage","Warning! You might be kicked for being AFK/Idle if you do not move!"));
		if (stricmp(Settings->AFKPageMessage,PSet_AFKPage) != 0 && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DW = Settings->DropWeapons;
		Settings->DropWeapons = LoadSetting("EnableDropWeapons");
		if (PSet_DW != Settings->DropWeapons && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_SPP = Settings->ShowPlayerPurchase;
		Settings->ShowPlayerPurchase = LoadSetting("ShowPlayerPurchases");
		if (PSet_SPP != Settings->ShowPlayerPurchase && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_SPKM = Settings->ShowPlayerKillMessage;
		Settings->ShowPlayerKillMessage = LoadSetting("ShowPlayerKillMessage");
		if (PSet_SPKM != Settings->ShowPlayerKillMessage && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_Weather = Settings->Weather;
		Settings->Weather = LoadSetting("EnableWeather",0);
		if (PSet_Weather != Settings->Weather && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_LVC = Settings->LogVehCreate;
		Settings->LogVehCreate = LoadSetting("LogVehicleCreate");
		if (PSet_LVC != Settings->LogVehCreate && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_LVD = Settings->LogVehDeath;
		Settings->LogVehDeath = LoadSetting("LogVehicleDeath");
		if (PSet_LVD != Settings->LogVehDeath && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		/*
		bool PSet_PVDA = Settings->PlayVehDeathAnim;
		Settings->PlayVehDeathAnim = LoadSetting("PlayVehicleDeathAnimations");
		if (PSet_PVDA != Settings->PlayVehDeathAnim && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		*/

		bool PSet_EVDA = Settings->EnableVehicleDamageAnim;
		Settings->EnableVehicleDamageAnim = LoadSetting("EnableVehicleDamageAnimations");
		if (PSet_EVDA != Settings->EnableVehicleDamageAnim && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_LHD = Settings->LogHarvesterDeath;
		Settings->LogHarvesterDeath = LoadSetting("LogHarvesterDeath");
		if (PSet_LHD != Settings->LogHarvesterDeath && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_OBGE = Settings->OBGEnable;
		Settings->OBGEnable = LoadSetting("EnableObGlitchProtect",0);
		if (PSet_OBGE != Settings->OBGEnable && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		char PSet_OBGPM[200];
		strcpy(PSet_OBGPM,Settings->OBGPageMessage);
		strcpy(Settings->OBGPageMessage,LoadSettingString("ObGlitchPageMessage","Warning! You might be kicked for glitching the Obelisk!"));
		if (stricmp(Settings->OBGPageMessage,PSet_OBGPM) != 0 && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DPV = Settings->DestroyPlayerVeh;
		Settings->DestroyPlayerVeh = LoadSetting("DestroyPlayerVeh",0);
		if (PSet_DPV != Settings->DestroyPlayerVeh && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_EVW = Settings->EnableVehicleWreckages;
		Settings->EnableVehicleWreckages = LoadSetting("EnableVehicleWreckages");
		if (PSet_EVW != Settings->EnableVehicleWreckages && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		int PSet_SvsT = SvSKillMsgTotal;
		SvSKillMsgTotal = 0;
		int x = getProfileInt("SvSKillMsg","Total",0,"ssaow.ini");
		for (int a = 1; a <= x; a++)
		{
			char key[5],value[256];
			sprintf(key,"Str%d",a);
			getProfileString("SvSKillMsg",key,"Error_BadKillMsg",value,256,"ssaow.ini");
			SvSKillMsg.push_back(value);
			SvSKillMsgTotal++;
		}
		if (PSet_SvsT != SvSKillMsgTotal && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		int PSet_VvsT = VvSKillMsgTotal;
		VvSKillMsgTotal = 0;
		x = getProfileInt("VvSKillMsg","Total",0,"ssaow.ini");
		for (int c = 1; c <= x; c++)
		{
			char key[5],value[256];
			sprintf(key,"Str%d",c);
			getProfileString("VvSKillMsg",key,"Error_BadKillMsg",value,256,"ssaow.ini");
			VvSKillMsg.push_back(value);
			VvSKillMsgTotal++;
		}
		if (PSet_VvsT != VvSKillMsgTotal && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		char DisableListName[100];
		strncpy(DisableListName,LoadSettingString("DisableList","ERROR"),100);
		if (stricmp(DisableListName,"ERROR") != 0)
		{
			for (int z = 1; z <= 999; z++)
			{
				char key[3], value[256];
				if (z < 10) sprintf(key,"0%d",z);
				else sprintf(key,"%d",z);
				getProfileString(DisableListName,key,"NULL",value,256,"ssaow.ini");
				if (stricmp(value,"NULL") == 0) z = 1000;
				else DisableList.push_back(value);
			}
		}
		bool PSet_DBD = Settings->DisableBaseDefenses;
		Settings->DisableBaseDefenses = LoadSetting("DisableBaseDefenses",0);
		if (PSet_DBD != Settings->DisableBaseDefenses && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DPP = Settings->DisablePowerPlants;
		Settings->DisablePowerPlants = LoadSetting("DisablePowerPlants",0);
		if (PSet_DPP != Settings->DisablePowerPlants && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DR = Settings->DisableRefineries;
		Settings->DisableRefineries = LoadSetting("DisableRefineries",0);
		if (PSet_DR != Settings->DisableRefineries && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DSF = Settings->DisableSoldierFactories;
		Settings->DisableSoldierFactories = LoadSetting("DisableSoldierFactories",0);
		if (PSet_DSF != Settings->DisableSoldierFactories && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DVF = Settings->DisableVehicleFactories;
		Settings->DisableVehicleFactories = LoadSetting("DisableVehicleFactories",0);
		if (PSet_DVF != Settings->DisableVehicleFactories && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DRP = Settings->DisableRepairPads;
		Settings->DisableRepairPads = LoadSetting("DisableRepairPads",0);
		if (PSet_DRP != Settings->DisableRepairPads && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_DCC = Settings->DisableCommCenters;
		Settings->DisableCommCenters = LoadSetting("DisableCommCenters",0);
		if (PSet_DCC != Settings->DisableCommCenters && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_En = Settings->EnableCrates;
		Settings->EnableCrates = LoadSetting("EnableCrates");
		if (PSet_En != Settings->EnableCrates && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_En2 = Settings->EnableNewCrates;
		Settings->EnableNewCrates = LoadSetting("EnableNewCrates");
		if (PSet_En2 != Settings->EnableNewCrates && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		bool PSet_VehC = Settings->VehCrate;
		Settings->VehCrate = LoadSetting("AllowVehCrates",0);
		if (PSet_VehC != Settings->VehCrate && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_SpawnWeap = Settings->SpawnWeap;
		Settings->SpawnWeap = LoadSetting("EnableSpawnWeapons");
		if (PSet_SpawnWeap != Settings->SpawnWeap && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		char WSL1[100], WSL2[100], WSO[100];
		strncpy(WSL1,LoadSettingString("WeaponStartEngL1","DefaultEngL1"),100);
		if (stricmp(WSL1,"ERROR") != 0)
		{
			for (int z = 1; z <= 999; z++)
			{
				char key[3], value[256];
				if (z < 10) sprintf(key,"0%d",z);
				else sprintf(key,"%d",z);
				getProfileString(WSL1,key,"NULL",value,256,"ssaow.ini");
				if (stricmp(value,"NULL") == 0) z = 1000;
				else WeaponStartEngL1.push_back(value);
			}
		}
		if (WeaponStartEngL1.empty())
		{
			WeaponStartEngL1.push_back("CnC_POW_MineTimed_Player_01");
			WeaponStartEngL1.push_back("POW_Pistol_Player");
			WeaponStartEngL1.push_back("CnC_POW_MineRemote_02");
		}		
		strncpy(WSL2,LoadSettingString("WeaponStartEngL2","DefaultEngL2"),100);
		if (stricmp(WSL2,"ERROR") != 0)
		{
			for (int z = 1; z <= 999; z++)
			{
				char key[3], value[256];
				if (z < 10) sprintf(key,"0%d",z);
				else sprintf(key,"%d",z);
				getProfileString(WSL2,key,"NULL",value,256,"ssaow.ini");
				if (stricmp(value,"NULL") == 0) z = 1000;
				else WeaponStartEngL2.push_back(value);
			}
		}
		if (WeaponStartEngL2.empty())
		{
			WeaponStartEngL2.push_back("CnC_POW_MineRemote_02");
			WeaponStartEngL2.push_back("POW_Pistol_Player");
			WeaponStartEngL2.push_back("CnC_POW_MineTimed_Player_02");
			WeaponStartEngL2.push_back("CnC_MineProximity_05");
		} 
		strncpy(WSO,LoadSettingString("WeaponStartOther","DefaultOther"),100);
		if (stricmp(WSO,"ERROR") != 0)
		{
			for (int z = 1; z <= 999; z++)
			{
				char key[3], value[256];
				if (z < 10) sprintf(key,"0%d",z);
				else sprintf(key,"%d",z);
				getProfileString(WSO,key,"NULL",value,256,"ssaow.ini");
				if (stricmp(value,"NULL") == 0) z = 1000;
				else WeaponStartOther.push_back(value);
			}
		}
		if (WeaponStartOther.empty())
		{
			WeaponStartOther.push_back("CnC_POW_MineTimed_Player_01");
			WeaponStartOther.push_back("POW_Pistol_Player");
		}		


		Vector3 loc; loc.X = 0.0f; loc.Y = 0.0f; loc.Z = 0.0f;
		GameObject *temp = Commands->Create_Object("Invisible_Object",loc);
		if (Settings->Weather) Commands->Attach_Script(temp,"KAK_Random_Weather","");
		Commands->Attach_Script(temp,"KAK_Disable_List","");
		Commands->Attach_Script(temp,"MDB_Manager","");

		bool PSet_Refill = Settings->CombatRefill;
		Settings->CombatRefill = LoadSetting("BlockCombatRefills",0);
		if (PSet_Refill != Settings->CombatRefill && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		if (Settings->CombatRefill) Settings->RefillTime = LoadSettingInt("RefillTime",5);
		bool PSet_DisBeac = Settings->DisableBeacons;
		Settings->DisableBeacons = LoadSetting("DisableBeacons",0);
		if (PSet_DisBeac != Settings->DisableBeacons && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_InvBuild = Settings->InvinBuild;
		Settings->InvinBuild = LoadSetting("InvincibleBuildings",0);
		if (PSet_InvBuild != Settings->InvinBuild && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		bool PSet_VehOwn = Settings->EnableVehOwn;
		Settings->EnableVehOwn= LoadSetting("EnableVehicleOwnership");
		if (PSet_VehOwn != Settings->EnableVehOwn && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		if (strcmp(LoadSettingString("SpawnCharNod","CnC_Nod_MiniGunner_0"),Get_Spawn_Char(0)) != 0) {
			if (!ShowSetChangeMess) { 
				ShowSetChangeMess = true;
				FDSMessage("New settings detected and loaded!","_GENERAL");
			}
			Change_Spawn_Char(0,LoadSettingString("SpawnCharNod","CnC_Nod_MiniGunner_0"));
		}

		if (strcmp(LoadSettingString("SpawnCharGDI","CnC_GDI_MiniGunner_0"),Get_Spawn_Char(1)) != 0) {
			if (!ShowSetChangeMess) { 
				ShowSetChangeMess = true;
				FDSMessage("New settings detected and loaded!","_GENERAL");
			}
			Change_Spawn_Char(1,LoadSettingString("SpawnCharGDI","CnC_GDI_MiniGunner_0"));
		}

		if (Settings->GameMode == 3 || Settings->GameMode == 4) {
			Change_Spawn_Char(0,"CnC_Nod_MiniGunner_2SF");
			Change_Spawn_Char(1,"CnC_GDI_MiniGunner_2SF");
		}

		int PSet_FT = Settings->ForceTeam;
		Settings->ForceTeam = LoadSettingInt("ForceTeam",-1);
		if (PSet_FT != Settings->ForceTeam && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		bool PSet_BWD = Settings->BWDetector;
		Settings->BWDetector = LoadSetting("EnableBWDetector",1);
		if (PSet_BWD != Settings->BWDetector && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}
		
		int PSet_BWDF = Settings->BWDefault;
		Settings->BWDefault = LoadSettingInt("BWDefault",56000);
		if (PSet_BWDF != Settings->BWDefault && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		bool PSet_BWDK = Settings->BWPunishKick;
		Settings->BWPunishKick = LoadSetting("KickBWExploiters",1);
		if (PSet_BWDK != Settings->BWPunishKick && !ShowSetChangeMess)
		{
			ShowSetChangeMess = true;
			FDSMessage("New settings detected and loaded!","_GENERAL");
		}

		crate_init();
		if (Settings->Gamelog) Gamelog_Init();

	}
	else
	{
		#ifdef WIN32
		char ObjectsType[10],ObjectsType2[10],ObjectsFile[20];
		getProfileString("General","ObjectsFile","aow",ObjectsType2,10,"ssaow.ini");
		getProfileString(The_Game()->MapName,"ObjectsFile",ObjectsType2,ObjectsType,10,"ssaow.ini");
		sprintf(ObjectsFile,"objects.%s",ObjectsType);
		int FID = Commands->Text_File_Open(ObjectsFile);
		if (!FID) {
			char ObjectsMsg[200];
			sprintf(ObjectsMsg,"Failed to load %s file for map %s. Defaulting to objects.aow.",ObjectsFile,The_Game()->MapName);
			FDSMessage(ObjectsMsg,"_ERROR");
			sprintf(ObjectsType,"aow");
		}
		else {
			Commands->Text_File_Close(FID);
		}
		FID = Commands->Text_File_Open("objects.aow");
		if (!FID) {
			FDSMessage("Critical Error! Objects.aow file not found. Exiting FDS.","_ERROR");
			MessageBox(HWND_DESKTOP,"Objects.aow not found!","Critical SSAOW Error",MB_OK|MB_ICONEXCLAMATION);
			exit(1);
		}
		else {
			Commands->Text_File_Close(FID);
		}
		Change_Objects_File(ObjectsType);
		#endif
		char EndMsg[70],WinType[50];
		if (The_Game()->WinType == 3) sprintf(WinType,"Building Destruction");
		else if (The_Game()->WinType == 2) sprintf(WinType,"High score when time limit expired");
		else if (The_Game()->WinType == 4) sprintf(WinType,"Pedestal Beacon");
		else if (The_Game()->WinType == 0) sprintf(WinType,"Server Shutdown");
		else sprintf(WinType,"Unknown");
		sprintf(EndMsg,"Current game on map %s has ended. Game was won by %s by %s.",CurrMap,The_Game()->WinnerID==0?"Nod":"GDI",WinType);
		FDSMessage(EndMsg,"_GENERAL");
		if (Settings->Gamelog) Gamelog_Gameover(WinType);
		SvSKillMsg.erase(SvSKillMsg.begin(),SvSKillMsg.end());
		VvSKillMsg.erase(VvSKillMsg.begin(),VvSKillMsg.end());
		DisableList.erase(DisableList.begin(),DisableList.end());
		WeaponStartEngL1.erase(WeaponStartEngL1.begin(),WeaponStartEngL1.end());
		WeaponStartEngL2.erase(WeaponStartEngL2.begin(),WeaponStartEngL2.end());
		WeaponStartOther.erase(WeaponStartOther.begin(),WeaponStartOther.end());
		Gameover = false;
		CrateExists = false;
	}
}


void VehicleOwner(int ID,int Type) {
	if (Settings->EnableVehOwn)
	{
		char message[512],params[100];
		GameObject *Own = Commands->Find_Object(ID);
		if (Commands->Get_ID(Own) == 0 || !Own) return;
		if (Type == 1)
		{
			if (Get_Vehicle(Own) == 0)
			{
				sprintf(message,"ppage %d Du musst im Auto sein, um das Kommando zu nutezn.",Get_Player_ID(Own));
			}
			else if (Get_Vehicle_Occupant(Get_Vehicle(Own),0) != Own)
			{
				sprintf(message,"ppage %d Geht nicht, denn Du bist nicht der Fahrer.",Get_Player_ID(Own));
			}
			else if (Get_Veh_Owner(Get_Vehicle(Own)) > 0)
			{
				sprintf(message,"ppage %d Das Auto ist schon an %s gebunden.",Get_Player_ID(Own),Get_Player_Name(Commands->Find_Object(Get_Veh_Owner(Get_Vehicle(Own)))));
			}
			else
			{
				if (Find_My_Veh(Own) != 0) Commands->Send_Custom_Event(Own,Find_My_Veh(Own),1111,0,0);
				sprintf(params,"%d,%d",ID,Commands->Get_Player_Type(Own));
				Commands->Attach_Script(Get_Vehicle(Own),"MDB_Vehicle_Owner",params);
				sprintf(message,"ppage %d Dein Auto wurde an dich gebunden, alle frheren Autos von dir sind nun frei.",Get_Player_ID(Own));
			}
		}
		else if (Type == 2)
		{
			if (Find_My_Veh(Own) == 0)
			{
				sprintf(message,"ppage %d Dafr musst Du ein Auto an dich binden.",Get_Player_ID(Own));
			}
			else
			{
				Commands->Send_Custom_Event(Own,Find_My_Veh(Own),1111,0,0);
				sprintf(message,"ppage %d Dein Auto ist frei fr jeden.",Get_Player_ID(Own));
			}
		}
		else if (Type == 3)
		{
			if (Find_My_Veh(Own) == 0)
			{
				sprintf(message,"ppage %d Dafr musst Du ein Auto an dich binden.",Get_Player_ID(Own));
			}
			else
			{
				Commands->Send_Custom_Event(Own,Find_My_Veh(Own),1112,0,0);
				sprintf(message,"ppage %d Zentralverriegelung geschlossen.",Get_Player_ID(Own));
			}
		}
		else if (Type == 4)
		{
			if (Find_My_Veh(Own) == 0)
			{
				sprintf(message,"ppage %d Dafr musst Du ein Auto an dich binden.",Get_Player_ID(Own));
			}
			else
			{
				Commands->Send_Custom_Event(Own,Find_My_Veh(Own),1113,0,0);
				sprintf(message,"ppage %d Auto aufgeschlossen, jeder kann rein.",Get_Player_ID(Own));
			}
		}
		else if (Type == 5)
		{
			if (Get_Vehicle(Own) == 0)
			{
				sprintf(message,"ppage %d Dafr musst Du in einem Auto sitzen.",Get_Player_ID(Own));
			}
			else if (Get_Vehicle_Occupant(Get_Vehicle(Own),0) != Own)
			{
				sprintf(message,"ppage %d Geht nicht, denn Du bist net der Fahrer.",Get_Player_ID(Own));
			}
			else if (Get_Veh_Owner(Get_Vehicle(Own)) > 0)
			{
				sprintf(message,"ppage %d Das Auto ist schon an %s gebunden.",Get_Player_ID(Own),Get_Player_Name(Commands->Find_Object(Get_Veh_Owner(Get_Vehicle(Own)))));
			}
			else
			{
				if (Find_My_Veh(Own) != 0) Commands->Send_Custom_Event(Own,Find_My_Veh(Own),1111,0,0);
				sprintf(params,"%d,%d",ID,Commands->Get_Player_Type(Own));
				Commands->Attach_Script(Get_Vehicle(Own),"MDB_Vehicle_Owner",params);
				Commands->Send_Custom_Event(Own,Get_Vehicle(Own),1112,0,0);
				sprintf(message,"ppage %d Dein Auto ist nun an dich gebunden und die Zentralverriegelung ist zu.",Get_Player_ID(Own));
			}
		}
		else if (Type == 7)
		{
			if (Find_My_Veh(Own) == 0) 
			{
				sprintf(message,"ppage %d Dafr musst Du ein Auto an dich binden.",Get_Player_ID(Own));
			}
			else
			{
				Force_Occupant_Exit(Find_My_Veh(Own),0);
				sprintf(message,"ppage %d Der Arsch auf dem Fahrersitz deines Autos wurde gefeuert.",Get_Player_ID(Own),1);
			}
		}
		if (message) Console_Input(message);
	}
	if (Type == 6)
	{
		char message[512];
		int Team = Commands->Get_Player_Type(Commands->Find_Object(ID));
		sprintf(message,"ppage %d Fernzuender: %d - Tretminen: %d - Gesamt: %d - Limit: %d",Get_Player_ID(Commands->Find_Object(ID)),Get_C4_Count_Remote(Team),Get_C4_Count_Proximity(Team),Get_C4_Count_Remote(Team)+Get_C4_Count_Proximity(Team),Get_Mine_Limit());
		Console_Input(message);
	}
	return;
}

const char *WideCharToChar(const wchar_t *wcs);
void Chat(int ID, int Type, const wchar_t *Msg) {
	if (Type == 2) return;
	if (Settings->Gamelog && Settings->NewGamelog) Gamelog_Chat_Hook(ID,Type,Msg);
	if (Type == 1)
	{
		const char *Msg2 = WideCharToChar(Msg);
		if (stricmp(Msg2,"!bind") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),1);
		}
		else if (stricmp(Msg2,"!unbind") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),2);
		}
		else if (stricmp(Msg2,"!lock") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),3);
		}
		else if (stricmp(Msg2,"!unlock") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),4);
		}
		else if (stricmp(Msg2,"!bl") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),5);
		}
		else if (stricmp(Msg2,"!c4") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),6);
		}
		else if (stricmp(Msg2,"!vkick") == 0)
		{
			VehicleOwner(Commands->Get_ID(Get_GameObj(ID)),7);
		}
	}
}

const char *GetIconBone(const char *Preset, int IconNum)
{
	if (IconNum == 1)
	{
		if (strstr(Preset,"CnC_Nod_Buggy")) return "muzzlea0";
		else if (strstr(Preset,"CnC_Nod_APC")) return "barrel";
		else if (strstr(Preset,"CnC_Nod_Mobile_Artillery")) return "muzzlea0";
		else if (strstr(Preset,"CnC_Nod_Light_Tank")) return "muzzlea0";
		else if (strstr(Preset,"CnC_Nod_Flame_Tank")) return "muzzlea0";
		else if (strstr(Preset,"CnC_Nod_Apache")) return "muzzleb0";
		else if (strstr(Preset,"CnC_GDI_Humm-vee")) return "muzzlea0";
		else if (strstr(Preset,"CnC_GDI_APC")) return "muzzlea0";
		else if (strstr(Preset,"CnC_GDI_MRLS")) return "muzzlea0";
		else if (strstr(Preset,"CnC_GDI_Medium_Tank")) return "muzzlea0";
		else if (strstr(Preset,"CnC_GDI_Mammoth_Tank")) return "muzzleb0";
		else if (strstr(Preset,"CnC_GDI_Orca")) return "muzzlea0";
	}
	else if (IconNum == 2)
	{
		if (strstr(Preset,"CnC_Nod_Flame_Tank")) return "muzzlea1";
		else if (strstr(Preset,"CnC_Nod_Apache")) return "muzzleb1";
		else if (strstr(Preset,"CnC_GDI_MRLS")) return "barrel";
		else if (strstr(Preset,"CnC_GDI_Mammoth_Tank")) return "muzzleb1";
		else if (strstr(Preset,"CnC_GDI_Orca")) return "muzzlea1";
	}
	return NULL;
}

bool IsSniper(GameObject *obj)
{
	const char *Preset = Commands->Get_Preset_Name(obj);
	if (Settings->GameMode == 3)
	{
		if (strstr(Preset,"CnC_Nod_Minigunner_3Boss")) return true;
		else if (strstr(Preset,"CnC_Nod_MiniGunner_3Boss")) return true;
		else if (strstr(Preset,"CnC_Nod_Minigunner_2SF")) return true;
		else if (strstr(Preset,"CnC_GDI_MiniGunner_3Boss")) return true;
		else if (strstr(Preset,"CnC_GDI_MiniGunner_2SF")) return true;
	}
	else if (Settings->GameMode == 4)
	{
		if (strstr(Preset,"CnC_Nod_Minigunner_2SF")) return true;
		else if (strstr(Preset,"CnC_GDI_MiniGunner_2SF")) return true;
	}
	return false;
}

void M00_BUILDING_EXPLODE_NO_DAMAGE_DAK::Created(GameObject *obj) {

	/*
	if (FirstObject == true) {
		FirstObject = false;
		RecognizeMap(true);
	}*/
	Remove_Duplicate_Script(obj,"M00_BUILDING_EXPLODE_NO_DAMAGE_DAK");
	ReportDamage = true;
	B2BCount = 0;
	LastID = 0;

	Commands->Start_Timer(obj,this,5,10);

	if (Settings->InvinBuild) {
		Set_Max_Health(obj,2000);
		Set_Max_Shield_Strength(obj,2000);
		Commands->Set_Shield_Type(obj,"Blamo");
	}
	if (Settings->GameMode == 5 && Is_VehicleFactory(obj)) {
		Commands->Set_Health(obj,0);
		Commands->Set_Shield_Strength(obj,0);
	}
	if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
		if (Is_SoldierFactory(obj)) {
			Set_Max_Health(obj,2000);
			Set_Max_Shield_Strength(obj,2000);
			Commands->Set_Shield_Type(obj,"Blamo");
		}
		else {
			Commands->Set_Health(obj,0);
			Commands->Set_Shield_Strength(obj,0);
		}
	}
	Commands->Start_Timer(obj,this,Commands->Get_Random(60.0f,180.0f),20);
	IsAlive = true;
	PlayHealth = true;
	OkHealth = false;
	PlayRepair = true;
}

void M00_BUILDING_EXPLODE_NO_DAMAGE_DAK::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if ((Commands->Get_ID(damager) != 0 && !Settings->InvinBuild) && (Settings->GameMode == 1 || Settings->GameMode == 5)) {
		if (damage > 0) {
			if (Settings->ReportBuildingDamage && ReportDamage) {
				ReportDamage = false;
				char DamageMsg[512];
				sprintf(DamageMsg,"%s steht unter feindlichem Beschuss!",Translate_Preset(obj));
				FDSMessage(DamageMsg,"_BUILDING");
				Commands->Start_Timer(obj,this,Settings->BuildingDamageInt,1);
			}
			if (!OkHealth) OkHealth = true;
			if (PlayHealth && (Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj)) <= ((Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj)) * 0.2f))
			{
				PlayHealth = false;
				char *Announcement = "ERROR";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower")) Announcement = "M00BGAT_HLTH0001I1EVAG_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks")) Announcement = "M00BGIB_HLTH0001I1EVAG_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory")) Announcement = "M00BGWF_HLTH0001I1EVAG_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant")) Announcement = "M00BGPP_HLTH0001I1EVAG_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery")) Announcement = "M00BGTR_HLTH0001I1EVAG_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk")) Announcement = "M00BNOL_HLTH0001I1EVAN_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod")) Announcement = "M00BNHN_HLTH0001I1EVAN_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip")) Announcement = "M00BNAF_HLTH0001I1EVAN_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant")) Announcement = "M00BNPP_HLTH0001I1EVAN_SND.wav";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery")) Announcement = "M00BNTR_HLTH0001I1EVAN_SND.wav";
				if (IsAlive)
				{
					Commands->Create_2D_Sound(Announcement);
					Commands->Start_Timer(obj,this,30.0f,22);
				}
			}
		}
		if ((Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj)) == (Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj)) && OkHealth)
		{
			OkHealth = false;
			if (PlayRepair)
			{
				PlayRepair = false;
				char *Announcement = "ERROR";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower")) Announcement = "M00BGAT_DSGN0007I1EVAG_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks")) Announcement = "M00BGIB_DSGN0008I1EVAG_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory")) Announcement = "M00BGWF_DSGN0009I1EVAG_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant")) Announcement = "M00BGPP_DSGN0009I1EVAG_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery")) Announcement = "M00BGTR_DSGN0009I1EVAG_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk")) Announcement = "M00BNOL_DSGN0008I1EVAN_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod")) Announcement = "M00BNHN_DSGN0016I1EVAN_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip")) Announcement = "M00BNAF_DSGN0010I1EVAN_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant")) Announcement = "M00BNPP_DSGN0010I1EVAN_SND";
				if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery")) Announcement = "M00BNTR_DSGN0010I1EVAN_SND";
				if (IsAlive)
				{
					Create_Sound_Team(Announcement,Commands->Get_Position(obj),obj,Get_Object_Type(obj));
					Commands->Start_Timer(obj,this,30.0f,23);
				}
			}
		}
	}
	if ((Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) && Is_SoldierFactory(obj)) {
		Commands->Set_Health(obj,2000);
		Commands->Set_Shield_Strength(obj,2000);
		Commands->Give_Points(damager,(float)(damage*-1.0),false);
		Commands->Give_Money(damager,(float)(damage*-1.0),false);
	}
	if (Settings->InvinBuild) {
		Commands->Set_Health(obj,2000);
		Commands->Set_Shield_Strength(obj,2000);
		Commands->Give_Points(damager,(float)(damage*-1.0),false);
		Commands->Give_Money(damager,(float)(damage*-1.0),false);
	}
}

void M00_BUILDING_EXPLODE_NO_DAMAGE_DAK::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1) ReportDamage = true;
	if (number == 20)
	{
		int RandomAnnouncement;
		char *Announcement = "ERROR";
		float Z = Commands->Get_Position(obj).Z;

		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,2);
			if (RandomAnnouncement == 1) Announcement = "M00BGAT_DSGN0001I1EVAG_SND";
			else Announcement = "M00BGAT_DSGN0003I1EVAG_SND";
			Z -= 17.0f;
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,5);
			if (RandomAnnouncement == 1) Announcement = "M00BGIB_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGIB_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGIB_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGIB_DSGN0004I1EVAG_SND";
			else Announcement = "M00BGIB_DSGN0005I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BGWF_DSGN0005I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGWF_DSGN0006I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGWF_DSGN0001I1EVAG_SND";
			else Announcement = "M00BGWF_DSGN0003I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,6);
			if (RandomAnnouncement == 1) Announcement = "M00BGPP_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGPP_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGPP_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGPP_DSGN0004I1EVAG_SND";
			else if (RandomAnnouncement == 5) Announcement = "M00BGPP_DSGN0005I1EEVAG_SND";
			else Announcement = "M00BGPP_DSGN0006I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,5);
			if (RandomAnnouncement == 1) Announcement = "M00BGTR_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGTR_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGTR_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGTR_DSGN0004I1EVAG_SND";
			else Announcement = "M00BGTR_DSGN0006I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BNOL_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNOL_DSGN0002I1EVAN_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNOL_DSGN0003I1EVAN_SND";
			else Announcement = "M00BNOL_DSGN0004I1EVAN_SND";
			Z += 12.0f;
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,2);
			if (RandomAnnouncement == 1) Announcement = "M00BNHN_DSGN0001I1EVAN_SND";
			else Announcement = "M00BNHN_DSGN0002I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,3);
			if (RandomAnnouncement == 1) Announcement = "M00BNAF_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNAF_DSGN0005I1EVAN_SND";
			else Announcement = "M00BNAF_DSGN0006I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,6);
			if (RandomAnnouncement == 1) Announcement = "M00BNPP_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNPP_DSGN0002I1EVAN_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNPP_DSGN0003I1EVAN_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BNPP_DSGN0004I1EVAN_SND";
			else if (RandomAnnouncement == 5) Announcement = "M00BNPP_DSGN0005I1EVAN_SND";
			else Announcement = "M00BNPP_DSGN0006I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery"))
		{
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BNTR_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNTR_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNTR_DSGN0003I1EVAG_SND";
			else Announcement = "M00BNTR_DSGN0004I1EVAG_SND";
		}
		if (IsAlive)
		{
			Commands->Create_Sound(Announcement,Commands->Get_Position(obj),obj);
			Commands->Start_Timer(obj,this,Commands->Get_Random(60.0f,180.0f),20);
		}
	}
	if (number == 22) {
		PlayHealth = true;
	}
	if (number == 23) {
		PlayRepair = true;
	}
	if (number == 10) {
	if (Settings->InvinBuild) {
		Set_Max_Health(obj,2000);
		Set_Max_Shield_Strength(obj,2000);
		Commands->Set_Shield_Type(obj,"Blamo");
	}
	if (Settings->GameMode == 5 && Is_VehicleFactory(obj)) {
		Commands->Set_Health(obj,0);
		Commands->Set_Shield_Strength(obj,0);
	}
	if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
		if (Is_SoldierFactory(obj)) {
			Set_Max_Health(obj,2000);
			Set_Max_Shield_Strength(obj,2000);
			Commands->Set_Shield_Type(obj,"Blamo");
		}
		else {
			Commands->Set_Health(obj,0);
			Commands->Set_Shield_Strength(obj,0);
		}
	}
	}
}

void M00_BUILDING_EXPLODE_NO_DAMAGE_DAK::Killed(GameObject *obj, GameObject *shooter)
{
	if (Commands->Get_ID(shooter) != 0)
	{
		if (Settings->ReportBuildingDeath)
		{
			char KillMsg[512];
			sprintf(KillMsg,"%s zerstoert -bedankt euch bei %s (%s)",Translate_Preset(obj),Get_Player_Name(shooter),Get_Preset_Info(shooter));
			FDSMessage(KillMsg,"_BUILDING");
		}
		if (Settings->BuildingDeathRewardPage)
		{
			char RewardPage[100];
			sprintf(RewardPage,"ppage %d %s zerstoert. Gute Arbeit Soldat!",Get_Player_ID(shooter),Translate_Preset(obj));
			Console_Input(RewardPage);
		}
		if (Settings->GameMode == 1) Commands->Set_Is_Visible(shooter,true);
	}
	if (Settings->GameMode == 5) {
		if (Get_Building_Count_Team(Get_Object_Type(obj)) == 0 && !Gameover) {
			Gameover = true;
			Commands->Set_Health(Find_Vehicle_Factory(Get_Object_Type(obj)),1);
			Commands->Apply_Damage(Find_Vehicle_Factory(Get_Object_Type(obj)),9999,"BlamoKiller",0);
		}
	}

	IsAlive = false;
}

void M00_Disable_Transition::Created(GameObject *obj)
{
	Commands->Enable_Vehicle_Transitions(obj,false);
	if (strstr(Commands->Get_Preset_Name(obj),"Nod_Turret_MP") || strstr(Commands->Get_Preset_Name(obj),"GDI_Guard_Tower")) {
		if (Settings->GameMode != 1) {
			Commands->Destroy_Object(obj);
		}
		else {
			Commands->Start_Timer(obj,this,5.0f,1);
			PlayDamage = true;
		}
	}
	if (strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
		PlayDamage = true;
		if (Settings->DisableRefineries) {
			Commands->Destroy_Object(obj);
		}
		if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
			Set_Max_Health(obj,2000);
			Set_Max_Shield_Strength(obj,2000);
			Commands->Set_Shield_Type(obj,"Blamo");
			//Commands->Start_Timer(obj,this,10.0f,10);
		}
	}
}

void M00_Disable_Transition::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if (damage > 0 && (Settings->GameMode == 1 || Settings->GameMode == 5))
	{
		if (strstr(Commands->Get_Preset_Name(obj),"Harvester") && PlayDamage)
		{
			PlayDamage = false;
			if (strstr(Commands->Get_Preset_Name(obj),"GDI"))
			{
				Create_2D_Sound_Team("M00VGHV_TFEA0002I1EVAN_SND",0);
				Create_2D_Sound_Team("M00VGHV_TFEA0001I1EVAG_SND",1);
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"Nod")) 
			{
				Create_2D_Sound_Team("M00VNHV_TFEA0001I1EVAG_SND",1);
				Create_2D_Sound_Team("M00VNHV_TFEA0002I1EVAN_SND",0);
			}
			Commands->Start_Timer(obj,this,30.0f,20);
		}
		if (strstr(Commands->Get_Preset_Name(obj),"Nod_Turret_MP") && PlayDamage)
		{
			PlayDamage = false;
			Create_2D_Sound_Team("M00BNTU_TDFE0001I1EVAN_SND",0);
			Create_2D_Sound_Team("M00BNTU_TDFE0002I1EVAG_SND",1);
			Commands->Start_Timer(obj,this,30.0f,20);
		}
		if (strstr(Commands->Get_Preset_Name(obj),"GDI_Guard_Tower") && PlayDamage)
		{
			PlayDamage = false;
			Commands->Create_2D_Sound("M00BNTU_TDFE0001I1EVAG_SND");
			Commands->Start_Timer(obj,this,30.0f,20);
		}
	}
	if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
		Commands->Set_Health(obj,2000);
		Commands->Set_Shield_Strength(obj,2000);
		Commands->Give_Points(damager,(float)(damage*-0.04),false);
	}
}

void M00_Disable_Transition::Killed(GameObject *obj, GameObject *shooter)
{
	if (strstr(Commands->Get_Preset_Name(obj),"Nod_Turret_MP"))
	{
		GameObject *DestroyedTurret = Commands->Create_Object("Nod_Turret_Destroyed",Commands->Get_Position(obj));
		Commands->Set_Facing(DestroyedTurret,Commands->Get_Facing(obj));
	}
}

void M00_Disable_Transition::Timer_Expired(GameObject *obj, int number)
{
	if (Settings->DisableBaseDefenses && number == 1)
	{
		Commands->Apply_Damage(obj,99999,"Death",false);
		Commands->Start_Timer(obj,this,5.0f,1);
	}
	else if (number == 20)
	{
		PlayDamage = true;
	}
	else if (number == 10)
	{
		Commands->Set_Model(obj,"null");
		Vector3 Pos = Commands->Get_Position(obj);
		Pos.Z -= 2.0f;
		Commands->Set_Position(obj,Pos);
	}
}

void M00_GrantPowerup_Created::Created(GameObject *obj) {

	/*
	if (FirstObject == true) {
		FirstObject = false;
		RecognizeMap(true);
	}*/

	if (stricmp(Get_Parameter("WeaponDef"),"POW_Pistol_Player") == 0)
	{
		int printable_nickname=1;
		int i;
		
		if (Commands->Get_ID(obj) == 0 || !obj)
		{
			return;
		}
		

		int x = strlen(Get_Player_Name(obj));
		
		for (i = x-1; i >= 0; i--)
		{
			if (!isprint(Get_Player_Name(obj)[i]) )
			{
				printable_nickname=0;
				break;
			}
		}	
		for (i = x-1; i >= 0; i--)
		{
			if (Get_Player_Name(obj)[i] == -1 )
			{
				printable_nickname=0;
				break;
			}
		}	
		if (x == 0 )
		{
			printable_nickname=0;
		}
		if ( (stricmp(ServerName,Get_Player_Name(obj)) == 0) || (printable_nickname == 0) )
		{
			Commands->Clear_Weapons(obj);
			Commands->Apply_Damage(obj,9999,"Death",false);
			return;
		}

		if (Settings->ForceTeam != -1) {
			if (Commands->Get_Player_Type(obj) != Settings->ForceTeam) {
				Change_Team(obj,Settings->ForceTeam);
				return;
			}
		}
		
		if (Settings->GameMode != 1)
		{
			Commands->Set_Is_Visible(obj,false);
		}
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt1,h_a_a0a0_l12");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt2,H_A_a0a0_L22");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt3,H_A_a0a0_L23");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt4,H_A_a0a0_L24");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt5,H_A_a0a0_L25");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt6,H_A_a0a0_L58");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt7,H_A_cresentkick");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt8,H_A_sidekick");
		Commands->Attach_Script(obj,"MDB_Taunt_Key","Taunt9,H_A_punchcombo");
		Commands->Attach_Script(obj,"MDB_WriteLog_Key","VoteYes,!vote yes,0");
		Commands->Attach_Script(obj,"MDB_WriteLog_Key","VoteNo,!vote no,0");
		if (Settings->EnableVehOwn) {
			Commands->Attach_Script(obj,"MDB_VehOwn_Key","VehBind,1");
			Commands->Attach_Script(obj,"MDB_VehOwn_Key","VehBL,5");
		}
		Commands->Attach_Script(obj,"MDB_VehOwn_Key","C4Count,6");

		WasKilled = false;
		if ((Settings->GameMode == 3 || Settings->GameMode == 4) && (!IsSniper(obj)))
		{
			char Message[200];
			Commands->Give_Money(obj,(float)Get_Character_Price(Commands->Get_Preset_Name(obj)),false);
			sprintf(Message,"ppage %d Hier rennt ein Snipermod. Kauf nur Scharfschtzen bitte.",Get_Player_ID(obj),Settings->GameMode==3?"Snipers Only":"500 Snipers Only");
			Console_Input(Message);
			Change_Character(obj,Get_Spawn_Char(Commands->Get_Player_Type(obj)));
			return;
		}
		if (IsDisabled(obj)) {
			Commands->Give_Money(obj,Get_Character_Price(Commands->Get_Preset_Name(obj)),false);
			char pagemsg[256];
			sprintf(pagemsg,"pamsg %d Vergiss es Du Zwerg. Einheit nicht verfgbar. (%s)",Get_Player_ID(obj),Translate_Preset(obj));
			Console_Input(pagemsg);
			Change_Character(obj,Get_Spawn_Char(Commands->Get_Player_Type(obj)));
			return;
		}
		if (WeaponStartEngL1.empty() )
		{
			WeaponStartEngL1.push_back("CnC_POW_MineTimed_Player_01");
			WeaponStartEngL1.push_back("POW_Pistol_Player");
			WeaponStartEngL1.push_back("CnC_POW_MineRemote_02");
		}
		if (WeaponStartEngL2.empty() )
		{

			WeaponStartEngL2.push_back("CnC_POW_MineRemote_02");
			WeaponStartEngL2.push_back("POW_Pistol_Player");
			WeaponStartEngL2.push_back("CnC_POW_MineTimed_Player_02");
			WeaponStartEngL2.push_back("CnC_MineProximity_05");
		} 
		if (WeaponStartOther.empty() )
		{
			WeaponStartOther.push_back("CnC_POW_MineTimed_Player_01");
			WeaponStartOther.push_back("POW_Pistol_Player");
		}		
		if (stricmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_0") == 0 || stricmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Engineer_0") == 0)
		{
			std::vector<std::string>::iterator it;
			for (it = WeaponStartEngL1.begin(); it != WeaponStartEngL1.end(); ++it)
			{ 
				Commands->Give_Powerup(obj,(*it).c_str(),true);
			}
		}
		else if (stricmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_2SF") == 0 || stricmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Technician_0") == 0)
		{
			std::vector<std::string>::iterator it;
			for (it = WeaponStartEngL2.begin(); it != WeaponStartEngL2.end(); ++it)
			{
				Commands->Give_Powerup(obj,(*it).c_str(),true);
			}
		}
		else
		{
			std::vector<std::string>::iterator it;
			for (it = WeaponStartOther.begin(); it != WeaponStartOther.end(); ++it)
			{
				if (Settings->GameMode == 3 || Settings->GameMode == 4)
				{
					if (!strstr((*it).c_str(),"Mine") && !strstr((*it).c_str(),"mine") && !strstr((*it).c_str(),"C4") && !strstr((*it).c_str(),"c4"))
					{
						Commands->Give_Powerup(obj,(*it).c_str(),true);
					}
				}
				else
				{
					Commands->Give_Powerup(obj,(*it).c_str(),true);
				}
			}
		}
		WasKilled = false;
		FullDeath = false;
		TotalHealth = (Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj));
		SpawnPos = Commands->Get_Position(obj);
		AfkDetect = 0;
		Commands->Start_Timer(obj,this,60,8);
		if (Settings->ShowPlayerPurchase)
		{
			char PurchaseMsg[512];
			sprintf(PurchaseMsg,"%s kaufte eine(n) %s",Get_Player_Name(obj),Translate_Preset(Get_Vehicle_Return(obj)));
			FDSMessage(PurchaseMsg,"_PURCHASE");
		}

		if (Settings->CombatRefill) Attach_Script_Once(obj,"MDB_Block_Refill","0");
	}
}

void M00_GrantPowerup_Created::Destroyed(GameObject *obj)
{
	if (Settings->DestroyPlayerVeh && Get_Vehicle(obj) != 0) Commands->Apply_Damage(Get_Vehicle(obj),99999,"BlamoKiller",false);
	if (Settings->DropWeapons && WasKilled)
	{
		WasKilled = false;
		DeathPlace = Commands->Get_Position(obj);
		int RandomNum = Commands->Get_Random_Int(1,5);
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_0"))
		{
			BackpackScript = Commands->Create_Object("POW_AutoRifle_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_0"))
		{
			BackpackScript = Commands->Create_Object("POW_AutoRifle_Player_Nod",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_1Off"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_Chaingun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_MiniGunner_1Off"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_Chaingun_Player_Nod",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_1Off"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_ChemSprayer_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_0"))
		{
			BackpackScript = Commands->Create_Object("POW_Flamethrower_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Grenadier_0"))
		{
			BackpackScript = Commands->Create_Object("POW_GrenadeLauncher_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_LaserChaingun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_LaserRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Technician_0"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_RepairGun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_RepairGun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Engineer_0"))
		{
			BackpackScript = Commands->Create_Object("CnC_POW_MineRemote_02",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_0"))
		{
			BackpackScript = Commands->Create_Object("CnC_POW_MineRemote_02",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Sydney_PowerSuit"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("POW_PersonalIonCannon_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_3Boss"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("POW_Railgun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_3Boss"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("POW_RamjetRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_3Boss"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("POW_RamjetRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_1Off"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_RocketLauncher_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_1Off"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_RocketLauncher_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("CnC_POW_RocketLauncher_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_0"))
		{
			BackpackScript = Commands->Create_Object("POW_Shotgun_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_0"))
		{
			BackpackScript = Commands->Create_Object("POW_Shotgun_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player_Nod",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Sydney"))
		{
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3)
			{
				BackpackScript = Commands->Create_Object("POW_TiberiumAutoRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player_Nod",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Grenadier_2SF"))
		{
			if (RandomNum == 1 || RandomNum == 2)
			{
				BackpackScript = Commands->Create_Object("POW_TiberiumFlechetteGun_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Ignatio_Mobius"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("POW_VoltAutoRifle_Player",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_3Boss"))
		{
			if (RandomNum == 1)
			{
				BackpackScript = Commands->Create_Object("CnC_POW_VoltAutoRifle_Player_Nod",DeathPlace);
			}
			else
			{
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else
		{
			BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
		}
		Commands->Attach_Script(BackpackScript,"KAK_Drop_Weapon","");
	}
	if (Find_My_Veh(obj) != 0) {
		Commands->Send_Custom_Event(obj,Find_My_Veh(obj),1111,0,0);
	}
}

void M00_GrantPowerup_Created::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if (damage == TotalHealth) FullDeath = true;
}

void M00_GrantPowerup_Created::Killed(GameObject *obj, GameObject *shooter)
{
	if (stricmp(Get_Parameter("WeaponDef"),"POW_Pistol_Player") == 0)
	{
		DeathPlace = Commands->Get_Position(obj);
		WasKilled = true;
		if (Find_My_Veh(obj) != 0)
		{
			Commands->Send_Custom_Event(obj,Find_My_Veh(obj),1111,0,0);
			char Message[100];
			sprintf(Message,"ppage %d Dein Auto is wieder frei, weil Du tot bist.",Get_Player_ID(obj));
			Console_Input(Message);
		}
		if (Settings->ShowPlayerKillMessage)
		{
			if (Commands->Get_ID(shooter) == 0)
			{
				char KillMsg[512];
				sprintf(KillMsg,"%s wurde gefickt (%s)",Get_Player_Name(obj),Get_Preset_Info(obj));
				FDSMessage(KillMsg,"_PLAYERKILL");

			}
			else if (Commands->Get_ID(obj) == Commands->Get_ID(shooter))
			{
				char KillMsg[512];
				sprintf(KillMsg,"%s machte Selbstmord (%s)",Get_Player_Name(obj),Get_Preset_Info(obj));
				FDSMessage(KillMsg,"_PLAYERKILL");

			}
			else if (!Is_Soldier(shooter))
			{
				char KillMsg[512];
				sprintf(KillMsg,"Der %s killte %s (%s)",Translate_Preset(shooter),Get_Player_Name(obj),Get_Preset_Info(obj));
				FDSMessage(KillMsg,"_PLAYERKILL");
			}
			else
			{
				std::string killer(Get_Player_Name(shooter)),
					killed(Get_Player_Name(obj)),
					killerpreset(Get_Preset_Info(shooter)),
					killedpreset(Get_Preset_Info(obj));
				if (Get_Vehicle(shooter) != 0)
				{
					std::string KillMsg(VvSKillMsg[Commands->Get_Random_Int(0,VvSKillMsgTotal)]);
					unsigned int n;
					while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
					while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
					while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
					while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);
					FDSMessage(KillMsg.c_str(),"_PLAYERKILL");

				}
				else
				{
					std::string KillMsg(SvSKillMsg[Commands->Get_Random_Int(0,SvSKillMsgTotal)]);
					unsigned int n;
					while((n = KillMsg.find("<killer>")) != std::string::npos) KillMsg.replace(n,8,killer);
					while((n = KillMsg.find("<killed>")) != std::string::npos) KillMsg.replace(n,8,killed);
					while((n = KillMsg.find("<killerpreset>")) != std::string::npos) KillMsg.replace(n,14,killerpreset);
					while((n = KillMsg.find("<killedpreset>")) != std::string::npos) KillMsg.replace(n,14,killedpreset);
					FDSMessage(KillMsg.c_str(),"_PLAYERKILL");
				}
			}
		} 
	}
}

void M00_GrantPowerup_Created::Timer_Expired(GameObject *obj, int number) {
	if (number == 8)
	{
		DidEvent = false;
		if (SpawnPos.X >= (Commands->Get_Position(obj).X - 5.0f) && SpawnPos.X <= (Commands->Get_Position(obj).X + 5.0f) &&
			SpawnPos.Y >= (Commands->Get_Position(obj).Y - 5.0f) && SpawnPos.Y <= (Commands->Get_Position(obj).Y + 5.0f) &&
			SpawnPos.Z >= (Commands->Get_Position(obj).Z - 5.0f) && SpawnPos.Z <= (Commands->Get_Position(obj).Z + 5.0f) && 
			DidEvent == false && Settings->AFKKick == true && Tally_Team_Size(Commands->Get_Player_Type(obj)) > 1)
		{
			AfkDetect++;
			if (AfkDetect >= Settings->AFKWait)
			{
				char message[50], message2[50], FDSM[100];
				sprintf(message,"kick %s",Get_Player_Name(obj));
				sprintf(message2,"allow %s",Get_Player_Name(obj));
				sprintf(FDSM,"%s wurde wegen AFK gekickt",Get_Player_Name(obj));
				Console_Input(message);
				Console_Input(message2);
				FDSMessage(FDSM,"_ALERT");
			}
			else if (AfkDetect >= (Settings->AFKWait - 1))
			{
				char message[256], FDSM[100];
				sprintf(message,"ppage %d %s",Get_Player_ID(obj),Settings->AFKPageMessage);
				sprintf(FDSM,"%s wurde wegen AFK gewarnt",Get_Player_Name(obj));
				Console_Input(message);
				FDSMessage(FDSM,"_ALERT");
			}
			DidEvent = false;
		}
		else DidEvent = true;
		if (DidEvent == true) AfkDetect = 0;
		SpawnPos = Commands->Get_Position(obj);
		Commands->Start_Timer(obj,this,60,8);
	}
}

void KAK_Drop_Weapon::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,8.0f,1);
	Commands->Start_Timer(obj,this,6.0f,2);
}

void KAK_Drop_Weapon::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == 1000000025)
	{
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_POW_MineRemote_02")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pac4_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_AutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwar_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_AutoRifle_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwar_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Chaingun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcg_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Chaingun_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcg_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_ChemSprayer_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcs_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Flamethrower_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwft_aqob0001i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_GrenadeLauncher_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwgl_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_LaserChaingun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwlc_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_LaserRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwlr_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RepairGun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrp_aqob0001i1evag_snd.wav");
		}						
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_PersonalIonCannon_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwpi_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Railgun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrg_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RamjetRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrj_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RocketLauncher_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrl_aqob0004i1evag_snd.wav");
		}	
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Shotgun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwps_aqob0004i1evag_snd.wav");
		}			
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_SniperRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwsr_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_SniperRifle_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwsr_aqob0004i1evag_snd.wav");
		}							
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_TiberiumAutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwtr_aqob0004i1evag_snd.wav");
		}							
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_TiberiumFlechetteGun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwtf_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_VoltAutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwvr_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_POW_VoltAutoRifle_Player_Nod"))
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwvr_aqob0004i1evag_snd.wav");
		}
	}
}

void KAK_Drop_Weapon::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Commands->Expire_Powerup(obj);
		Commands->Destroy_Object(obj);
	}
	else if (number == 2)
	{
		Commands->Create_Object("Spawner Created Special Effect",Commands->Get_Position(obj));
	}
}

void KAK_Beacon_Log::Created(GameObject *obj)
{
	IsDisarmed = false;
	char params[256];
	if (Settings->Gamelog && Settings->NewGamelog) {
		Attach_Script_Once(obj, "Gamelog_Beacon", "");
	}
	GameObject *Placer = Commands->Find_Closest_Soldier(Commands->Get_Position(obj),0,9999,true); //Get_Beacon_Planter(obj);
	sprintf(params,"%s,%d,%s",Commands->Get_Preset_Name(obj),Commands->Get_ID(obj),Get_Player_Name(Placer));
	InvisObjCont = Commands->Create_Object("Invisible_Object",Commands->Get_Position(obj));
	Commands->Attach_Script(InvisObjCont,"KAK_Beacon_Log_CreateControl",params);
	if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4 || Settings->DisableBeacons) {
		Commands->Destroy_Object(obj);
	}
}

void KAK_Beacon_Log::Destroyed(GameObject *obj)
{
	if (Commands->Get_ID(InvisObjCont) != 0) Commands->Destroy_Object(InvisObjCont);
}

void KAK_Beacon_Log::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if (damage < 0.0f)
	{
		Commands->Apply_Damage(obj,(damage * -1),"Shrapnel",false);
	}
}

void KAK_Beacon_Log::Killed(GameObject *obj, GameObject *shooter) {
if (IsDisarmed == false) {
 IsDisarmed = true;
 if (strstr(Commands->Get_Preset_Name(obj),"CnC_Beacon_IonCannon")) {
  char message[100];
  sprintf(message,"%s entschrfte den Ionenzielsucher.",Get_Player_Name(shooter));
  FDSMessage(message,"_BEACON");
 }
 else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Beacon_NukeStrike")) {
  char message[100];
  sprintf(message,"%s entschrfte den Nuklearzielsucher.",Get_Player_Name(shooter));
  FDSMessage(message,"_BEACON");
 }
}
}

void KAK_Beacon_Log_CreateControl::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,5,3);
	Commands->Start_Timer(obj,this,55,5);
}


void KAK_Beacon_Log_CreateControl::Timer_Expired(GameObject *obj, int number) {
if (number == 3) {
 if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_IonCannon")) {
  char message[256];
  sprintf(message,"%s aktivierte die Ionenkanone",Get_Parameter("Planter"));
  FDSMessage(message,"_BEACON");
  Commands->Start_Timer(obj,this,5,4);
 }
 else if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_NukeStrike")) {
  char message[256];
  sprintf(message,"%s aktivierte den Nuklearschlag",Get_Parameter("Planter"));
  FDSMessage(message,"_BEACON");
  Commands->Start_Timer(obj,this,5,4);
 }
}
else if (number == 4) {
 if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_IonCannon")) FDSMessage("Warnung - Ionenkanone schiesst bald","_BEACON");
 else if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_NukeStrike")) FDSMessage("Warning - Nuklearschlag erfolgt bald","_BEACON");
}
else if (number == 5) {
 if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_IonCannon")) FDSMessage("Ionenkanone hat zugeschlagen","_BEACON");
 else if (strstr(Get_Parameter("Beacon"),"CnC_Beacon_NukeStrike")) FDSMessage("Nuklearschlag ausgefuehrt","_BEACON");
}
}

void KAK_Beacon_Animation_Log::Created(GameObject *obj) {
if (strstr(Commands->Get_Preset_Name(obj),"Beacon_Ion_Cannon_Anim_Pre")) FDSMessage("Countdown laeuft, noch 10 Sekunden","_BEACON");
else if (strstr(Commands->Get_Preset_Name(obj),"Beacon_Nuke_Strike_Anim_Pre")) FDSMessage("Countdown laeuft, noch 10 Sekunden","_BEACON");
}

void KAK_Random_Weather::Created(GameObject *obj)
{
	Range = Commands->Get_Random(0,1);
	CurrentClouds = Commands->Get_Random(0,1);
	Commands->Set_Clouds(CurrentClouds,CurrentClouds,true);
	Commands->Start_Timer(obj,this,0.5f,0);
	CurrentWind = 0.0f;
}

void KAK_Random_Weather::Timer_Expired(GameObject *obj, int number)
{
	if (number == 0)
	{
		if (CurrentClouds < Range)
		{
			if ((CurrentClouds + 0.001f) >= Range) CurrentClouds = Range;
			else CurrentClouds += 0.001f;
		}
		else if (CurrentClouds > Range)
		{
			if ((CurrentClouds - 0.001f) <= Range) CurrentClouds = Range;
			else CurrentClouds -= 0.001f;
		}
		Commands->Set_Clouds(CurrentClouds,CurrentClouds,true);
		CurrentWind = 10 * CurrentClouds;
		Commands->Set_Wind(0.0f,CurrentWind,1.0f,true);
		if (stricmp(Settings->WeatherType,"Snow") == 0)
		{
			if (CurrentClouds >= 0.625f){
				CurrentSnow = (((8 * CurrentClouds) - 5) / 3);
				Commands->Set_Snow(CurrentSnow,CurrentSnow,true);
			}
			else Commands->Set_Snow(0.0f,0.0f,true);
		}
		else if (stricmp(Settings->WeatherType,"Ash") == 0) 
		{
			if (CurrentClouds >= 0.625f)
			{
				CurrentAsh = (((8 * CurrentClouds) - 5) / 3);
				Commands->Set_Ash(CurrentAsh,CurrentAsh,true);
			}
			else Commands->Set_Ash(0.0f,0.0f,true);
		}
		else
		{
			if (CurrentClouds >= 0.625f)
			{
				CurrentRain = ((1.875f * CurrentClouds) - 0.125f);
				Commands->Set_Rain(CurrentRain,CurrentRain,true);
			}
			else Commands->Set_Rain(0.0f,0.0f,true);

			if (CurrentClouds >= 0.875f)
			{
				CurrentLightning = (8 * (CurrentClouds + 0.125f)) - 8;
				Commands->Set_Lightning(CurrentLightning,0.0f,1.0f,0.0f,1.0f,true);
			}
			else Commands->Set_Lightning(0.0f,0.0f,1.0f,0.0f,1.0f,true);
		}
		if (CurrentClouds == Range)
		{
			Range = Commands->Get_Random(0,1);
			Commands->Start_Timer(obj,this,0.5f,0);
		}
		else Commands->Start_Timer(obj,this,0.5f,0);
	}
}

void KAK_Vehicle_Log::Created(GameObject *obj) {
	if (Settings->GameMode != 1 && !strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
		Commands->Destroy_Object(obj);
		return;
	}
	if (Settings->LogVehCreate) {
		char CreateMsg[512];
		sprintf(CreateMsg,"%s gebaut",Translate_Preset(obj));
		FDSMessage(CreateMsg,"_VEHICLE");
	}
	if (IsDisabled(obj)) {
		Commands->Destroy_Object(obj);
		return;
	}
	if (Settings->EnableVehicleDamageAnim) Commands->Attach_Script(obj,"KAK_Vehicle_Damage","");
}

void KAK_Vehicle_Log::Killed(GameObject *obj, GameObject *shooter)
{
	DeadPlace = Commands->Get_Position(obj);
	Facing = Commands->Get_Facing(obj);
	GameObject *DestroyedTank;
	if (Settings->LogHarvesterDeath && strstr(Commands->Get_Preset_Name(obj),"Harvester"))
	{
		char HarvMsg[512];
		if (Commands->Get_ID(shooter) == 0) sprintf(HarvMsg,"%s gesprengt",Translate_Preset(obj));
		else if (Is_Soldier(shooter)) sprintf(HarvMsg,"%s wurde verschrottet von %s (%s)",Translate_Preset(obj),Get_Player_Name(shooter),Translate_Preset(Get_Vehicle_Return(shooter)));
		else sprintf(HarvMsg,"%s zerstoert von %s",Translate_Preset(obj),Get_Preset_Info(shooter));
		FDSMessage(HarvMsg,"_VEHKILL");
	}
	else if (Settings->LogVehDeath)
	{
		char DeathMsg[512];
		if (Commands->Get_ID(shooter) == 0) sprintf(DeathMsg,"%s kaputt",Translate_Preset(obj));
		else if (Is_Soldier(shooter)) sprintf(DeathMsg,"%s is nun kaputt dank %s (%s)",Translate_Preset(obj),Get_Player_Name(shooter),Translate_Preset(Get_Vehicle_Return(shooter)));
		else sprintf(DeathMsg,"%s wurde verschrottet von %s",Translate_Preset(obj),Translate_Preset(shooter));
		FDSMessage(DeathMsg,"_VEHKILL");
	}
	Create_Sound_Team("M00_DIED0001EVAG_SND",Commands->Get_Position(obj),0,Commands->Get_Player_Type(obj));
	
	if (Settings->EnableVehicleWreckages) {
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee")) {
			DestroyedTank = Commands->Create_Object("GDI_Humm-vee_destroyed",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Vehicle_Death","1");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_APC")) {
			DestroyedTank = Commands->Create_Object("GDI_APC_Destroyed",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Vehicle_Death","1");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank")) {
			DestroyedTank = Commands->Create_Object("GDI_Medium_Tank_Destroyed",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Vehicle_Death","1");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy")) {
			DestroyedTank = Commands->Create_Object("Nod_Buggy_Destroyed",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Vehicle_Death","1");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank")) {
			DeadPlace.Z -= (float)1;
			DestroyedTank = Commands->Create_Object("Nod_Light_Tank_Destroyed",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Vehicle_Death","1");
		}
	}
	else if (Settings->PlayVehDeathAnim) {
			if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee")) {
				DestroyedTank = Commands->Create_Object("GDI_Humm-vee",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_APC")) {
				DestroyedTank = Commands->Create_Object("GDI_APC",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank")) {
				DestroyedTank = Commands->Create_Object("GDI_Medium_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy")) {
				DestroyedTank = Commands->Create_Object("Nod_Buggy",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank")) {
				DeadPlace.Z -= (float)1;
				DestroyedTank = Commands->Create_Object("Nod_Light_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
			}
	}

	if (Settings->PlayVehDeathAnim) {
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS")) {
			DestroyedTank = Commands->Create_Object("GDI_MRLS",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank")) {
			DestroyedTank = Commands->Create_Object("GDI_Mammoth_Tank",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport")) {
			DestroyedTank = Commands->Create_Object("GDI_Transport",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca")) {
			DestroyedTank = Commands->Create_Object("GDI_Orca",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester")) {
			DestroyedTank = Commands->Create_Object("GDI_Harvester",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_APC")) {
			DestroyedTank = Commands->Create_Object("Nod_APC",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery")) {
			DestroyedTank = Commands->Create_Object("Nod_Mobile_Artillery",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank")) {
			DestroyedTank = Commands->Create_Object("Nod_Flame_Tank",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank")) {
			DestroyedTank = Commands->Create_Object("Nod_Stealth_Tank",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport")) {
			DestroyedTank = Commands->Create_Object("Nod_Transport",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache")) {
			DestroyedTank = Commands->Create_Object("Nod_Apache",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester")) {
			DestroyedTank = Commands->Create_Object("Nod_Harvester",DeadPlace);
			Commands->Set_Facing(DestroyedTank,Facing);
			Commands->Attach_Script(DestroyedTank,"KAK_Destroy_Tank","");
		}
	}
}

void KAK_Destroy_Tank::Created(GameObject *obj) {
	Commands->Apply_Damage(obj,99999,"Death",0);
}

void KAK_Vehicle_Damage::Created(GameObject *obj) {
	IsFirstShow = false, IsSecondShow = false;
	NoExp1 = false, NoExp2 = false, IsStealth = false;
	Fire1ID = 0, Fire2ID = 0, Fire3ID = 0, Fire4ID = 0, Explosion1ID = 0, Explosion2ID = 0;
	TotalHealth = Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj);
	CurrentHealth = TotalHealth;
	if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0)
	{
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0)
	{
		IsStealth = true;
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0)
	{
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0)
	{
		Size = 2;
	}
	else
	{
		Size = 1;
	}
	Sent = true;
	if (Commands->Get_ID(obj) != 0) Commands->Start_Timer(obj,this,0.25f,1);
}

void KAK_Vehicle_Damage::Timer_Expired(GameObject *obj, int number)
{
	if (Commands->Get_ID(obj) != 0)
	{
		CurrentHealth = Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj);
		if (number == 1)
		{
			if (Sent)
			{
				if (CurrentHealth < (TotalHealth * 0.3))
				{
					IsSecondShow = true;
					IsFirstShow = true;
					NoExp1 = true;
					NoExp2 = true;
					GameObject *Fire1, *Fire2, *Fire3, *Fire4;
					if (strstr(Commands->Get_Preset_Name(obj),"Harvester"))
					{
						Fire1 = GVDA(4,0,obj);
						Fire2 = GVDA(4,0,obj);
						Fire3 = GVDA(4,0,obj);
						Fire4 = GVDA(4,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
						Fire2ID = Commands->Get_ID(Fire2);
						Fire3ID = Commands->Get_ID(Fire3);
						Fire4ID = Commands->Get_ID(Fire4);
					}
					else
					{
						Fire1 = GVDA(2,0,obj);
						Fire2 = GVDA(2,0,obj);
						Fire3 = GVDA(2,0,obj);
						Fire4 = GVDA(2,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
						Fire2ID = Commands->Get_ID(Fire2);
						Fire3ID = Commands->Get_ID(Fire3);
						Fire4ID = Commands->Get_ID(Fire4);
					}
					if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"muzzleb1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"seat");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"turret");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"wheelc03r");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"muzzlea1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
						Commands->Attach_To_Object_Bone(Fire2,obj,"seat0");
						Commands->Attach_To_Object_Bone(Fire3,obj,"rotor00");
						Commands->Attach_To_Object_Bone(Fire4,obj,"rotor00");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire2,obj,"AddedBone1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"clawbone03");
						Commands->Attach_To_Object_Bone(Fire4,obj,"wheelp04r");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea1");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0)
					{
						Commands->Destroy_Object(Fire1);
						Commands->Destroy_Object(Fire2);
						Commands->Destroy_Object(Fire3);
						Commands->Destroy_Object(Fire4);
						Fire1ID = 0;
						Fire2ID = 0;
						Fire3ID = 0;
						Fire4ID = 0;
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire2,obj,"seat1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire4,obj,"rotor01");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"taillight.01");
						Commands->Attach_To_Object_Bone(Fire3,obj,"seat0");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
				}
				else if (CurrentHealth < (TotalHealth * 0.6))
				{
					IsFirstShow = true;	
					NoExp1 = true;
					GameObject *Fire1 = 0;
					if (strstr(Commands->Get_Preset_Name(obj),"Harvester"))
					{
						Fire1 = GVDA(4,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
					}
					else
					{
						Fire1 = GVDA(2,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
					}
					if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0)
					{
						Commands->Destroy_Object(Fire1);
						Fire1ID = 0;
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0)
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else
					{
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
				}
				if (Commands->Get_ID(obj) != 0) Commands->Start_Timer(obj,this,0.1f,2);
			}
			Sent = false;
		}
		else if (number == 2)
		{
			if (CurrentHealth >= (TotalHealth * 0.3) && IsSecondShow == true)
			{
				IsSecondShow = false;

				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire2ID));
				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire3ID));
				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire4ID));
				if (!NoExp2) Commands->Destroy_Object(Commands->Find_Object(Explosion2ID));
				Fire2ID = 0;
				Fire3ID = 0;
				Fire4ID = 0;
				Explosion2ID = 0;
			}
			else if (CurrentHealth >= (TotalHealth * 0.6) && IsFirstShow == true)
			{
				IsFirstShow = false;

				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire1ID));
				if (!NoExp1) Commands->Destroy_Object(Commands->Find_Object(Explosion1ID));
				Fire1ID = 0;
				Explosion1ID = 0;
			}
			else if (CurrentHealth == TotalHealth)
			{
				IsSecondShow = false;
				IsFirstShow = false;
			}
			else if (CurrentHealth < (TotalHealth * 0.3) && IsSecondShow == false)
			{
				IsSecondShow = true;
				NoExp2 = false;
				GameObject *Fire2 = 0, *Fire3 = 0, *Fire4 = 0, *Explosion2 = 0;
				if (strstr(Commands->Get_Preset_Name(obj),"Harvester"))
				{
					Fire2 = GVDA(4,0,obj);
					Fire3 = GVDA(4,0,obj);
					Fire4 = GVDA(4,0,obj);
					Fire2ID = Commands->Get_ID(Fire2);
					Fire3ID = Commands->Get_ID(Fire3);
					Fire4ID = Commands->Get_ID(Fire4);
				}
				else
				{
					Fire2 = GVDA(2,0,obj);
					Fire3 = GVDA(2,0,obj);
					Fire4 = GVDA(2,0,obj);
					Fire2ID = Commands->Get_ID(Fire2);
					Fire3ID = Commands->Get_ID(Fire3);
					Fire4ID = Commands->Get_ID(Fire4);
				}
				Explosion2 = GVDA(1,Size,obj);
				Explosion2ID = Commands->Get_ID(Explosion2);
				if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"muzzleb1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"seat");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelc03r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"turret");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"taillight01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"wheelc03r");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelc03r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"muzzlea1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"seat0");
					Commands->Attach_To_Object_Bone(Fire3,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Fire4,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelp01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"AddedBone1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"clawbone03");
					Commands->Attach_To_Object_Bone(Fire4,obj,"wheelp04r");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea1");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0)
				{
					Commands->Destroy_Object(Fire2);
					Commands->Destroy_Object(Fire3);
					Commands->Destroy_Object(Fire4);
					Commands->Attach_To_Object_Bone(Explosion2,obj,"muzzlea1");
					Fire2ID = 0;
					Fire3ID = 0;
					Fire4ID = 0;
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"seat1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Fire4,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelp02");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"engineangle00");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"taillight.01");
					Commands->Attach_To_Object_Bone(Fire3,obj,"seat0");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"taillight.01");
				}
				else
				{
					Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"barrel");
				}
			}
			else if (CurrentHealth < (TotalHealth * 0.6) && IsFirstShow == false)
			{
				IsFirstShow = true;
				NoExp1 = false;
				GameObject *Fire1 = 0, *Explosion1 = 0;
				if (strstr(Commands->Get_Preset_Name(obj),"Harvester"))
				{
					Fire1 = GVDA(4,0,obj);
					Fire1ID = Commands->Get_ID(Fire1);
				}
				else
				{
					Fire1 = GVDA(2,0,obj);
					Fire1ID = Commands->Get_ID(Fire1);
				}
				Explosion1 = GVDA(1,Size,obj);
				Explosion1ID = Commands->Get_ID(Explosion1);
				if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"seat");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"AddedBone4");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"headlight01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"muzzlea1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"engineflame01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp04r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp06e");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0)
				{
					Commands->Destroy_Object(Fire1);
					Fire1ID = 0;
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp02l");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor00");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0)
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"AddedBone3");
				}
				else
				{
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
			}
			Commands->Start_Timer(obj,this,0.3f,2);
		}
	}
}

void KAK_Vehicle_Damage::Destroyed(GameObject *obj)
{
		if (Commands->Find_Object(Fire1ID)) Commands->Destroy_Object(Commands->Find_Object(Fire1ID));
		if (Commands->Find_Object(Fire2ID)) Commands->Destroy_Object(Commands->Find_Object(Fire2ID));
		if (Commands->Find_Object(Fire3ID)) Commands->Destroy_Object(Commands->Find_Object(Fire3ID));
		if (Commands->Find_Object(Fire4ID)) Commands->Destroy_Object(Commands->Find_Object(Fire4ID));
		if (Commands->Find_Object(Explosion1ID)) Commands->Destroy_Object(Commands->Find_Object(Explosion1ID));
		if (Commands->Find_Object(Explosion2ID)) Commands->Destroy_Object(Commands->Find_Object(Explosion2ID));
}

void KAK_Obelisk_Powerup::Created(GameObject *obj)
{
	IsPowerup = false;
	ObGlitchCount = 0;
	LastID = 0;
}

void KAK_Obelisk_Powerup::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == 2 && IsPowerup == false)
	{
		IsPowerup = true;
		Powerup = Commands->Create_Object("Obelisk Effect",Commands->Get_Position(obj));
		Commands->Create_Sound("Obelisk_Warm_Up",Commands->Get_Position(obj),0);
		Commands->Start_Timer(obj,this,3.0f,1);
		if (strstr(Commands->Get_Preset_Name(Commands->Find_Object(param)),"estroyed"))
		{
			Commands->Apply_Damage(Commands->Find_Object(param),99999,"Death",false);
		}
		if (Settings->OBGEnable)
		{
			if (LastID == param)
			{
				ObGlitchCount++;
				if (ObGlitchCount >= 10)
				{
					char message[50], message2[50], FDSM[100];
					sprintf(message,"kick %s",Get_Player_Name(Commands->Find_Object(param)));
					sprintf(message2,"allow %s",Get_Player_Name(Commands->Find_Object(param)));
					sprintf(FDSM,"%s wurde gekickt wegen zuviel Obelisk Ausnutzung",Get_Player_Name(Commands->Find_Object(param)));
					Console_Input(message);
					Console_Input(message2);
					FDSMessage(FDSM,"_ALERT");
				}
				else if (ObGlitchCount >= 8)
				{
					char message[256], FDSM[100];
					sprintf(message,"page %s %s",Get_Player_Name(Commands->Find_Object(param)),Settings->OBGPageMessage);
					sprintf(FDSM,"Spieler %s wurde angewiesen, aus der Reichweite des Obelisken zu gehen",Get_Player_Name(Commands->Find_Object(param)));
					Console_Input(message);
					FDSMessage(FDSM,"_ALERT");
				}
			}
			else
			{
				LastID = param;
				ObGlitchCount = 0;
			}
		}
	}
}

void KAK_Obelisk_Powerup::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		if (Commands->Get_ID(Powerup) != 0) Commands->Destroy_Object(Powerup);
		IsPowerup = false;
	}
}

void M00_PCT_Pokable_DAK::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void M00_PCT_Pokable_DAK::Killed(GameObject *obj, GameObject *shooter)
{
	Commands->Create_Object(Commands->Get_Preset_Name(obj),Commands->Get_Position(obj));
}

void M00_PCT_Pokable_DAK::Poked(GameObject *obj, GameObject *poker) {
	Commands->Start_Timer(obj,this,0.5,Get_Player_ID(poker));
}

void M00_PCT_Pokable_DAK::Timer_Expired(GameObject *obj, int number) {
	if (number > 0 && number <= (int)The_Game()->MaxPlayers) {
		if (Get_Vehicle(Commands->Find_Object(number))) {
			char Eject[20];
			sprintf(Eject,"eject %d",number);
			Console_Input(Eject);
		}
	}
}

void KAK_CargoPlane_Sounds::Created(GameObject *obj)
{
	Commands->Create_3D_WAV_Sound_At_Bone("c130_loop.wav",obj,"Cargo");
	Commands->Start_Timer(obj,this,0.1f,1);
}

void KAK_CargoPlane_Sounds::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Commands->Create_3D_WAV_Sound_At_Bone("c130_loop.wav",obj,"Cargo");
		Commands->Start_Timer(obj,this,0.1f,1);
	}
}

void KAK_CargoPlane_Sounds::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void KAK_Disable_List::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,5.0f,1);
}

void KAK_Disable_List::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		if (Settings->DisableBaseDefenses)
		{
			Commands->Apply_Damage(Find_Base_Defense(0),99999,"None",false);
			Commands->Apply_Damage(Find_Base_Defense(1),99999,"None",false);
		}
		if (Settings->DisablePowerPlants)
		{
			Commands->Apply_Damage(Find_Power_Plant(0),99999,"None",false);
			Commands->Apply_Damage(Find_Power_Plant(1),99999,"None",false);
		}
		if (Settings->DisableRefineries)
		{
			Commands->Apply_Damage(Find_Refinery(0),99999,"None",false);
			Commands->Apply_Damage(Find_Refinery(1),99999,"None",false);
		}
		if (Settings->DisableSoldierFactories)
		{
			Commands->Apply_Damage(Find_Soldier_Factory(0),99999,"None",false);
			Commands->Apply_Damage(Find_Soldier_Factory(1),99999,"None",false);
		}
		if (Settings->DisableVehicleFactories)
		{
			Commands->Apply_Damage(Find_Vehicle_Factory(0),99999,"None",false);
			Commands->Apply_Damage(Find_Vehicle_Factory(1),99999,"None",false);
		}
		if (Settings->DisableRepairPads)
		{
			Commands->Apply_Damage(Find_Repair_Bay(0),99999,"None",false);
			Commands->Apply_Damage(Find_Repair_Bay(1),99999,"None",false);
		}
		if (Settings->DisableCommCenters)
		{
			Commands->Apply_Damage(Find_Com_Center(0),99999,"None",false);
			Commands->Apply_Damage(Find_Com_Center(1),99999,"None",false);
		}
		Commands->Start_Timer(obj,this,5.0f,1);
	}
}

void KAK_Vehicle_Death::Created(GameObject *obj)
{
	Set_Max_Health(obj,Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj));
	Set_Max_Shield_Strength(obj,0);
	Commands->Set_Health(obj,100);
	Commands->Disable_All_Collisions(obj);
	if (Settings->DefenseShell)
	{
		Commands->Set_Player_Type(obj,2);
	}
	else
	{
		Commands->Set_Player_Type(obj,-2);
	}
}

void KAK_Vehicle_Death::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if (damage < 0)
	{
		if (Commands->Get_Player_Type(obj) == 2)
		{
			if (damage == -2.0f) Commands->Give_Points(damager,1.0f,false);
			else if (damage <= -4.0f) Commands->Give_Points(damager,2.0f,false);
		}
		if (Commands->Get_Health(obj) == Commands->Get_Max_Health(obj))
		{	
			DeadPlace = Commands->Get_Position(obj);
			DeadPlace.Z += 2.0f;
			Facing = Commands->Get_Facing(obj);
			Vector3 Move;
			Move.X = 4000.0f;
			Move.Y = 4000.0f;
			Move.Z = -999.0f;
			Commands->Set_Position(obj,Move);
			if (strstr(Commands->Get_Preset_Name(obj),"GDI_Humm-vee_destroyed"))
			{
				DeadPlace.Z += (float)1;
				DestroyedTank = Commands->Create_Object("CnC_GDI_Humm-vee",DeadPlace);
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"GDI_APC_Destroyed"))
			{
				DeadPlace.Z += (float)1;
				DestroyedTank = Commands->Create_Object("CnC_GDI_APC",DeadPlace);
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"GDI_Medium_Tank_Destroyed"))
			{
				DestroyedTank = Commands->Create_Object("CnC_GDI_Medium_Tank",DeadPlace);
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"Nod_Buggy_Destroyed"))
			{
				DeadPlace.Z += (float)1;
				DestroyedTank = Commands->Create_Object("CnC_Nod_Buggy",DeadPlace);
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"Nod_Light_Tank_Destroyed"))
			{
				DeadPlace.Z += (float)1;
				DestroyedTank = Commands->Create_Object("CnC_Nod_Light_Tank",DeadPlace);
				
			}
			Commands->Set_Facing(DestroyedTank,Facing);
			Damage_All_Objects_Area(999999.0f,"Laser_NoBuilding",DeadPlace,5.0f,DestroyedTank,0);
			Commands->Set_Health(DestroyedTank,1);
			Commands->Set_Shield_Strength(DestroyedTank,0);
			Commands->Set_Player_Type(DestroyedTank,-2);
			Commands->Destroy_Object(obj);
		}
	}
}

void MDB_Block_Refill::Created(GameObject *obj)
{
	currhealth = Commands->Get_Health(obj);
	currshield = Commands->Get_Shield_Strength(obj);
	Commands->Start_Timer(obj,this,0.5f,59);
	LastDamage = The_Game()->GameDuration_Seconds;
}

void MDB_Block_Refill::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	currhealth = Commands->Get_Health(obj);
	currshield = Commands->Get_Shield_Strength(obj);
	if (damage > 0.0) LastDamage = The_Game()->GameDuration_Seconds;
}

void MDB_Block_Refill::Timer_Expired(GameObject *obj, int number)
{
	if (number == 59)
	{
		if (Commands->Get_Health(obj) > currhealth || Commands->Get_Shield_Strength(obj) > currshield)
		{
			if (Get_Int_Parameter("All") == 1)
			{
				Commands->Set_Health(obj,currhealth);
				Commands->Set_Shield_Strength(obj,currshield);
			}
			else if (Get_Int_Parameter("All") == 0 && (The_Game()->GameDuration_Seconds - LastDamage) <= Settings->RefillTime)
			{
				Commands->Set_Health(obj,currhealth);
				Commands->Set_Shield_Strength(obj,currshield);
			}
		}
		Commands->Start_Timer(obj,this,0.5f,59);
	}
}

void MDB_Vehicle_Owner::Created(GameObject *obj)
{
	IsLocked = false;
	Team = Get_Int_Parameter("Team");
	if (GetIconBone(Commands->Get_Preset_Name(obj),1))
	{
		GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),1));
		Commands->Set_Model(Icon,"o_em_apc");
		Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(Commands->Get_Preset_Name(obj),1));
		IconID = Commands->Get_ID(Icon);
	}
	else
	{
		IconID = 0;
	}
	if (GetIconBone(Commands->Get_Preset_Name(obj),2))
	{
		GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),2));
		Commands->Set_Model(Icon2,"o_em_apc");
		Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(Commands->Get_Preset_Name(obj),2));
		IconID2 = Commands->Get_ID(Icon2);
	}
	else
	{
		IconID2 = 0;
	}
}

void MDB_Vehicle_Owner::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == 1111)
	{
		Commands->Destroy_Object(Commands->Find_Object(IconID));
		Commands->Destroy_Object(Commands->Find_Object(IconID2));
		Destroy_Script();
	}
	else if (message == 1112)
	{
		IsLocked = true;
		Commands->Set_Player_Type(obj,Team);
		if (Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) != MyOwner(3)) Force_Occupant_Exit(obj,0);
		if (GetIconBone(Commands->Get_Preset_Name(obj),1))
		{
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),1));
			Commands->Set_Model(Icon,"p_keycrd_red");
			Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(Commands->Get_Preset_Name(obj),1));
			IconID = Commands->Get_ID(Icon);
		}
		if (GetIconBone(Commands->Get_Preset_Name(obj),2))
		{
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),2));
			Commands->Set_Model(Icon2,"p_keycrd_red");
			Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(Commands->Get_Preset_Name(obj),2));
			IconID2 = Commands->Get_ID(Icon2);
		}
	}
	else if (message == 1113)
	{
		IsLocked = false;
		if (GetIconBone(Commands->Get_Preset_Name(obj),1))
		{
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),1));
			Commands->Set_Model(Icon,"o_em_apc");
			Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(Commands->Get_Preset_Name(obj),1));
			IconID = Commands->Get_ID(Icon);
		}
		if (GetIconBone(Commands->Get_Preset_Name(obj),2))
		{
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(Commands->Get_Preset_Name(obj),2));
			Commands->Set_Model(Icon2,"o_em_apc");
			Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(Commands->Get_Preset_Name(obj),2));
			IconID2 = Commands->Get_ID(Icon2);
		}
	}
	else if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (Commands->Get_Player_Type(sender) != Team)
		{
			sprintf(msg,"ppage %d Der Feind hat dein Auto geklaut!",MyOwner(2));
			Console_Input(msg);
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			Destroy_Script();
		}
		else if (IsLocked && Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) == Commands->Get_ID(sender) && Commands->Get_ID(sender) != MyOwner(3))
		{
			Commands->Start_Timer(obj,this,0.5f,3);
			sprintf(msg,"pamsg %d Das Auto wurde von %s verschlossen.",Get_Player_ID(sender),Get_Player_Name_By_ID(MyOwner(2)));
			Console_Input(msg);
		}
		else if (Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) == Commands->Get_ID(sender) && Commands->Get_ID(sender) != MyOwner(3))
		{
			sprintf(msg,"ppage %d Warnung! %s ist in deinem Auto. Tipp !vkick im F3-Chat, um ihn rauszuwerfen.",MyOwner(2),Get_Player_Name(sender));
			Console_Input(msg);
		}
	}
	else if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (IsLocked)
		{
			Commands->Start_Timer(obj,this,0.5f,2);
		}
	}
}

void MDB_Vehicle_Owner::Killed(GameObject *obj, GameObject *shooter)
{
	sprintf(msg,"ppage %d Dein Auto wurde zerstoert.",MyOwner(2));
	Console_Input(msg);
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
	Destroy_Script();
}

void MDB_Vehicle_Owner::Destroyed(GameObject *obj)
{
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
}

void MDB_Vehicle_Owner::Detach(GameObject *obj)
{
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
}

void MDB_Vehicle_Owner::Timer_Expired(GameObject *obj, int number)
{
	if (number == 2)
	{
		Commands->Set_Player_Type(obj,Team);
	}
	else if (number == 3)
	{
		Force_Occupant_Exit(obj,0);
	}
}

int MDB_Vehicle_Owner::MyOwner(int Type)
{
	if (Type == 2)
	{
		return Get_Player_ID(Commands->Find_Object(Get_Int_Parameter("ID")));
	}
	else if (Type == 3)
	{
		return Get_Int_Parameter("ID");
	}
	return 0;
}

void MDB_Spawn_Weapon::Created(GameObject *obj)
{
	if (!Settings->SpawnWeap || Settings->GameMode == 3 || Settings->GameMode == 4)
	{
		Commands->Destroy_Object(obj);
	}
	if (IsDisabled(obj)) {
		Commands->Destroy_Object(obj);
		return;
	}
}

void MDB_Destroy_When_Object_Destroyed::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,1.0,99);
	ID = Get_Int_Parameter("ID");
}

void MDB_Destroy_When_Object_Destroyed::Timer_Expired(GameObject *obj, int number)
{
	if (number == 99)
	{
		if (ID == 0 || Commands->Find_Object(ID) == 0 || Commands->Get_Health(Commands->Find_Object(ID)) == 0)
		{
			Commands->Destroy_Object(obj);
		}
		else
		{
			Commands->Start_Timer(obj,this,1.0,99);
		}
	}
}


void MDB_Manager::Created(GameObject *obj) {
	if (Settings->BWDetector) Commands->Start_Timer(obj,this,60.0f,1);
}

void MDB_Manager::Destroyed(GameObject *obj) {
	/*
	if (FirstObject == false) {
		FirstObject = true;
		RecognizeMap(false);
	}*/
}

void MDB_Manager::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		CheckBW();
		Commands->Start_Timer(obj,this,30.0f,1);
	}
}

ScriptRegistrant<M00_BUILDING_EXPLODE_NO_DAMAGE_DAK> M00_BUILDING_EXPLODE_NO_DAMAGE_DAK_Registrant("M00_BUILDING_EXPLODE_NO_DAMAGE_DAK","");
ScriptRegistrant<M00_Disable_Transition> M00_Disable_Transition_Registrant("M00_Disable_Transition","");
ScriptRegistrant<M00_GrantPowerup_Created> M00_GrantPowerup_Created_Registrant("M00_GrantPowerup_Created","WeaponDef:string");
ScriptRegistrant<KAK_Beacon_Log> KAK_Beacon_Log_Registrant("KAK_Beacon_Log","");
ScriptRegistrant<KAK_Beacon_Log_CreateControl> KAK_Beacon_Log_CreateControl_Registrant("KAK_Beacon_Log_CreateControl","Beacon:string,ID:int,Planter:string");
ScriptRegistrant<KAK_Beacon_Animation_Log> KAK_Beacon_Animation_Log_Registrant("KAK_Beacon_Animation_Log","");
ScriptRegistrant<KAK_Random_Weather> KAK_Random_Weather_Registrant("KAK_Random_Weather","");
ScriptRegistrant<KAK_Vehicle_Log> KAK_Vehicle_Log_Registrant("KAK_Vehicle_Log","");
ScriptRegistrant<KAK_Destroy_Tank> KAK_Destroy_Tank_Registrant("KAK_Destroy_Tank","");
ScriptRegistrant<KAK_Vehicle_Damage> KAK_Vehicle_Damage_Registrant("KAK_Vehicle_Damage","");
ScriptRegistrant<KAK_Obelisk_Powerup> KAK_Obelisk_Powerup_Registrant("KAK_Obelisk_Powerup","");
ScriptRegistrant<M00_PCT_Pokable_DAK> M00_PCT_Pokable_DAK_Registrant("M00_PCT_Pokable_DAK","");
ScriptRegistrant<KAK_CargoPlane_Sounds> KAK_CargoPlane_Sounds_Registrant("KAK_CargoPlane_Sounds","");
ScriptRegistrant<KAK_Disable_List> KAK_Disable_List_Registrant("KAK_Disable_List","");
ScriptRegistrant<KAK_Drop_Weapon> KAK_Drop_Weapon_Registrant("KAK_Drop_Weapon","");
ScriptRegistrant<KAK_Vehicle_Death> KAK_Vehicle_Death_Registrant("KAK_Vehicle_Death","DisablePhysics:int");
ScriptRegistrant<MDB_Block_Refill> MDB_Block_Refill_Registrant("MDB_Block_Refill","All=1:int");
ScriptRegistrant<MDB_Vehicle_Owner> MDB_Vehicle_Owner_Registrant("MDB_Vehicle_Owner","ID:int,Team:int");
ScriptRegistrant<MDB_Spawn_Weapon> MDB_Spawn_Weapon_Registrant("MDB_Spawn_Weapon","");
ScriptRegistrant<MDB_Destroy_When_Object_Destroyed> MDB_Destroy_When_Object_Destroyed_Registrant("MDB_Destroy_When_Object_Destroyed","ID=0:int");
ScriptRegistrant<MDB_Manager> MDB_Manager_Registrant("MDB_Manager","");
