#
# AUTH ATTACH PLUGIN for BRenBot 1.52 by Daniel Paul
# Version 1.00
#
package auth_attach;

use POE;
use plugin;
use strict;

# define additional events in the POE session

our %additional_events =
(
	# !commands
	"auth" => "auth",
);

# plugin_name and config are automatically given data by BRenBot
our $plugin_name;
our %config;
my $pluginVersion = 1.00;



########### Functions for !commands

# Function for !auth command
sub auth
{
	my %args = %{$_[ ARG0 ]};

	# Is the player already authed?
	my ( $result, %player ) = plugin::getPlayerData($args{'nick'});
	if ( $result == 1 && (!defined($player{'isAuthed'}) || $player{'isAuthed'} != 1) )
	{
		# Call the real auth command
		commands::auth(@_);

		# Are they now authed?
		( $result, %player ) = plugin::getPlayerData($args{'nick'});
		if ( $result == 1 && defined($player{'isAuthed'}) && $player{'isAuthed'} == 1 )
		{
			# Is the player some type of moderator?
			if ( plugin::isAdmin($player{'id'}) || plugin::isFullMod($player{'id'}) || plugin::isHalfMod($player{'id'}) || plugin::isTempMod($player{'id'}) )
			{
				# Attach script
				plugin::RenRemCMD('attach $player{id} auth_script');
			}
		}
	}
}



########### Event handlers

# Runs when BRenBot loads the plugin
sub start
{
	# Set our current version in the globals table
	plugin::set_global ( "version_plugin_auth_attach", $pluginVersion );
}

# Runs when BRenBot shuts down
sub stop
{
}

# Runs when a !command specified in the .xml file is typed
sub command
{
	# trigger on !commands
	my $kernel = $_[KERNEL];
	my %args = %{$_[ ARG0 ]};

	if ( $args{command} eq "auth" )
	{
		$kernel->yield("auth" => \%args);
	}
}

1;
