/*********
Horizontal bloom filter
Use with BloomPostProccessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

static const int g_cKernelSize = 7;

float2 PixelKernel[g_cKernelSize] =
{
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
};

float2 TexelKernel[g_cKernelSize]
<
    string ConvertPixelsToTexels = "PixelKernel";
>;

static const float BlurWeights[g_cKernelSize] = 
{
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
};

float BloomScale: BloomScale = 1.5f;

float4 PostProcessPS(float2 Tex: TEXCOORD0) : COLOR0
{
    float4 Color = 0;

    for (int i = 0; i < g_cKernelSize; i++)
    {    
        Color += tex2D(InputBufferSampler, Tex + TexelKernel[i].xy) * BlurWeights[i];
    }

    return Color * BloomScale;
}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_2_0 PostProcessPS();
    }
}
